/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.DefaultDuplocatorState;
import com.intellij.dupLocator.ExternalizableDuplocatorState;
import com.intellij.lang.Language;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="MultiLanguageDuplocatorSettings", storages={@Storage(value="duplocatorSettings.xml")})
public class MultilanguageDuplocatorSettings
implements PersistentStateComponent<Element> {
    private final Map<String, DefaultDuplocatorState> mySettingsMap = new TreeMap<String, DefaultDuplocatorState>();

    public static MultilanguageDuplocatorSettings getInstance() {
        return (MultilanguageDuplocatorSettings)ServiceManager.getService(MultilanguageDuplocatorSettings.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerState(@NotNull Language language, @NotNull DefaultDuplocatorState state) {
        Map<String, DefaultDuplocatorState> map2 = this.mySettingsMap;
        synchronized (map2) {
            this.mySettingsMap.put(language.getDisplayName(), state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultDuplocatorState getState(@NotNull Language language) {
        Map<String, DefaultDuplocatorState> map2 = this.mySettingsMap;
        synchronized (map2) {
            return this.mySettingsMap.get(language.getDisplayName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getState() {
        Map<String, DefaultDuplocatorState> map2 = this.mySettingsMap;
        synchronized (map2) {
            Element state = new Element("state");
            if (this.mySettingsMap.isEmpty()) {
                return state;
            }
            SkipDefaultValuesSerializationFilters filter = new SkipDefaultValuesSerializationFilters();
            for (String name : this.mySettingsMap.keySet()) {
                Element child = XmlSerializer.serializeIfNotDefault((Object)this.mySettingsMap.get(name), (SerializationFilter)filter);
                if (child == null) continue;
                child.setName("object");
                child.setAttribute("language", name);
                state.addContent(child);
            }
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element state) {
        Map<String, DefaultDuplocatorState> map2 = this.mySettingsMap;
        synchronized (map2) {
            for (Element objectElement : state.getChildren("object")) {
                ExternalizableDuplocatorState stateObject;
                String language = objectElement.getAttributeValue("language");
                if (language == null || (stateObject = (ExternalizableDuplocatorState)this.mySettingsMap.get(language)) == null) continue;
                XmlSerializer.deserializeInto((Object)stateObject, (Element)objectElement);
            }
        }
    }
}

