/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFoldingPolicyTest
extends BasePlatformTestCase {
    protected void doTest(@NotNull String text, @NotNull String ext) {
        this.myFixture.configureByText("test." + ext, text);
        CodeFoldingManager.getInstance((Project)this.getProject()).buildInitialFoldings(this.myFixture.getEditor());
        EditorFoldingInfo info = EditorFoldingInfo.get((Editor)this.myFixture.getEditor());
        FoldRegion[] foldRegions = this.myFixture.getEditor().getFoldingModel().getAllFoldRegions();
        AbstractFoldingPolicyTest.assertTrue((foldRegions.length > 0 ? 1 : 0) != 0);
        for (FoldRegion region2 : foldRegions) {
            PsiElement element = info.getPsiElement(region2);
            if (element == null) continue;
            String signature = FoldingPolicy.getSignature((PsiElement)element);
            AbstractFoldingPolicyTest.assertNotNull((Object)signature);
            AbstractFoldingPolicyTest.assertEquals((Object)element, (Object)FoldingPolicy.restoreBySignature((PsiFile)element.getContainingFile(), (String)signature));
        }
    }
}

