/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.documentation;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.documentation.CidrDocumentationProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CidrDocumentationTestUtil {
    public static void assertDoc(@NotNull DocumentationProvider provider, @Nullable PsiElement element, @Nullable PsiElement originalElement, @Nullable String token, boolean shouldBeValidXML, boolean shouldContainFragments, String ... docFragments) throws ParserConfigurationException, SAXException, IOException {
        String doc = provider.generateDoc(element, originalElement);
        CidrDocumentationTestUtil.assertDoc(doc, element, originalElement, token, shouldContainFragments, docFragments);
        if (shouldBeValidXML) {
            CidrDocumentationTestUtil.assertDocIsWellFormed(doc);
        }
    }

    public static void assertDoc(@NotNull String doc, @Nullable PsiElement element, @Nullable PsiElement originalElement, @Nullable String token, boolean shouldContainFragments, String @NotNull [] docFragments) {
        Assert.assertNotNull((Object)doc);
        String info = CidrDocumentationTestUtil.getInfo(element, originalElement);
        if (token != null) {
            Assert.assertTrue((String)(info + "doc does not contain token: \n" + token + "\n\nactual doc:\n" + doc), (boolean)doc.contains(StringUtil.escapeXmlEntities((String)token)));
        }
        for (String docFragment : docFragments) {
            Assert.assertTrue((String)(info + "doc " + (shouldContainFragments ? "does not contain" : "contains") + " fragment:\n" + docFragment + "\n\nactual doc:\n" + doc), (shouldContainFragments == doc.contains(docFragment) ? 1 : 0) != 0);
        }
    }

    @NotNull
    private static String getInfo(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        return "element: " + (element == null ? "null" : element.toString()) + ", original: " + (originalElement == null ? "null" : originalElement.toString()) + "\n";
    }

    public static void assertDoc(Pair<PsiElement, PsiElement> es, String ... docFragments) throws Exception {
        CidrDocumentationTestUtil.assertDocForToken(es, ((PsiElement)es.second).getText(), docFragments);
    }

    public static void assertDocForToken(Pair<PsiElement, PsiElement> es, String token, String ... docFragments) throws Exception {
        CidrDocumentationTestUtil.assertDoc((PsiElement)es.first, (PsiElement)es.second, token, docFragments);
        CidrDocumentationTestUtil.assertDoc((PsiElement)es.first, null, token, docFragments);
    }

    public static void assertDoc(PsiElement element, PsiElement originalElement, String token, String ... docFragments) throws ParserConfigurationException, SAXException, IOException {
        CidrDocumentationTestUtil.assertDoc(element, originalElement, token, true, docFragments);
    }

    public static void assertDoc(PsiElement element, PsiElement originalElement, String token, boolean shouldBeValidXML, String ... docFragments) throws ParserConfigurationException, SAXException, IOException {
        CidrDocumentationTestUtil.assertDoc((DocumentationProvider)new CidrDocumentationProvider(), element, originalElement, token, shouldBeValidXML, true, docFragments);
    }

    private static void assertDocIsWellFormed(@NotNull String doc) throws ParserConfigurationException, SAXException, IOException {
        final String xml = doc.replaceAll("<br>", "<br/>");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) {
                Assert.fail((String)("doc is not well formed: " + xml + "(" + exception.getLocalizedMessage() + ")"));
            }

            @Override
            public void error(SAXParseException exception) {
                Assert.fail((String)("doc is not well formed: " + xml + "(" + exception.getLocalizedMessage() + ")"));
            }

            @Override
            public void fatalError(SAXParseException exception) {
                Assert.fail((String)("doc is not well formed: " + xml + "(" + exception.getLocalizedMessage() + ")"));
            }
        });
        builder.parse(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
    }

    public static Pair<PsiElement, PsiElement> configure(CidrCodeInsightFixture fixture, String code, String fileName) {
        return CidrDocumentationTestUtil.configure(fixture, code, fileName, true);
    }

    public static Pair<PsiElement, PsiElement> configure(CidrCodeInsightFixture fixture, String code, OCLanguageKind lang, boolean checkElements) {
        return CidrDocumentationTestUtil.configure(fixture, code, "test." + lang.getDefaultSourceExtension(), checkElements);
    }

    public static Pair<PsiElement, PsiElement> configure(CidrCodeInsightFixture fixture, String code, String fileName, boolean checkElements) {
        Object file2 = fixture.configureByText(code, fileName);
        int caretOffset = fixture.getCaretOffset();
        PsiElement elementAtCaret = fixture.getFile().findElementAt(caretOffset);
        DocumentationManager manager = DocumentationManager.getInstance((Project)fixture.getProject());
        PsiElement element = manager.findTargetElement(fixture.getEditor(), file2);
        if (checkElements) {
            TestCase.assertNotNull((Object)elementAtCaret);
            TestCase.assertNotNull((Object)element);
        }
        return Pair.create((Object)element, (Object)elementAtCaret);
    }
}

