/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.xdebugger.XDebuggerAssertions;
import com.intellij.xdebugger.XDebuggerTestUtil;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.jetbrains.cidr.CidrDebugProjectMarkup;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestBundle;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingWithDebugProjectTestCase;
import com.jetbrains.cidr.execution.debugger.DebuggerDriverKind;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import icons.CidrDebuggerIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import javax.swing.Icon;

public abstract class CidrDebuggingValuesTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>>
extends CidrDebuggingWithDebugProjectTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE> {
    public CidrDebuggingValuesTestCase(String targetName, DebuggerDriverKind backend, String fixtureProjectFileRelativePath) {
        super(backend, targetName, fixtureProjectFileRelativePath);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.waitForResolve();
    }

    public void testBasicValues() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_VALUES);
        this.startDebugSessionAndWaitForPause("values");
        List<XValue> vars = this.collectVars(0);
        XDebuggerAssertions.assertVariableValue(vars, (String)"i", (String)"1");
        XDebuggerAssertions.assertVariable(vars, (String)"voidPtr", (String)"void *", null, (Boolean)this.selectDriver(false, true));
        XDebuggerAssertions.assertVariableValueMatches(vars, (String)"voidPtr", (String)"0x\\p{XDigit}+");
    }

    public void testZeroValues() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_ZERO_VALUES);
        this.startDebugSessionAndWaitForPause("zero_values");
        List<XValue> vars = this.collectVars(0);
        XDebuggerAssertions.assertVariableValue(vars, (String)"int_var", (String)"0");
        XDebuggerAssertions.assertVariableValue(vars, (String)"int_t_var", (String)"0");
        XDebuggerAssertions.assertVariableValue(vars, (String)"int_t_t_var", (String)"0");
        XDebuggerAssertions.assertVariableValue(vars, (String)"int_p_var", (String)"NULL");
        XDebuggerAssertions.assertVariableValue(vars, (String)"int_t_p_var", (String)"NULL");
        XDebuggerAssertions.assertVariableValue(vars, (String)"pint_t_var", (String)"NULL");
        XDebuggerAssertions.assertVariableValue(vars, (String)"char_p_var", (String)"NULL");
        XDebuggerAssertions.assertVariableValue(vars, (String)"char_t_p_var", (String)"NULL");
        XDebuggerAssertions.assertVariableValue(vars, (String)"pchar_t_var", (String)"NULL");
    }

    public void testIntValues() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_INT_VALUES);
        this.startDebugSessionAndWaitForPause("int_values");
        boolean isBadCharset = this.isMinGWWithCP1252Charset();
        List<XValue> vars = this.collectVars(0);
        XDebuggerAssertions.assertVariableValue(vars, (String)"int8", (String)"64 '@'");
        XDebuggerAssertions.assertVariableValue(vars, (String)"uint8", (String)"65 'A'");
        if (!isBadCharset) {
            XDebuggerAssertions.assertVariableValue(vars, (String)"int8_neg", (String)("-75 " + this.selectDriver("'\\265'", "'\\xb5'")));
        }
        if (!isBadCharset) {
            XDebuggerAssertions.assertVariableValue(vars, (String)"uint8_big", (String)("240 " + this.selectDriver("'\\360'", "'\\xf0'")));
        }
        XDebuggerAssertions.assertVariableValue(vars, (String)"ch", (String)"66 'B'");
        XDebuggerAssertions.assertVariableValue(vars, (String)"sch", (String)"67 'C'");
        XDebuggerAssertions.assertVariableValue(vars, (String)"uch", (String)"68 'D'");
        if (!isBadCharset) {
            XDebuggerAssertions.assertVariableValue(vars, (String)"sch_neg", (String)("-78 " + this.selectDriver("'\\262'", "'\\xb2'")));
        }
        if (!isBadCharset) {
            XDebuggerAssertions.assertVariableValue(vars, (String)"uch_big", (String)("168 " + this.selectDriver("'\\250'", "'\\xa8'")));
        }
        XDebuggerAssertions.assertVariableValue(vars, (String)"_char", (String)"42 '*'");
        XDebuggerAssertions.assertVariableValue(vars, (String)"_short", (String)"4242");
        XDebuggerAssertions.assertVariableValue(vars, (String)"_ushort", (String)"42424");
        XDebuggerAssertions.assertVariableValue(vars, (String)"_int", (String)"-65536");
        XDebuggerAssertions.assertVariableValue(vars, (String)"_uint", (String)"65536");
        XDebuggerAssertions.assertVariableValue(vars, (String)"int64", (String)"-2147483649");
        XDebuggerAssertions.assertVariableValue(vars, (String)"uint64", (String)"2147483648");
    }

    public void testIntValuesHex() throws Exception {
        CidrDebuggerSettings.getInstance().HEX_FORMATTING_ENABLED = true;
        CidrDebuggerSettings.getInstance().HEX_AS_SECONDARY_FORMATTING_ENABLED = false;
        try {
            XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_INT_VALUES);
            this.startDebugSessionAndWaitForPause("int_values");
            boolean isBadCharset = this.isMinGWWithCP1252Charset();
            List<XValue> vars = this.collectVars(0);
            XDebuggerAssertions.assertVariableValue(vars, (String)"int8", (String)"0x40 '@'");
            XDebuggerAssertions.assertVariableValue(vars, (String)"uint8", (String)"0x41 'A'");
            if (!isBadCharset) {
                XDebuggerAssertions.assertVariableValue(vars, (String)"int8_neg", (String)("0xb5 " + this.selectDriver("'\\265'", "'\\xb5'")));
            }
            if (!isBadCharset) {
                XDebuggerAssertions.assertVariableValue(vars, (String)"uint8_big", (String)("0xf0 " + this.selectDriver("'\\360'", "'\\xf0'")));
            }
            XDebuggerAssertions.assertVariableValue(vars, (String)"ch", (String)"0x42 'B'");
            XDebuggerAssertions.assertVariableValue(vars, (String)"sch", (String)"0x43 'C'");
            XDebuggerAssertions.assertVariableValue(vars, (String)"uch", (String)"0x44 'D'");
            if (!isBadCharset) {
                XDebuggerAssertions.assertVariableValue(vars, (String)"sch_neg", (String)("0xb2 " + this.selectDriver("'\\262'", "'\\xb2'")));
            }
            if (!isBadCharset) {
                XDebuggerAssertions.assertVariableValue(vars, (String)"uch_big", (String)("0xa8 " + this.selectDriver("'\\250'", "'\\xa8'")));
            }
            XDebuggerAssertions.assertVariableValue(vars, (String)"_char", (String)"0x2a '*'");
            XDebuggerAssertions.assertVariableValue(vars, (String)"_short", (String)"0x1092");
            XDebuggerAssertions.assertVariableValue(vars, (String)"_ushort", (String)"0xa5b8");
            XDebuggerAssertions.assertVariableValue(vars, (String)"_int", (String)"0xffff0000");
            XDebuggerAssertions.assertVariableValue(vars, (String)"_uint", (String)"0x10000");
            XDebuggerAssertions.assertVariableValue(vars, (String)"int64", (String)"0xffffffff7fffffff");
            XDebuggerAssertions.assertVariableValue(vars, (String)"uint64", (String)"0x80000000");
        }
        finally {
            CidrDebuggerSettings.getInstance().HEX_FORMATTING_ENABLED = false;
            CidrDebuggerSettings.getInstance().HEX_AS_SECONDARY_FORMATTING_ENABLED = true;
        }
    }

    public void testReferenceValues() throws Exception {
        if (!this.isDereferencingSupported()) {
            return;
        }
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_VALUES);
        this.startDebugSessionAndWaitForPause("values");
        List<XValue> vars = this.collectVars(0);
        XValue r = CidrDebuggingFixture.findVar(vars, "r");
        XDebuggerAssertions.assertVariableTypeMatches((XValue)r, (String)"r", (String)"int &(const)?");
        XDebuggerAssertions.assertVariableValue((XValue)r, (String)"r", (String)"1");
        XValue rr = CidrDebuggingFixture.findVar(vars, "rr");
        if (this.myBackend == DebuggerDriverKind.GDB) {
            XDebuggerAssertions.assertVariableValueMatches((XValue)rr, (String)"rr", (String)"(<unknown type in.*>)|0");
        } else {
            XDebuggerAssertions.assertVariableTypeMatches((XValue)rr, (String)"rr", (String)"int &&(const)?");
            XDebuggerAssertions.assertVariableValueMatches((Collection)XDebuggerTestUtil.collectChildren((XValueContainer)rr), (String)"&rr", (String)"0");
        }
        XValue pr = CidrDebuggingFixture.findVar(vars, "pr");
        XDebuggerAssertions.assertVariableTypeMatches((XValue)pr, (String)"pr", (String)"int \\*&(const)?");
        if (this.myBackend == DebuggerDriverKind.GDB) {
            XDebuggerAssertions.assertVariable((Collection)XDebuggerTestUtil.collectChildren((XValueContainer)pr), (String)"*pr", (String)"int", (String)"1", (Boolean)false);
        } else {
            List children = XDebuggerTestUtil.collectChildren((XValueContainer)pr);
            XValue prr = CidrDebuggingFixture.findVar(children, "&pr");
            XDebuggerAssertions.assertVariable((XValue)prr, (String)"&pr", (String)"int *", null, (Boolean)true);
            XDebuggerAssertions.assertVariableValue((Collection)XDebuggerTestUtil.collectChildren((XValueContainer)prr), (String)"*&pr", (String)"1");
        }
    }

    protected boolean isDereferencingSupported() {
        return true;
    }

    public void testValuesOfStructs() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STRUCTURE_VALUES);
        this.startDebugSessionAndWaitForPause("structure_values");
        List<XValue> vars = this.collectVars(0);
        XValue s = CidrDebuggingFixture.findVar(vars, "structure");
        CidrDebuggingValuesTestCase.assertStrictChildren(s);
        s = CidrDebuggingFixture.findVar(vars, "pstructure");
        CidrDebuggingValuesTestCase.assertStrictChildren(s);
        s = CidrDebuggingFixture.findVar(vars, "pstructure_null");
        CidrDebuggingValuesTestCase.assertEmpty((Collection)XDebuggerTestUtil.collectChildren((XValueContainer)s));
        s = CidrDebuggingFixture.findVar(vars, "rstructure");
        CidrDebuggingValuesTestCase.assertStrictChildren(s);
        s = CidrDebuggingFixture.findVar(vars, "structure_typedef");
        CidrDebuggingValuesTestCase.assertStrictChildren(s);
        s = CidrDebuggingFixture.findVar(vars, "pstructure_typedef");
        CidrDebuggingValuesTestCase.assertStrictChildren(s);
        s = CidrDebuggingFixture.findVar(vars, "pstructure_ptypedef");
        CidrDebuggingValuesTestCase.assertStrictChildren(s);
        s = CidrDebuggingFixture.findVar(vars, "ppstructure_typedef");
        CidrDebuggingValuesTestCase.assertStrictChildren((XValue)XDebuggerTestUtil.collectChildren((XValueContainer)s).get(0));
    }

    private static void assertStrictChildren(XValue s) {
        List children = XDebuggerTestUtil.collectChildren((XValueContainer)s);
        CidrDebuggingValuesTestCase.assertSize((int)2, (Collection)children);
        XDebuggerAssertions.assertVariable((Collection)children, (String)"i", (String)"int", (String)"10", (Boolean)false);
        XDebuggerAssertions.assertVariable((Collection)children, (String)"j", (String)"int", (String)"20", (Boolean)false);
    }

    public void testValuesOfStrings() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STRING_VALUES);
        this.startDebugSessionAndWaitForPause("string_values");
        List<XValue> vars = this.collectVars(0);
        XDebuggerAssertions.assertVariableValue(vars, (String)"cString", (String)"\"hello\"");
        XDebuggerAssertions.assertVariableValue(vars, (String)"staticCharArray", (String)this.selectDriver("", "\"hello\""));
        XDebuggerAssertions.assertVariableValue(vars, (String)"dynamicCharArray", (String)this.dynamicArrayStringIfSupported("\"hello\""));
    }

    protected boolean isMinGWWithCP1252Charset() throws ExecutionException, DebuggerCommandException {
        if (SystemInfo.isWindows && this.myBackend == DebuggerDriverKind.GDB) {
            DebuggerDriver driver = this.getDebugProcess().getDriverInTests();
            CidrDebuggingValuesTestCase.assertTrue((boolean)(driver instanceof GDBDriver));
            GDBDriver gdbDriver = (GDBDriver)driver;
            String charset = gdbDriver.interruptAndExecuteConsole("show host-charset");
            if (charset.contains("CP1252")) {
                return true;
            }
        }
        return false;
    }

    public void testValuesOfUnicodeStrings() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STRING_VALUES);
        this.startDebugSessionAndWaitForPause("string_values");
        if (this.isMinGWWithCP1252Charset()) {
            return;
        }
        List<XValue> vars = this.collectVars(0);
        XDebuggerAssertions.assertVariableValue(vars, (String)"cStringRussian", (String)("\"" + CidrTestBundle.message("russian.hello", new Object[0]) + "\""));
        String unicodeTest = "really \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442 \u7d2b\u8272\u306e\u30af\u30aa\u30ea\u30a2";
        String u_supplementaryTest_16 = this.selectDriver("supplementary \ud840\udc00 \ud840\udc01 \ud840\udc02 \ud840\udc03 \ud840\udc04 page", "supplementary \ufffd\\xa0\\x80\\x80 \\U00000001 \\U00000002 \\U00000003 \\U00000004 page");
        String supplementaryTest_32 = this.selectDriver("supplementary \ud840\udc00 \ud840\udc01 \ud840\udc02 \ud840\udc03 \ud840\udc04 page", "supplementary \ufffd\\xa0\\x80\\x80 \\U00000001 \\U00000002 \\U00000003 " + (this.hasUnicodeStringRenderingBug() ? "" : "\\U00000004 page"));
        XValue sizeofWcharVar = XDebuggerTestUtil.findVar(vars, (String)"sizeofWchar");
        CidrDebuggingValuesTestCase.assertNotNull((Object)sizeofWcharVar);
        boolean is32bitWchar = "4".equals(XDebuggerTestUtil.computePresentation((XValue)sizeofWcharVar).myValue);
        XDebuggerAssertions.assertVariableValue(vars, (String)"wString", (String)("L\"" + unicodeTest + "\""));
        if (is32bitWchar) {
            XDebuggerAssertions.assertVariableValue(vars, (String)"wSuppString", (String)("L\"" + supplementaryTest_32 + "\""));
        }
        XDebuggerAssertions.assertVariableValue(vars, (String)"c16String", (String)("u\"" + unicodeTest + "\""));
        if (is32bitWchar) {
            XDebuggerAssertions.assertVariableValue(vars, (String)"c16SuppString", (String)("u\"" + u_supplementaryTest_16 + "\""));
        }
        XDebuggerAssertions.assertVariableValue(vars, (String)"c16UndefString", (String)this.selectDriver("u\"undefined \\xffff symbol\"", "u\"undefined \\U0000ffff symbol\""));
        XDebuggerAssertions.assertVariableValue(vars, (String)"c32String", (String)("U\"" + unicodeTest + "\""));
        if (is32bitWchar) {
            XDebuggerAssertions.assertVariableValue(vars, (String)"c32SuppString", (String)("U\"" + supplementaryTest_32 + "\""));
        }
        XDebuggerAssertions.assertVariableValue(vars, (String)"c32UndefString", (String)this.selectDriver("U\"undefined \\xffffffff symbol\"", "U\"undefined \\U0000fffd symbol\""));
    }

    protected boolean hasUnicodeStringRenderingBug() {
        return false;
    }

    public void testValuesOfLongAndRepeatingStrings() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_LONG_VALUES);
        int maxValueLen = 2000;
        this.startDebugSessionAndWaitForPause("long_values 2000");
        List<XValue> vars = this.collectVars(0);
        StringBuilder expectedLongBuff = new StringBuilder(2000);
        StringBuilder expectedRepeatingBuff = new StringBuilder(2000);
        for (int i = 0; i < 2000; ++i) {
            expectedLongBuff.append(i);
            expectedRepeatingBuff.append(1);
        }
        String expectedLongString = "\"" + expectedLongBuff + "\"";
        String expectedRepeatingString = "\"" + expectedRepeatingBuff + "\"";
        this.assertShortValueAndFullValue(CidrDebuggingFixture.findVar(vars, "longStdString"), expectedLongString);
        this.assertShortValueAndFullValue(CidrDebuggingFixture.findVar(vars, "repeatingStdString"), expectedRepeatingString);
        this.assertShortValueAndFullValue(CidrDebuggingFixture.findVar(vars, "longCharPointer"), expectedLongString);
        this.assertShortValueAndFullValue(CidrDebuggingFixture.findVar(vars, "repeatingCharPointer"), expectedRepeatingString);
        this.assertShortValueAndFullValue(CidrDebuggingFixture.findVar(vars, "longStaticCharArray"), this.selectDriver("", expectedLongString));
        this.assertShortValueAndFullValue(CidrDebuggingFixture.findVar(vars, "repeatingStaticCharArray"), this.selectDriver("", expectedRepeatingString));
        this.assertShortValueAndFullValue(CidrDebuggingFixture.findVar(vars, "longDynamicCharArray"), this.dynamicArrayStringIfSupported(expectedLongString));
        this.assertShortValueAndFullValue(CidrDebuggingFixture.findVar(vars, "repeatingDynamicCharArray"), this.dynamicArrayStringIfSupported(expectedRepeatingString));
    }

    public String dynamicArrayStringIfSupported(String expected) {
        return this.myBackend == DebuggerDriverKind.LLDB && (SystemInfo.isLinux || SystemInfo.isWindows) ? expected : "";
    }

    private void assertShortValueAndFullValue(XValue var, String expected) throws Exception {
        XDebuggerAssertions.assertVariableValue((XValue)var, null, (String)StringUtil.first((String)expected, (int)1000, (boolean)false));
        if (expected.length() < 1000) {
            XDebuggerAssertions.assertVariableFullValue((XValue)var, null);
        } else if (this.myBackend == DebuggerDriverKind.LLDB) {
            XDebuggerAssertions.assertVariableFullValue((XValue)var, (String)(StringUtil.first((String)expected, (int)1025, (boolean)false) + (this.trimmedEllipsisInsideQuotes() ? "...\"" : "\"...")));
        } else {
            XDebuggerAssertions.assertVariableFullValue((XValue)var, (String)expected);
        }
    }

    protected boolean trimmedEllipsisInsideQuotes() {
        return false;
    }

    public void testValuesOfStaticCArrays() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_ARRAYS);
        this.startDebugSessionAndWaitForPause("arrays");
        List<XValue> vars = this.collectVars(0);
        if (this.hasZeroLengthArrays()) {
            XDebuggerAssertions.assertVariable(vars, (String)"emptyCArray", null, (String)"", (Boolean)true);
            CidrDebuggingValuesTestCase.assertEmpty((Collection)XDebuggerTestUtil.collectChildren((XValueContainer)XDebuggerTestUtil.findVar(vars, (String)"emptyCArray")));
        }
        XDebuggerAssertions.assertVariable(vars, (String)"cArray", null, (String)"", (Boolean)true);
        List children = XDebuggerTestUtil.collectChildren((XValueContainer)XDebuggerTestUtil.findVar(vars, (String)"cArray"));
        CidrDebuggingValuesTestCase.assertSize((int)2, (Collection)children);
        XDebuggerAssertions.assertVariableValue((Collection)children, (String)"[0]", (String)"\"one\"");
        XDebuggerAssertions.assertVariableValue((Collection)children, (String)"[1]", (String)"\"two\"");
        XDebuggerAssertions.assertVariable(vars, (String)"cIntArray", null, (String)"", (Boolean)true);
        children = XDebuggerTestUtil.collectChildren((XValueContainer)XDebuggerTestUtil.findVar(vars, (String)"cIntArray"));
        CidrDebuggingValuesTestCase.assertSize((int)2, (Collection)children);
        XDebuggerAssertions.assertVariableValue((Collection)children, (String)"[0]", (String)"1");
        XDebuggerAssertions.assertVariableValue((Collection)children, (String)"[1]", (String)"2");
        children = XDebuggerTestUtil.collectChildren((XValueContainer)XDebuggerTestUtil.findVar(vars, (String)"bigCArray"));
        CidrDebuggingValuesTestCase.assertSize((int)50, (Collection)children);
        XDebuggerAssertions.assertVariable((XValue)((XValue)children.get(0)), (String)"[0]", null, null, null);
        XDebuggerAssertions.assertVariable((XValue)((XValue)children.get(49)), (String)"[49]", null, null, null);
        children = XDebuggerTestUtil.collectChildren((XValueContainer)XDebuggerTestUtil.findVar(vars, (String)"bigCArray"));
        CidrDebuggingValuesTestCase.assertSize((int)50, (Collection)children);
        XDebuggerAssertions.assertVariable((XValue)((XValue)children.get(0)), (String)"[50]", null, null, null);
        XDebuggerAssertions.assertVariable((XValue)((XValue)children.get(49)), (String)"[99]", null, null, null);
        children = XDebuggerTestUtil.collectChildren((XValueContainer)XDebuggerTestUtil.findVar(vars, (String)"bigCArray"));
        CidrDebuggingValuesTestCase.assertSize((int)20, (Collection)children);
        XDebuggerAssertions.assertVariable((XValue)((XValue)children.get(0)), (String)"[100]", null, null, null);
        XDebuggerAssertions.assertVariable((XValue)((XValue)children.get(19)), (String)"[119]", null, null, null);
    }

    private boolean hasZeroLengthArrays() {
        return !SystemInfo.isWindows || this.myBackend != DebuggerDriverKind.LLDB;
    }

    public void testValuesOfPointerCArrays() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_ARRAYS);
        this.startDebugSessionAndWaitForPause("arrays");
        boolean frameIndex = false;
        List<XValue> vars = this.collectVars(0);
        if (this.hasZeroLengthArrays()) {
            XDebuggerAssertions.assertVariable(vars, (String)"pEmptyCArray", null, null, (Boolean)true);
        }
        XDebuggerAssertions.assertVariable(vars, (String)"pNilCArray", null, (String)"NULL", (Boolean)false);
        CidrDebuggingValuesTestCase.assertEmpty((Collection)XDebuggerTestUtil.collectChildren((XValueContainer)XDebuggerTestUtil.findVar(vars, (String)"pNilCArray")));
        List children = XDebuggerTestUtil.collectChildren((XValueContainer)XDebuggerTestUtil.findVar(vars, (String)"pCArray"));
        XDebuggerAssertions.assertVariables((List)children, (String[])new String[]{"*pCArray"});
        XDebuggerAssertions.assertVariableValue((XValue)((XValue)children.get(0)), (String)"*pCArray", (String)"\"one\"");
    }

    public void testValuesOfEnums() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_ENUMS);
        this.startDebugSessionAndWaitForPause("enums");
        List<XValue> vars = this.collectVars(0);
        XDebuggerAssertions.assertVariable(vars, (String)"someEnumInt", (String)"int", (String)"11", (Boolean)false);
        XDebuggerAssertions.assertVariable(vars, (String)"someEnum", (String)"SomeEnum", (String)"SomeEnumValue2", (Boolean)false);
        XDebuggerAssertions.assertVariable(vars, (String)"someEnum_tInt", (String)"int", (String)"11", (Boolean)false);
        XDebuggerAssertions.assertVariable(vars, (String)"someEnum_t", (String)(this.isMSVCRuntime() ? "SomeEnum" : "SomeEnum_t"), (String)"SomeEnumValue2", (Boolean)false);
        XDebuggerAssertions.assertVariable(vars, (String)"someAnonEnumInt", (String)"int", (String)"21", (Boolean)false);
        XDebuggerAssertions.assertVariable(vars, (String)"someAnonEnum_tInt", (String)"int", (String)"21", (Boolean)false);
        XDebuggerAssertions.assertVariable(vars, (String)"someAnonEnum_t", (String)"SomeAnonEnum_t", (String)"SomeAnonEnumValue2", (Boolean)false);
        XDebuggerAssertions.assertVariable(vars, (String)"someUntypedEnum_t", (String)"int", (String)"31", (Boolean)false);
    }

    public void testValuesOfDerivedClass() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DERIVED_CLASS);
        this.startDebugSessionAndWaitForPause("derived_class");
        List<XValue> vars = this.collectVars(0);
        CidrDebuggingValuesTestCase.doTestValuesOfDerivedClass(vars, "derived", "MyDerivedClass");
        CidrDebuggingValuesTestCase.doTestValuesOfDerivedClass(vars, "rBase", "MyDerivedClass &");
        CidrDebuggingValuesTestCase.doTestValuesOfDerivedClass(vars, "pBase", "MyDerivedClass *");
    }

    private static void doTestValuesOfDerivedClass(List<XValue> vars, String name, String type) {
        XValue derived = CidrDebuggingFixture.findVar(vars, name);
        XDebuggerAssertions.assertVariable((XValue)derived, (String)name, (String)type, null, (Boolean)true);
        List derivedChildren = XDebuggerTestUtil.collectChildren((XValueContainer)derived);
        XDebuggerAssertions.assertVariables((List)derivedChildren, (String[])new String[]{"MyBaseClass", "derevo"});
        XDebuggerAssertions.assertVariable((Collection)derivedChildren, (String)"derevo", (String)"int", (String)"42", (Boolean)false);
        XDebuggerAssertions.assertVariable((Collection)derivedChildren, (String)"MyBaseClass", (String)"MyBaseClass", null, (Boolean)true);
        List baseChildren = XDebuggerTestUtil.collectChildren((XValueContainer)XDebuggerTestUtil.findVar((Collection)derivedChildren, (String)"MyBaseClass"));
        XDebuggerAssertions.assertVariables((List)baseChildren, (String[])new String[]{"MyClass"});
    }

    public void testValuesWithOptimizedOutStaticMember() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_OPTIMIZED_OUT_STATIC_MEMBER);
        this.startDebugSessionAndWaitForPause("optimized_out_static_member");
        List<XValue> vars = this.collectVars(0);
        XValue f1 = CidrDebuggingFixture.findVar(vars, "f1");
        XDebuggerAssertions.assertVariable((XValue)f1, (String)"f1", (String)"optimized_foo<TRAITS>", null, (Boolean)true);
        List children = XDebuggerTestUtil.collectChildren((XValueContainer)f1);
        if (this.myBackend == DebuggerDriverKind.LLDB) {
            CidrDebuggingValuesTestCase.assertEmpty((Collection)children);
        } else if (SystemInfo.isLinux) {
            CidrDebuggingValuesTestCase.assertSize((int)1, (Collection)children);
            XValue child = (XValue)children.get(0);
            XDebuggerAssertions.assertVariable((XValue)child, (String)"x1", (String)"const unsigned int", (String)"<optimized out>", (Boolean)false);
        }
    }

    public void testValuesWithPrettyPrinterRecursion() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_PRETTY_PRINTER_RECURSION);
        this.startDebugSessionAndWaitForPause("pretty_printer_recursion");
        List<XValue> vars = this.collectVars(0);
        XValue is = CidrDebuggingFixture.findVar(vars, "is");
        XDebuggerAssertions.assertVariable((XValue)is, (String)"is", null, (String)this.selectDriver("\"foo\"", ""), (Boolean)true);
        List children = XDebuggerTestUtil.collectChildren((XValueContainer)is);
        if (this.myBackend == DebuggerDriverKind.LLDB) {
            CidrDebuggingValuesTestCase.assertSize((int)1, (Collection)children);
            XValue child = (XValue)children.get(0);
            XDebuggerAssertions.assertVariable((XValue)child, (String)(this.isMSVCRuntime() ? "[ptr]" : "item"), null, (String)"\"foo\"", (Boolean)true);
        } else {
            CidrDebuggingValuesTestCase.assertEmpty((Collection)children);
        }
    }

    protected String getMyClassPtrTypeName() {
        if (!SystemInfo.isMac) {
            if (this.myBackend == DebuggerDriverKind.LLDB) {
                return "MyClass *const";
            }
            return "MyClass * const";
        }
        return "MyClass *";
    }

    public void testThisPtr() throws Exception {
        CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED = true;
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MYCLASS_FUNC);
        this.startDebugSessionAndWaitForPause("memfunc");
        List<XValue> vars = this.collectVars(0);
        XDebuggerAssertions.assertVariable(vars, (String)"this", (String)this.getMyClassPtrTypeName(), null, (Boolean)true);
        XDebuggerAssertions.assertVariables((List)XDebuggerTestUtil.collectChildren((XValueContainer)XDebuggerTestUtil.findVar(vars, (String)"this")), (String[])new String[]{"i", "d", "c", "f"});
    }

    public void testThisPtrInInlineFunc() throws Exception {
        CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED = true;
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MYCLASS_INLINE_FUNC);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("inlinememfunc");
        if (this.isMSVCRuntime()) {
            this.getSession().stepInto();
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
            this.getSession().stepOut();
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        }
        List<XValue> vars = this.collectVars(0);
        XDebuggerAssertions.assertVariable(vars, (String)"this", (String)this.getMyClassPtrTypeName(), null, (Boolean)true);
        XDebuggerAssertions.assertVariables((List)XDebuggerTestUtil.collectChildren((XValueContainer)XDebuggerTestUtil.findVar(vars, (String)"this")), (String[])new String[]{"i", "d", "c", "f"});
    }

    public void testExceptionDuringVariableCalculation() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_VALUES_FOR_ERROR_CHECKS);
        this.startDebugSessionAndWaitForPause("values_for_error_checks");
        List<XValue> vars = this.collectVars(0);
        XValue var = CidrDebuggingFixture.findVar(vars, "intVar1");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_ICON, (boolean)true);
        CidrDebuggingValuesTestCase.doAssertError(var, false, true, false);
        var = CidrDebuggingFixture.findVar(vars, "structVar1");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_ICON, (boolean)true);
        CidrDebuggingValuesTestCase.doAssertError(var, false, true, true);
        var = CidrDebuggingFixture.findVar(vars, "intVar2");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_HAS_CHILDREN, (boolean)true);
        CidrDebuggingValuesTestCase.doAssertError(var, false, true, false);
        var = CidrDebuggingFixture.findVar(vars, "structVar2");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_HAS_CHILDREN, (boolean)true);
        CidrDebuggingValuesTestCase.doAssertError(var, false, true, true);
        var = CidrDebuggingFixture.findVar(vars, "intVar3");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_ICON, (boolean)true);
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_HAS_CHILDREN, (boolean)true);
        CidrDebuggingValuesTestCase.doAssertError(var, false, true, false);
        var = CidrDebuggingFixture.findVar(vars, "structVar3");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_ICON, (boolean)true);
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_HAS_CHILDREN, (boolean)true);
        CidrDebuggingValuesTestCase.doAssertError(var, false, true, true);
        var = CidrDebuggingFixture.findVar(vars, "intVar4");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_TYPE, (boolean)true);
        CidrDebuggingValuesTestCase.doAssertError(var, true, false, false);
        var = CidrDebuggingFixture.findVar(vars, "structVar4");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_TYPE, (boolean)true);
        CidrDebuggingValuesTestCase.doAssertError(var, true, false, true);
        var = CidrDebuggingFixture.findVar(vars, "intVar5");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_VALUE, (boolean)true);
        CidrDebuggingValuesTestCase.doAssertError(var, true, false, false);
        var = CidrDebuggingFixture.findVar(vars, "structVar5");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_VALUE, (boolean)true);
        CidrDebuggingValuesTestCase.doAssertError(var, true, false, true);
        var = CidrDebuggingFixture.findVar(vars, "intVar6");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_ICON, (boolean)true);
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_TYPE, (boolean)true);
        CidrDebuggingValuesTestCase.doAssertError(var, true, true, false);
        var = CidrDebuggingFixture.findVar(vars, "structVar6");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_ICON, (boolean)true);
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_TYPE, (boolean)true);
        CidrDebuggingValuesTestCase.doAssertError(var, true, true, true);
        var = CidrDebuggingFixture.findVar(vars, "intVar7");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_ICON, (boolean)false);
        CidrDebuggingValuesTestCase.doAssertError(var, true, false, false, "execution exception");
        var = CidrDebuggingFixture.findVar(vars, "structVar7");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_ICON, (boolean)false);
        CidrDebuggingValuesTestCase.doAssertError(var, true, false, true, "execution exception");
        var = CidrDebuggingFixture.findVar(vars, "intVar8");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_VALUE, (boolean)false);
        CidrDebuggingValuesTestCase.doAssertError(var, true, false, false, "execution exception");
        var = CidrDebuggingFixture.findVar(vars, "structVar8");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_VALUE, (boolean)false);
        CidrDebuggingValuesTestCase.doAssertError(var, true, false, true, "execution exception");
    }

    public void testExceptionDuringVariableChildrenCalculation() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_VALUES_FOR_ERROR_CHECKS);
        this.startDebugSessionAndWaitForPause("values_for_error_checks");
        List<XValue> vars = this.collectVars(0);
        XValue var = CidrDebuggingFixture.findVar(vars, "structVar1");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_CHILDREN, (boolean)true);
        CidrDebuggingValuesTestCase.doAssertError(var, false, false, true, false, true, "user exception");
        var = CidrDebuggingFixture.findVar(vars, "structVar2");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_ICON, (boolean)true);
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_CHILDREN, (boolean)true);
        CidrDebuggingValuesTestCase.doAssertError(var, true, false, true, false, true, "user exception", "user exception");
        var = CidrDebuggingFixture.findVar(vars, "structVar3");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_HAS_CHILDREN, (boolean)true);
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_CHILDREN, (boolean)true);
        CidrDebuggingValuesTestCase.doAssertError(var, true, false, true, false, true, "user exception", "user exception");
        var = CidrDebuggingFixture.findVar(vars, "structVar4");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_VALUE, (boolean)true);
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_CHILDREN, (boolean)true);
        CidrDebuggingValuesTestCase.doAssertError(var, true, true, true, false, true, "user exception");
        var = CidrDebuggingFixture.findVar(vars, "structVar5");
        ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_CHILDREN, (boolean)false);
        CidrDebuggingValuesTestCase.doAssertError(var, false, false, true, false, true, "execution exception");
    }

    public void testMutedVariables() throws Exception {
        CidrDebuggerSettings.getInstance().MUTE_VARIABLES = true;
        try {
            XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MYCLASS_CTOR);
            this.startDebugSessionAndWaitForPause("memfunc");
            List<XValue> vars = this.collectVars(0);
            XValue var = CidrDebuggingFixture.findVar(vars, "this");
            ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_VAR_DATA, (boolean)true);
            ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_VALUE, (boolean)true);
            this.doAssertMutedValue(var, true);
            var = CidrDebuggingFixture.findVar(vars, "this");
            ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_VAR_DATA, (boolean)false);
            ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_VALUE, (boolean)false);
            this.doAssertMutedValue(var, true);
            var = CidrDebuggingFixture.findVar(vars, "ii");
            ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_VAR_DATA, (boolean)true);
            ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_VALUE, (boolean)true);
            this.doAssertMutedValue(var, false);
            var = CidrDebuggingFixture.findVar(vars, "ii");
            ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_VAR_DATA, (boolean)false);
            ThrowInTest.throwOn((Object)var, (Key)CidrPhysicalValue.THROW_ON_VALUE, (boolean)false);
            this.doAssertMutedValue(var, false);
        }
        finally {
            CidrDebuggerSettings.getInstance().MUTE_VARIABLES = false;
        }
    }

    private void doAssertMutedValue(XValue var, boolean isStruct) {
        XDebuggerAssertions.assertVariable((XValue)var, null, (String)(isStruct ? this.getMyClassPtrTypeName() : "int"), (String)"", (Boolean)false, (Icon)CidrDebuggerIcons.ValueMuted);
    }

    private static void doAssertError(XValue var, boolean hasErrorValue, boolean hasErrorChild, boolean struct) {
        CidrDebuggingValuesTestCase.doAssertError(var, hasErrorValue, hasErrorChild, struct, "user exception");
    }

    private static void doAssertError(XValue var, boolean hasErrorValue, boolean hasErrorChild, boolean struct, String ... errors) {
        CidrDebuggingValuesTestCase.doAssertError(var, true, hasErrorValue, hasErrorChild, struct, struct, errors);
    }

    private static void doAssertError(XValue var, boolean hasErrorIcon, boolean hasErrorValue, boolean hasErrorChild, boolean hasNormalChildren, boolean struct, String ... errors) {
        if (hasErrorValue) {
            XDebuggerAssertions.assertVariable((XValue)var, null, null, (String)errors[0], (Boolean)(hasNormalChildren || hasErrorChild ? 1 : 0), (Icon)(hasErrorIcon ? XDebuggerUIConstants.ERROR_MESSAGE_ICON : null));
        } else {
            XDebuggerAssertions.assertVariable((XValue)var, null, (String)(struct ? "MyStruct" : "int"), (String)(struct ? "" : "0"), (Boolean)hasErrorChild, (Icon)(hasErrorIcon ? XDebuggerUIConstants.ERROR_MESSAGE_ICON : null));
        }
        ArrayList<String> expectedChildren = new ArrayList<String>();
        if (hasErrorChild) {
            for (String each : errors) {
                expectedChildren.add("error");
            }
        }
        if (hasNormalChildren && struct) {
            expectedChildren.addAll(Arrays.asList("i", "j"));
        }
        List children = XDebuggerTestUtil.collectChildren((XValueContainer)var);
        XDebuggerAssertions.assertVariables((List)children, (String[])ArrayUtilRt.toStringArray(expectedChildren));
        if (hasErrorChild) {
            int i = 0;
            for (String each : errors) {
                XDebuggerAssertions.assertVariable((XValue)((XValue)children.get(i++)), (String)"error", null, (String)each, (Boolean)false, (Icon)XDebuggerUIConstants.ERROR_MESSAGE_ICON);
            }
        }
    }
}

