/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.FutureResult;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrDebugTestDataFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrProjectMarkup;
import com.jetbrains.cidr.CidrTestCase;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.CidrTestProjectDescription;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.TrivialInstaller;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.debugger.DebuggerDriverKind;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.formatters.natvis.NatvisSettings;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Pair;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrDebuggerTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>, PROJECT_MARKUP extends CidrProjectMarkup>
extends CidrTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, CidrCodeInsightFixture> {
    public static final String DEFAULT_BUILD_TYPE = "Debug";
    public static final String LOCALHOST_4242 = "localhost:4242";
    public static final Pattern GDBSERVER_TARGET_PID_PATTERN = Pattern.compile("Process .* created; pid = (\\d+)");
    public static final Key<Boolean> IS_BUNDLED_LLDB = Key.create((String)"IS_BUNDLED_LLDB");
    protected DebuggerDriver myDriver;
    protected DebuggerDriver.Inferior myInferior;
    protected DebuggerDriverKind myBackend;
    protected String myTargetName;
    private final List<Disposable> myDisposables = new SmartList();
    protected PROJECT_MARKUP myProjectMarkup;
    protected CidrTestProjectDescription myTestProjectDescription;
    @Nullable
    protected Function.Mono<GeneralCommandLine> myDriverCommandLineConfigurator = null;

    @Override
    @NotNull
    protected CidrTestDataFixture createTestDataFixture() {
        return new CidrDebugTestDataFixture();
    }

    @NotNull
    protected DebuggerDriverConfiguration createDriverConfiguration() {
        return this.myDebuggingFixture.createDriverConfiguration(this.myDriverCommandLineConfigurator);
    }

    @NotNull
    protected Installer createInstaller(GeneralCommandLine cl) {
        return new TrivialInstaller(cl);
    }

    protected void startDriver() throws ExecutionException {
        this.startDriver((DebuggerDriver.Handler)null);
    }

    protected void startDriver(@Nullable DebuggerDriver.Handler handler) throws ExecutionException {
        this.startDriver(handler, null);
    }

    @Contract(value="!null -> !null;  null ->  null")
    protected <T> BlockingQueue<T> startDriver(@Nullable Function<CidrDebuggingFixture.DriverEvent, T> eventFilter) throws ExecutionException {
        return this.startDriver(null, eventFilter);
    }

    @Contract(value="_, !null -> !null; _,  null ->  null")
    protected <T> BlockingQueue<T> startDriver(@Nullable DebuggerDriver.Handler handler, @Nullable Function<CidrDebuggingFixture.DriverEvent, T> eventFilter) throws ExecutionException {
        BlockingQueue<T> eventQueue = this.myDebuggingFixture.startDriver(handler, this.myDriverCommandLineConfigurator, eventFilter);
        this.myDriver = this.myDebuggingFixture.getDriver();
        return eventQueue;
    }

    protected void stopDebugDriver() throws Exception {
        this.myDriver = null;
        this.myDebuggingFixture.stopDebugDriver();
    }

    protected void addDriverHandler(@NotNull DebuggerDriver.Handler handler) {
        this.myDebuggingFixture.addDriverHandler(handler);
    }

    @NotNull
    protected BlockingQueue<String> spyOnOutputLines() {
        return this.myDebuggingFixture.spyOnOutputLines();
    }

    @NotNull
    protected String getTestExecutablePath() throws Exception {
        return this.myExecutionFixture.getTestExecutablePath(this.myTargetName);
    }

    @NotNull
    protected abstract PROJECT_MARKUP createProjectMarkup(@NotNull VirtualFile var1) throws Exception;

    protected void buildConfiguration() throws Exception {
        this.myExecutionFixture.buildIfNeeded();
    }

    public CidrDebuggerTestCase(@NotNull DebuggerDriverKind backend, @NotNull String targetName, @NotNull CidrTestProjectDescription testProjectDescription) {
        this.myBackend = backend;
        this.myTargetName = targetName;
        this.myTestProjectDescription = testProjectDescription;
    }

    @NotNull
    public String getTestProjectRootPath() {
        return this.myProjectFixture.getProjectDir().getPath();
    }

    @Nullable
    @Contract(value="!null, !null -> !null")
    protected <TYPE> TYPE selectDriver(TYPE gdb, TYPE lldb) {
        return this.myBackend == DebuggerDriverKind.LLDB ? lldb : gdb;
    }

    @Nullable
    @Contract(value="!null, !null, !null -> !null")
    protected <TYPE> TYPE selectByCompiler(TYPE gcc, TYPE clang, TYPE msvc) throws RuntimeException {
        OCCompilerKind compilerKind = this.myProjectFixture.getCompilerType();
        if (compilerKind == GCCCompilerKind.INSTANCE) {
            return gcc;
        }
        if (compilerKind == ClangCompilerKind.INSTANCE) {
            return clang;
        }
        if (compilerKind == MSVCCompilerKind.INSTANCE) {
            return msvc;
        }
        throw new RuntimeException(String.format("Unsupported compiler kind '%s' used in debugger test", compilerKind.getDisplayName()));
    }

    @Nullable
    @Contract(value="!null, !null -> !null")
    @RegExp
    protected String selectDriverRegExp(@RegExp String gdb, @RegExp String lldb) {
        return this.myBackend == DebuggerDriverKind.LLDB ? lldb : gdb;
    }

    protected boolean isExternalLLDB() {
        DebuggerDriverConfiguration driverConfiguration = this.createDriverConfiguration();
        if (driverConfiguration instanceof LLDBDriverConfiguration) {
            return !Boolean.TRUE.equals(driverConfiguration.getUserData(IS_BUNDLED_LLDB));
        }
        return false;
    }

    protected boolean runInDispatchThread() {
        return false;
    }

    protected boolean shouldRunTest() {
        return super.shouldRunTest() && CidrDebuggingFixture.shouldRunTest(this.myBackend, this.getName(), this.getClass()) && (!this.isTargetLibcxx() || SystemInfo.isMac);
    }

    protected boolean isTargetLibcxx() {
        return StringUtil.containsIgnoreCase((String)this.myTargetName, (String)"libcxx");
    }

    protected boolean isMSVCRuntime() {
        return SystemInfo.isWindows && this.myBackend == DebuggerDriverKind.LLDB;
    }

    @NotNull
    protected static String getDefaultTargetName(@NotNull DebuggerDriverKind backend) {
        return SystemInfo.isMac && backend == DebuggerDriverKind.LLDB ? "Target_Libcxx" : "Target_Libstdcxx";
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myProjectFixture.initProject(this.myTestProjectDescription);
        try {
            this.myProjectMarkup = this.createProjectMarkup(this.myProjectFixture.getProjectDir());
            this.buildConfiguration();
        }
        catch (Exception e) {
            this.myProjectFixture.closeProject();
            throw e;
        }
        if (IS_UNDER_TEAMCITY) {
            this.enableDebugLogging();
        }
    }

    private void enableDebugLogging() {
        if (!CidrDebuggerLog.LOG.isDebugEnabled()) {
            String testStartedLogMessage = "Starting " + this.getClass().getName() + "." + this.getName();
            TestLoggerFactory.enableDebugLogging((Disposable)this.getTestRootDisposable(), (String[])new String[]{"#" + CidrDebuggerLog.class.getPackage().getName()});
            CidrDebuggerLog.LOG.info(testStartedLogMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            try {
                this.stopDebugDriver();
            }
            finally {
                for (Disposable each : this.myDisposables) {
                    each.dispose();
                }
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    protected void setUpFixtures() throws Exception {
        super.setUpFixtures();
        this.myExecutionFixture.initTargetAndConfiguration(this.myTargetName, DEFAULT_BUILD_TYPE);
    }

    @Override
    public void afterProjectOpened() throws Exception {
        super.afterProjectOpened();
        this.setDefaultSettings();
    }

    private void setDefaultSettings() {
        NatvisSettings settings = NatvisSettings.getInstance((Project)this.getProject());
        settings.searchInVS = false;
        File testVizualizersDir = new File(this.getClass().getResource("/visualizers").getPath());
        settings.searchPaths.clear();
        settings.searchPaths.add(new Pair((Object)testVizualizersDir, (Object)true));
    }

    public boolean supportsInputOutputOnWindows() {
        return this.myDebuggingFixture.supportsInputOutputOnWindows();
    }

    protected boolean isAttachSupported() {
        return this.createDriverConfiguration().isAttachSupported();
    }

    protected boolean isRemoteDebugSupported() {
        if (SystemInfo.isMac) {
            return false;
        }
        if (this.getEnvironment().getHostMachine().isRemote()) {
            return false;
        }
        return this.myBackend == DebuggerDriverKind.GDB;
    }

    protected boolean isGdbEvaluationExecutingExtraTimesOnStepping() {
        return this.myBackend == DebuggerDriverKind.GDB;
    }

    protected boolean isGdbOnMacOsSierraWithBrokenArgsPassing() {
        return this.myBackend == DebuggerDriverKind.GDB && SystemInfo.isMacOSSierra;
    }

    protected int mainThreadID() {
        return this.myBackend == DebuggerDriverKind.GDB && SystemInfo.isMacOSSierra ? 2 : 1;
    }

    protected boolean isDisasmSupported() {
        return true;
    }

    public boolean supportsOCDebugging() {
        return this.myDebuggingFixture.supportsOCDebugging();
    }

    public boolean supportsExceptionCatchBreakpoints() {
        return this.myBackend != DebuggerDriverKind.LLDB || !SystemInfo.isWindows;
    }

    protected boolean steppingWorksWellWithLibcDebugInfo() {
        return false;
    }

    protected void startDriverAndLaunch() throws Exception {
        this.startDriverAndLaunch((ThrowableConsumer<DebuggerDriver, Exception>)((ThrowableConsumer)driver -> {}));
    }

    protected void startDriverAndLaunch(@Nullable ThrowableConsumer<? super DebuggerDriver, ? extends Exception> afterLoadBeforeLaunch) throws Exception {
        this.startDriverAndLaunch((String)null, afterLoadBeforeLaunch);
    }

    protected void startDriverAndLaunch(@Nullable String params) throws Exception {
        this.startDriverAndLaunch(params, (ThrowableConsumer<DebuggerDriver, Exception>)((ThrowableConsumer)driver -> {}));
    }

    protected void startDriverAndLaunch(@Nullable String params, @Nullable ThrowableConsumer<? super DebuggerDriver, ? extends Exception> afterLoadBeforeLaunch) throws Exception {
        this.startDriverAndLaunch(params, null, afterLoadBeforeLaunch);
    }

    @Contract(value="!null -> !null;  null ->  null")
    protected <T> BlockingQueue<T> startDriverAndLaunch(@Nullable Function<CidrDebuggingFixture.DriverEvent, T> eventFilter) throws Exception {
        return this.startDriverAndLaunch(eventFilter, (ThrowableConsumer<DebuggerDriver, Exception>)((ThrowableConsumer)driver -> {}));
    }

    @Contract(value="!null, _ -> !null;  null, _ ->  null")
    protected <T> BlockingQueue<T> startDriverAndLaunch(@Nullable Function<CidrDebuggingFixture.DriverEvent, T> eventFilter, @Nullable ThrowableConsumer<? super DebuggerDriver, ? extends Exception> afterLoadBeforeLaunch) throws Exception {
        return this.startDriverAndLaunch((String)null, eventFilter, afterLoadBeforeLaunch);
    }

    @Contract(value="_, !null -> !null; _,  null ->  null")
    protected <T> BlockingQueue<T> startDriverAndLaunch(@Nullable String params, @Nullable Function<CidrDebuggingFixture.DriverEvent, T> eventFilter) throws Exception {
        return this.startDriverAndLaunch(params, eventFilter, (ThrowableConsumer<DebuggerDriver, Exception>)((ThrowableConsumer)driver -> {}));
    }

    @Contract(value="_, !null, _ -> !null; _,  null, _ ->  null")
    protected <T> BlockingQueue<T> startDriverAndLaunch(@Nullable String params, @Nullable Function<CidrDebuggingFixture.DriverEvent, T> eventFilter, @Nullable ThrowableConsumer<? super DebuggerDriver, ? extends Exception> afterLoadBeforeLaunch) throws Exception {
        return this.startDriverAndLaunch(this.createCommandLine(params), eventFilter, afterLoadBeforeLaunch);
    }

    @Contract(value="_, !null, _ -> !null; _,  null, _ ->  null")
    protected <T> BlockingQueue<T> startDriverAndLaunch(@NotNull GeneralCommandLine cl, @Nullable Function<CidrDebuggingFixture.DriverEvent, T> eventFilter, @Nullable ThrowableConsumer<? super DebuggerDriver, ? extends Exception> afterLoadBeforeLaunch) throws Exception {
        BlockingQueue<T> events = this.startDriver(eventFilter);
        this.loadApp(cl);
        if (afterLoadBeforeLaunch != null) {
            afterLoadBeforeLaunch.consume((Object)this.myDriver);
        }
        this.myInferior.start();
        return events;
    }

    @NotNull
    protected static ThrowableConsumer<DebuggerDriver, Exception> withBreakpoint(@NotNull VirtualFile file2, int line) {
        return CidrDebuggerTestCase.withBreakpoint(file2.getPath(), line);
    }

    @NotNull
    protected static ThrowableConsumer<DebuggerDriver, Exception> withBreakpoint(@NotNull String fileName, int line) {
        return driver -> driver.addBreakpoint(fileName, line);
    }

    protected GeneralCommandLine createCommandLine(@Nullable String params) throws Exception {
        return this.createCommandLine(this.getTestExecutablePath(), params);
    }

    protected GeneralCommandLine createCommandLine(String exePath, @Nullable String params) throws Exception {
        return this.createCommandLine(exePath, params == null ? null : StringUtil.split((String)params, (String)" "));
    }

    protected GeneralCommandLine createCommandLine(@Nullable List<String> params) throws Exception {
        return this.createCommandLine(this.getTestExecutablePath(), params);
    }

    protected GeneralCommandLine createCommandLine(String exePath, @Nullable List<String> params) throws Exception {
        GeneralCommandLine cl = new GeneralCommandLine().withCharset(StandardCharsets.UTF_8);
        cl.setExePath(exePath);
        cl = cl.withWorkDirectory(new File(cl.getExePath()).getParent());
        if (params != null) {
            cl.addParameters(params);
        }
        cl.getEnvironment().put("NSUnbufferedIO", "YES");
        this.myDebuggingFixture.getEnvironment().prepare(cl, CidrToolEnvironment.PrepareFor.RUN);
        return cl;
    }

    protected com.intellij.openapi.util.Pair<ProcessHandler, Integer> launchAppAndAttach(@Nullable String params) throws Exception {
        return this.launchAppAndAttach(params, null);
    }

    protected com.intellij.openapi.util.Pair<ProcessHandler, Integer> launchAppAndAttach(@Nullable String params, @Nullable ThrowableRunnable<? extends Exception> beforeAttach) throws Exception {
        com.intellij.openapi.util.Pair<ProcessHandler, Integer> result = this.launchApp(params);
        this.loadAppForAttach((Integer)result.second);
        if (beforeAttach != null) {
            beforeAttach.run();
        }
        this.myInferior.start();
        return result;
    }

    protected com.intellij.openapi.util.Pair<ProcessHandler, Integer> launchApp(@Nullable String params) throws Exception {
        GeneralCommandLine cl = this.createCommandLine(params);
        final BaseProcessHandler handler = this.getEnvironment().getHostMachine().createProcess(cl, false, true);
        int pid = this.getProcessId(cl, handler);
        this.myDisposables.add(new Disposable(){

            public void dispose() {
                handler.destroyProcess();
            }
        });
        handler.startNotify();
        return com.intellij.openapi.util.Pair.create((Object)handler, (Object)pid);
    }

    @NotNull
    protected CidrToolEnvironment getEnvironment() {
        return new CidrToolEnvironment();
    }

    protected int getProcessId(@NotNull GeneralCommandLine cl, @NotNull BaseProcessHandler handler) throws Exception {
        HostMachine host = this.getEnvironment().getHostMachine();
        if (host.isRemote()) {
            for (ProcessInfo info : host.getProcessList()) {
                if (!info.getCommandLine().startsWith(cl.getExePath())) continue;
                return info.getPid();
            }
            return -1;
        }
        return OSProcessUtil.getProcessID((Process)handler.getProcess());
    }

    protected void loadApp() throws Exception {
        this.loadApp((String)null);
    }

    protected void loadApp(@Nullable String params) throws Exception {
        this.loadApp(this.createCommandLine(params));
    }

    protected void loadApp(@NotNull GeneralCommandLine cl) throws Exception {
        this.myInferior = this.myDriver.loadForLaunch(this.createInstaller(cl), this.myDebuggingFixture.getArchitectureType().getId());
    }

    protected void loadAppForAttach(int pid) throws Exception {
        this.myInferior = this.myDriver.loadForAttach(pid);
    }

    protected com.intellij.openapi.util.Pair<File, OSProcessHandler> launchRemoteApp(@Nullable String params) throws Exception {
        GeneralCommandLine appCommandLine = this.createCommandLine(params);
        File gdbserver = this.myDebuggingFixture.getGdbserverExecutable();
        GeneralCommandLine cl = new GeneralCommandLine();
        this.myDebuggingFixture.getEnvironment().prepare(cl, CidrToolEnvironment.PrepareFor.RUN);
        cl.setExePath(gdbserver.getPath());
        cl.addParameters(new String[]{"--once", LOCALHOST_4242});
        cl.addParameter(FileUtil.toSystemIndependentName((String)appCommandLine.getExePath()));
        if (SystemInfo.isWindows) {
            cl.addParameter("--");
        }
        cl.addParameters(appCommandLine.getParametersList().getParameters());
        CidrDebuggerLog.LOG.debug("Starting test gdbserver: " + cl.getCommandLineString());
        final FutureResult pidResult = new FutureResult();
        OSProcessHandler handler = new OSProcessHandler(cl);
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text = StringUtil.trimEnd((String)event.getText(), (String)"\n");
                CidrDebuggerLog.LOG.debug("gdbserver>" + text);
                Matcher pidMatcher = GDBSERVER_TARGET_PID_PATTERN.matcher(text);
                if (pidMatcher.matches()) {
                    this.setPid(Integer.parseInt(pidMatcher.group(1)));
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                int exitCode = event.getExitCode();
                CidrDebuggerLog.LOG.debug("gdbserver finished, exit code: " + exitCode);
                this.setPid(-exitCode);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void setPid(int result) {
                FutureResult futureResult = pidResult;
                synchronized (futureResult) {
                    if (!pidResult.isDone()) {
                        pidResult.set((Object)result);
                    }
                }
            }
        });
        Disposer.register((Disposable)this.getTestRootDisposable(), () -> {
            if (!CidrDebuggingFixture.waitFor((ProcessHandler)handler, 3000L)) {
                handler.destroyProcess();
            }
        });
        handler.startNotify();
        Integer pid = (Integer)CidrDebuggingFixture.waitFor(pidResult, 3000L);
        if (pid != null) {
            CidrDebuggerTestCase.assertTrue((String)("gdbserver exited with code " + -pid.intValue()), (pid > 0 ? 1 : 0) != 0);
            Disposer.register((Disposable)this.getTestRootDisposable(), () -> OSProcessUtil.killProcess((int)pid));
        } else {
            CidrDebuggerLog.LOG.warn("Couldn't retrieve target process PID from gdbserver output");
        }
        return com.intellij.openapi.util.Pair.create((Object)new File(appCommandLine.getExePath()), (Object)handler);
    }

    protected void loadForRemote(@NotNull String connectionString, @Nullable File symbolFile, @NotNull List<DebuggerDriver.PathMapping> pathMappings) throws ExecutionException {
        this.myInferior = ((GDBDriver)this.myDriver).loadForRemote(connectionString, symbolFile, new File("/"), pathMappings);
    }

    @NotNull
    protected com.intellij.openapi.util.Pair<GeneralCommandLine, String> createPrintArgsCommandLineAndExpectedOutput(String ... args) throws Exception {
        args = (String[])ArrayUtil.prepend((Object)"printArgs", (Object[])args);
        StringBuilder outputBuilder = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            outputBuilder.append(i + 1).append(": ").append(args[i]).append("\n");
        }
        return com.intellij.openapi.util.Pair.create((Object)this.createCommandLine(Arrays.asList(args)), (Object)outputBuilder.toString());
    }

    public void assertFrame(LLFrame frame, @Nullable Integer frameNum, @Nullable VirtualFile file2, @Nullable Integer lineNum) {
        this.assertFrame(frame, frameNum, file2, lineNum, null);
    }

    public void assertFrame(LLFrame frame, @Nullable Integer frameNum, @Nullable VirtualFile file2, @Nullable Integer lineNum, @RegExp @Nullable String funcPattern) {
        this.assertFrame(frame, frameNum, file2, lineNum, funcPattern, true);
    }

    public void assertFrame(LLFrame frame, @Nullable Integer frameNum, @Nullable VirtualFile file2, @Nullable Integer lineNum, @RegExp @Nullable String funcPattern, boolean hasProgramCounter) {
        this.assertFrame(frame, frameNum, file2 == null ? null : file2.getPath(), lineNum, funcPattern, hasProgramCounter);
    }

    public void assertFrame(LLFrame frame, @Nullable Integer frameNum, @Nullable String fileName, @Nullable Integer lineNum) {
        this.assertFrame(frame, frameNum, fileName, lineNum, null);
    }

    public void assertFrame(LLFrame frame, @Nullable Integer frameNum, @Nullable String fileName, @Nullable Integer lineNum, @RegExp @Nullable String funcPattern) {
        this.assertFrame(frame, frameNum, fileName, lineNum, funcPattern, true);
    }

    public void assertFrame(LLFrame frame, @Nullable Integer frameNum, @Nullable String fileName, @Nullable Integer lineNum, @RegExp @Nullable String funcPattern, boolean hasProgramCounter) {
        this.myDebuggingFixture.assertFrame(frame, frameNum, fileName, lineNum, funcPattern, hasProgramCounter);
    }

    @NotNull
    public String getExpectedSourceFilePath(@NotNull VirtualFile file2) {
        return this.getExpectedSourceFilePath(file2.getPath());
    }

    @NotNull
    public String getExpectedSourceFilePath(@NotNull String path) {
        if (this.myProjectFixture.getCompilerType() == MSVCCompilerKind.INSTANCE) {
            return path;
        }
        return path;
    }

    public static class PIDReader
    implements Consumer<com.intellij.openapi.util.Pair<String, Key>> {
        private final FutureResult<Integer> myPidResult = new FutureResult();

        public void consume(com.intellij.openapi.util.Pair<String, Key> value) {
            String text = (String)value.first;
            String prefix = "PID: ";
            if (text.startsWith(prefix)) {
                this.myPidResult.set((Object)Integer.valueOf(text.substring(prefix.length()).trim()));
            }
        }

        public FutureResult<Integer> getResult() {
            return this.myPidResult;
        }
    }

    public static class NullHandler
    implements DebuggerDriver.Handler {
        public void handleSignal(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
            if ("SIGTRAP".equals(signal)) {
                this.handleBreakpoint(stopPlace, -1);
            }
        }
    }
}

