/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.CompletionAutoPopupHandler;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.actions.ChooseItemAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrProjectDependentFixture;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public abstract class CidrTextFieldWithAutoCompletionFixture
implements CidrProjectDependentFixture {
    private TextFieldWithAutoCompletion textField;
    private final CompletionType myCompletionType;

    public CidrTextFieldWithAutoCompletionFixture() {
        this(CompletionType.BASIC);
    }

    public CidrTextFieldWithAutoCompletionFixture(CompletionType completionType) {
        this.myCompletionType = completionType;
    }

    @Override
    @NotNull
    public FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTables() {
        return FileSymbolTablesCache.SymbolsProperties.SymbolsKind.ONLY_USED;
    }

    @Override
    public void afterProjectOpened() {
        this.textField = this.createTextFieldWithCompletion();
        UIUtil.invokeAndWaitIfNeeded(() -> this.textField.addNotify());
    }

    protected abstract TextFieldWithAutoCompletion createTextFieldWithCompletion();

    @Override
    public void beforeProjectClosed() {
        EdtTestUtil.runInEdtAndWait(() -> {
            this.textField.removeNotify();
            UIUtil.dispatchAllInvocationEvents();
        });
        this.textField = null;
    }

    public void assertNoCompletion(String input) throws InterruptedException {
        this.assertCompletion(input, input, false);
    }

    public void assertCompletion(String input, String expected) throws InterruptedException {
        this.assertCompletion(input, expected, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertCompletion(String input, String expected, boolean replacing) throws InterruptedException {
        Boolean oldValue = (Boolean)TestModeFlags.set((Key)CompletionAutoPopupHandler.ourTestingAutopopup, (Object)true);
        try {
            EdtTestUtil.runInEdtAndWait(() -> {
                this.textField.setText(input.replace("|", ""));
                this.textField.getCaretModel().moveToOffset(input.indexOf(124));
                CodeCompletionHandlerBase base = new CodeCompletionHandlerBase(this.myCompletionType, false, false, true);
                base.invokeCompletion(this.textField.getProject(), this.textField.getEditor());
            });
            CompletionProgressIndicator indicator = CompletionServiceImpl.getCompletionPhase().indicator;
            long timeout = System.currentTimeMillis() + 60000L;
            while (indicator != null && indicator.isRunning()) {
                Assert.assertTrue((String)"Timed out while waiting for completion", (System.currentTimeMillis() < timeout ? 1 : 0) != 0);
                if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
                    UIUtil.dispatchAllInvocationEvents();
                    continue;
                }
                Thread.sleep(100L);
            }
            Ref result = Ref.create();
            EdtTestUtil.runInEdtAndWait(() -> {
                if (LookupManager.getActiveLookup((Editor)this.textField.getEditor()) != null) {
                    ChooseItemAction.Replacing itemAction = replacing ? new ChooseItemAction.Replacing() : new ChooseItemAction.FocusedOnly();
                    itemAction.actionPerformed(this.textField.getEditor(), DataContext.EMPTY_CONTEXT);
                }
                String resultString = this.textField.getText();
                int offset = this.textField.getCaretModel().getOffset();
                result.set((Object)(resultString.substring(0, offset) + '|' + resultString.substring(offset)));
            });
            Assert.assertEquals((Object)expected, (Object)result.get());
        }
        finally {
            TestModeFlags.set((Key)CompletionAutoPopupHandler.ourTestingAutopopup, (Object)oldValue);
        }
    }
}

