/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.symbols;

import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.ApkDebuggingUsageTracker;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.AsyncResult;
import com.android.tools.idea.apk.debugging.DebuggableSharedObjectFile;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.symbols.NdkPathMatcher;
import com.android.tools.idea.apk.symbols.SharedObjectFile;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.ndk.BuildIdReader;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugSymbolsUpdater {
    @NotNull
    private final LocalPathLocator myLocalPathLocator;
    @NotNull
    private final IdeSdks myIdeSdks;
    @NotNull
    private final NdkPathMatcher myNdkPathMatcher;
    @NotNull
    private final BuildIdReader myBuildIdReader;

    public DebugSymbolsUpdater() {
        this(new LocalPathLocator(), IdeSdks.getInstance(), new NdkPathMatcher(), new BuildIdReader());
    }

    @VisibleForTesting
    DebugSymbolsUpdater(@NotNull LocalPathLocator localPathLocator, @NotNull IdeSdks ideSdks, @NotNull NdkPathMatcher ndkPathMatcher, @NotNull BuildIdReader buildIdReader) {
        this.myLocalPathLocator = localPathLocator;
        this.myIdeSdks = ideSdks;
        this.myNdkPathMatcher = ndkPathMatcher;
        this.myBuildIdReader = buildIdReader;
    }

    @NotNull
    public AsyncResult<UpdateResult> updateDebugSymbolsInLibrary(final @NotNull List<SharedObjectFile> symbolFiles, final @NotNull NativeLibrary library, final @NotNull ApkFacet facet) {
        final AsyncResult<UpdateResult> callback = new AsyncResult<UpdateResult>();
        new Task.Backgroundable(facet.getModule().getProject(), "Updating Library", false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(false);
                try {
                    UpdateResult result = DebugSymbolsUpdater.this.updateDebugSymbolsInLibrary(symbolFiles, library, facet, indicator);
                    callback.setDone(result);
                }
                catch (RuntimeException error) {
                    callback.setRejected(error);
                }
            }
        }.queue();
        return callback;
    }

    @VisibleForTesting
    @NotNull
    public UpdateResult updateDebugSymbolsInLibrary(@NotNull List<SharedObjectFile> symbolFiles, @NotNull NativeLibrary library, @NotNull ApkFacet facet, @NotNull ProgressIndicator indicator) {
        UpdateResult result = new UpdateResult();
        HashSet obsoleteDebugSymbolPaths = new HashSet();
        HashSet<String> newRemoteSourceFolderPaths = new HashSet<String>();
        indicator.setText("Updating debug symbols");
        int symbolFileCount = symbolFiles.size();
        for (int i = 0; i < symbolFileCount; ++i) {
            indicator.setFraction((double)i / (double)symbolFileCount);
            SharedObjectFile symbolFile = symbolFiles.get(i);
            Abi symbolFileAbi = symbolFile.getAbi();
            if (symbolFileAbi == null) {
                result.filesWithoutAbi.add(symbolFile);
                continue;
            }
            if (symbolFile.getDebugSymbolPaths().isEmpty()) {
                result.filesWithoutDebugSymbols.add(symbolFile);
                continue;
            }
            VirtualFile soFileFromApk = (VirtualFile)library.sharedObjectFilesByAbi.get(symbolFileAbi);
            if (soFileFromApk == null) {
                result.filesWithAbiMismatch.add(symbolFile);
                continue;
            }
            if (DebugSymbolsUpdater.isApkDebuggingBuildIdCheckEnabled() && !this.tryMatchBuildIds(soFileFromApk, symbolFile.getActualFile())) {
                result.filesWithBuildIdMismatch.add(symbolFile);
                continue;
            }
            DebuggableSharedObjectFile existingSharedObjectFile = (DebuggableSharedObjectFile)library.debuggableSharedObjectFilesByAbi.get(symbolFileAbi);
            if (existingSharedObjectFile != null) {
                obsoleteDebugSymbolPaths.addAll(existingSharedObjectFile.debugSymbolPaths);
            }
            List<String> debugSymbolPaths = symbolFile.getDebugSymbolPaths();
            obsoleteDebugSymbolPaths.removeAll(debugSymbolPaths);
            DebuggableSharedObjectFile debuggableFile = library.addDebuggableSharedObjectFile(symbolFileAbi, symbolFile.getActualFile());
            debuggableFile.debugSymbolPaths.addAll(symbolFile.getDebugSymbolPaths());
            result.addedFiles.add(debuggableFile);
            for (String debugSymbolPath : debuggableFile.debugSymbolPaths) {
                if (this.myLocalPathLocator.isLocal(debugSymbolPath)) continue;
                newRemoteSourceFolderPaths.add(debugSymbolPath);
            }
            ApkDebuggingUsageTracker.logEvent(facet, AndroidStudioEvent.EventKind.APK_DEBUG_ADD_SYMBOLS);
        }
        if (!obsoleteDebugSymbolPaths.isEmpty()) {
            for (String obsoletePath : obsoleteDebugSymbolPaths) {
                library.removePathMapping(obsoletePath);
            }
        }
        if (!newRemoteSourceFolderPaths.isEmpty()) {
            this.updatePathMappingValues(library, newRemoteSourceFolderPaths, this.myIdeSdks.getAndroidNdkPath());
        }
        library.recalculateSourceFolderPaths();
        return result;
    }

    public void updatePathMappingValues(@NotNull NativeLibrary library, @NotNull Collection<String> newRemoteSourceFolderPaths, @Nullable File ndkPath) {
        for (String debugSymbolPath : newRemoteSourceFolderPaths) {
            File match;
            String mappedPath = "";
            if (ndkPath != null && (match = this.myNdkPathMatcher.findMatchingPathInNdk(debugSymbolPath, ndkPath)) != null) {
                mappedPath = match.getPath();
            }
            library.addPathMapping(debugSymbolPath, mappedPath);
        }
    }

    public boolean isNdkPath(@NotNull String path) {
        return this.myNdkPathMatcher.isNdkPath(path);
    }

    private boolean tryMatchBuildIds(@NotNull VirtualFile soFileFromApk, @NotNull VirtualFile symbolFile) {
        byte[] id1 = this.myBuildIdReader.readBuildId(soFileFromApk);
        if (id1.length == 0) {
            DebugSymbolsUpdater.getLog().info("Skipping build ID matching step, because the binary in the APK does not have a build ID. Enable build ID in your builds to make sure the symbol files can be verified to match the binaries in the APK. File without build ID: " + soFileFromApk.getPath());
            return true;
        }
        byte[] id2 = this.myBuildIdReader.readBuildId(symbolFile);
        return Arrays.equals(id1, id2);
    }

    private static boolean isApkDebuggingBuildIdCheckEnabled() {
        return (Boolean)StudioFlags.APK_DEBUG_BUILD_ID_CHECK.get();
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(DebugSymbolsUpdater.class);
    }

    @VisibleForTesting
    static class LocalPathLocator {
        LocalPathLocator() {
        }

        boolean isLocal(@NotNull String path) {
            return new File(path).exists();
        }
    }

    public class UpdateResult {
        @NotNull
        public List<DebuggableSharedObjectFile> addedFiles = new ArrayList<DebuggableSharedObjectFile>();
        @NotNull
        public List<SharedObjectFile> filesWithoutAbi = new ArrayList<SharedObjectFile>();
        @NotNull
        public List<SharedObjectFile> filesWithoutDebugSymbols = new ArrayList<SharedObjectFile>();
        @NotNull
        public List<SharedObjectFile> filesWithAbiMismatch = new ArrayList<SharedObjectFile>();
        @NotNull
        public List<SharedObjectFile> filesWithBuildIdMismatch = new ArrayList<SharedObjectFile>();
    }
}

