/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network.httpdata;

import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Payload {
    @NotNull
    private final NetworkConnectionsModel myModel;
    @Nullable
    private ByteString myCachedBytes;

    private Payload(@NotNull NetworkConnectionsModel model) {
        this.myModel = model;
    }

    @NotNull
    public static Payload newRequestPayload(@NotNull NetworkConnectionsModel model, final @NotNull HttpData httpData) {
        return new Payload(model){

            @Override
            protected String getId() {
                return httpData.getRequestPayloadId();
            }

            @Override
            @NotNull
            protected HttpData.Header getHeader() {
                return httpData.getRequestHeader();
            }
        };
    }

    @NotNull
    public static Payload newResponsePayload(@NotNull NetworkConnectionsModel model, final @NotNull HttpData httpData) {
        return new Payload(model){

            @Override
            protected String getId() {
                return httpData.getResponsePayloadId();
            }

            @Override
            @NotNull
            protected HttpData.Header getHeader() {
                return httpData.getResponseHeader();
            }
        };
    }

    protected abstract String getId();

    @NotNull
    protected abstract HttpData.Header getHeader();

    @NotNull
    public final ByteString getBytes() {
        if (this.myCachedBytes != null) {
            return this.myCachedBytes;
        }
        this.myCachedBytes = this.myModel.requestBytes(this.getId());
        String contentEncoding = this.getHeader().getContentEncoding();
        if (StringUtil.toLowerCase((String)contentEncoding).contains("gzip")) {
            try (GZIPInputStream inputStream = new GZIPInputStream(new ByteArrayInputStream(this.myCachedBytes.toByteArray()));){
                this.myCachedBytes = ByteString.copyFrom((byte[])FileUtil.loadBytes((InputStream)inputStream));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.myCachedBytes;
    }

    @NotNull
    public HttpData.ContentType getContentType() {
        return this.getHeader().getContentType();
    }
}

