/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network.details;

import com.android.tools.adtui.TreeWalker;
import com.android.tools.adtui.ui.BreakWordWrapHtmlTextPane;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profilers.ProfilerFonts;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TabUiUtils {
    public static final int SCROLL_UNIT = JBUI.scale((int)10);
    public static final int HORIZONTAL_PADDING = 15;
    public static final int TAB_SECTION_VGAP = JBUI.scale((int)5);
    public static final int PAGE_VGAP = JBUI.scale((int)28);
    public static final int SECTION_VGAP = JBUI.scale((int)10);
    public static final String SECTION_TITLE_HEADERS = "Headers";

    private TabUiUtils() {
    }

    @NotNull
    public static JPanel createVerticalPanel(int verticalGap) {
        return new JPanel((LayoutManager)new VerticalFlowLayout(0, verticalGap));
    }

    @NotNull
    public static JBScrollPane createScrollPane(@NotNull JComponent component) {
        JBScrollPane scrollPane = new JBScrollPane((Component)component);
        scrollPane.getVerticalScrollBar().setUnitIncrement(SCROLL_UNIT);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(SCROLL_UNIT);
        return scrollPane;
    }

    @NotNull
    public static JBScrollPane createVerticalScrollPane(@NotNull JComponent component) {
        JBScrollPane scrollPane = TabUiUtils.createScrollPane(component);
        scrollPane.setHorizontalScrollBarPolicy(31);
        return scrollPane;
    }

    @NotNull
    public static HideablePanel createHideablePanel(@NotNull String title, @NotNull JComponent content, @Nullable JComponent northEastComponent) {
        title = String.format("<html><b>%s</b></html>", title);
        return new HideablePanel.Builder(title, content).setNorthEastComponent(northEastComponent).setPanelBorder((Border)new JBEmptyBorder(10, 0, 0, 0)).setContentBorder((Border)new JBEmptyBorder(10, 12, 0, 0)).build();
    }

    @NotNull
    public static JComponent createStyledMapComponent(@NotNull Map<String, String> map) {
        if (map.isEmpty()) {
            return new JLabel("Not available");
        }
        BreakWordWrapHtmlTextPane textPane = new BreakWordWrapHtmlTextPane();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(String.format("<p><b>%s</b>:&nbsp;<span>%s</span></p>", entry.getKey(), entry.getValue()));
        }
        stringBuilder.append("</html>");
        textPane.setText(stringBuilder.toString());
        return textPane;
    }

    public static void adjustFont(@NotNull Component c) {
        if (c.getFont() == null) {
            return;
        }
        c.setFont(c.getFont().deriveFont(0, ProfilerFonts.STANDARD_FONT.getSize2D()));
    }

    @Nullable
    public static JComponent findComponentWithUniqueName(@NotNull JComponent root, @NotNull String name) {
        List matches = new TreeWalker((Component)root).descendantStream().filter(c -> name.equals(c.getName())).collect(Collectors.toList());
        if (matches.size() > 1) {
            throw new IllegalStateException("More than one component found with the name: " + name);
        }
        return matches.size() == 1 ? (JComponent)matches.get(0) : null;
    }
}

