/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network.details;

import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TreeWalker;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.legend.FixedLegend;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ContentType;
import com.android.tools.profilers.FeatureConfig;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.dataviewer.DataViewer;
import com.android.tools.profilers.dataviewer.ImageDataViewer;
import com.android.tools.profilers.network.ConnectionsStateChart;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import com.android.tools.profilers.network.NetworkState;
import com.android.tools.profilers.network.details.TabContent;
import com.android.tools.profilers.network.details.TabUiUtils;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.android.tools.profilers.network.httpdata.Payload;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.BoldLabel;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class OverviewTabContent
extends TabContent {
    private static final LongFunction<String> TIME_FORMATTER = time -> time >= 0L ? StringUtil.formatDuration((long)TimeUnit.MICROSECONDS.toMillis(time)) : "*";
    private static final String ID_CONTENT_TYPE = "CONTENT_TYPE";
    private static final String ID_SIZE = "SIZE";
    private static final String ID_URL = "URL";
    private static final String ID_TIMING = "TIMING";
    private static final String ID_INITIATING_THREAD = "INITIATING_THREAD";
    private static final String ID_OTHER_THREADS = "OTHER_THREADS";
    private static final String ID_RESPONSE_PAYLOAD_VIEWER = "RESPONSE_PAYLOAD_VIEWER";
    private final FeatureConfig myFeatures;
    private final IdeProfilerComponents myComponents;
    private final NetworkConnectionsModel myModel;
    private JPanel myPanel;

    public OverviewTabContent(@NotNull FeatureConfig features, @NotNull IdeProfilerComponents components, @NotNull NetworkConnectionsModel model) {
        this.myFeatures = features;
        this.myComponents = components;
        this.myModel = model;
    }

    private static JComponent createFields(@NotNull HttpData httpData, @Nullable BufferedImage image) {
        int contentLength;
        JPanel myFieldsPanel = new JPanel((LayoutManager)new TabularLayout("Fit-,40px,*").setVGap(TabUiUtils.SECTION_VGAP));
        int row = 0;
        myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Request")), new TabularLayout.Constraint(row, 0));
        myFieldsPanel.add((Component)new JLabel(HttpData.getUrlName(httpData.getUrl())), new TabularLayout.Constraint(row, 2));
        myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Method")), new TabularLayout.Constraint(++row, 0));
        myFieldsPanel.add((Component)new JLabel(httpData.getMethod()), new TabularLayout.Constraint(row, 2));
        HttpData.ResponseHeader responseHeader = httpData.getResponseHeader();
        if (responseHeader.getStatusCode() != -1) {
            myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Status")), new TabularLayout.Constraint(++row, 0));
            JLabel statusCode = new JLabel(String.valueOf(responseHeader.getStatusCode()));
            myFieldsPanel.add((Component)statusCode, new TabularLayout.Constraint(row, 2));
        }
        if (image != null) {
            myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Dimension")), new TabularLayout.Constraint(++row, 0));
            JLabel dimension = new JLabel(String.format("%d x %d", image.getWidth(), image.getHeight()));
            myFieldsPanel.add((Component)dimension, new TabularLayout.Constraint(row, 2));
        }
        if (!responseHeader.getContentType().isEmpty()) {
            myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Content type")), new TabularLayout.Constraint(++row, 0));
            JLabel contentTypeLabel = new JLabel(responseHeader.getContentType().getMimeType());
            contentTypeLabel.setName(ID_CONTENT_TYPE);
            myFieldsPanel.add((Component)contentTypeLabel, new TabularLayout.Constraint(row, 2));
        }
        if ((contentLength = responseHeader.getContentLength()) != -1) {
            try {
                myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Size")), new TabularLayout.Constraint(++row, 0));
                JLabel contentLengthLabel = new JLabel(StringUtil.formatFileSize((long)contentLength));
                contentLengthLabel.setName(ID_SIZE);
                myFieldsPanel.add((Component)contentLengthLabel, new TabularLayout.Constraint(row, 2));
            }
            catch (NumberFormatException contentLengthLabel) {
                // empty catch block
            }
        }
        myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Initiating thread")), new TabularLayout.Constraint(++row, 0));
        JLabel initiatingThreadLabel = new JLabel(httpData.getJavaThreads().get(0).getName());
        initiatingThreadLabel.setName(ID_INITIATING_THREAD);
        myFieldsPanel.add((Component)initiatingThreadLabel, new TabularLayout.Constraint(row, 2));
        if (httpData.getJavaThreads().size() > 1) {
            StringBuilder otherThreadsBuilder = new StringBuilder();
            for (int i2 = 1; i2 < httpData.getJavaThreads().size(); ++i2) {
                if (otherThreadsBuilder.length() > 0) {
                    otherThreadsBuilder.append(", ");
                }
                otherThreadsBuilder.append(httpData.getJavaThreads().get(i2).getName());
            }
            myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Other threads")), new TabularLayout.Constraint(++row, 0));
            JLabel otherThreadsLabel = new JLabel(otherThreadsBuilder.toString());
            otherThreadsLabel.setName(ID_OTHER_THREADS);
            myFieldsPanel.add((Component)otherThreadsLabel, new TabularLayout.Constraint(row, 2));
        }
        NoWrapBoldLabel urlLabel = new NoWrapBoldLabel(ID_URL);
        urlLabel.setVerticalAlignment(1);
        myFieldsPanel.add((Component)((Object)urlLabel), new TabularLayout.Constraint(++row, 0));
        WrappedHyperlink hyperlink = new WrappedHyperlink(httpData.getUrl());
        hyperlink.setName(ID_URL);
        myFieldsPanel.add((Component)hyperlink, new TabularLayout.Constraint(row, 2));
        ++row;
        JSeparator separator = new JSeparator();
        separator.setMinimumSize(separator.getPreferredSize());
        int gap = TabUiUtils.PAGE_VGAP - TabUiUtils.SECTION_VGAP - (int)separator.getPreferredSize().getHeight() / 2;
        JPanel separatorContainer = new JPanel((LayoutManager)new VerticalFlowLayout(0, gap));
        separatorContainer.add(separator);
        myFieldsPanel.add((Component)separatorContainer, new TabularLayout.Constraint(row, 0, 1, 3));
        NoWrapBoldLabel timingLabel = new NoWrapBoldLabel("Timing");
        timingLabel.setVerticalAlignment(1);
        myFieldsPanel.add((Component)((Object)timingLabel), new TabularLayout.Constraint(++row, 0));
        JComponent timingBar = OverviewTabContent.createTimingBar(httpData);
        timingBar.setName(ID_TIMING);
        myFieldsPanel.add((Component)timingBar, new TabularLayout.Constraint(row, 2));
        new TreeWalker((Component)myFieldsPanel).descendantStream().forEach(TabUiUtils::adjustFont);
        return myFieldsPanel;
    }

    @NotNull
    private static JComponent createTimingBar(@NotNull HttpData httpData) {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        Range range = new Range((double)httpData.getRequestStartTimeUs(), httpData.getConnectionEndTimeUs() > 0L ? (double)httpData.getConnectionEndTimeUs() : (double)(httpData.getRequestStartTimeUs() + 1L));
        ConnectionsStateChart connectionsChart = new ConnectionsStateChart(httpData, range);
        connectionsChart.getComponent().setMinimumSize(new Dimension(0, JBUI.scale((int)28)));
        connectionsChart.setHeightGap(0.0f);
        panel2.add(connectionsChart.getComponent());
        long sentTime = -1L;
        long receivedTime = -1L;
        if (httpData.getResponseStartTimeUs() > 0L) {
            sentTime = httpData.getResponseStartTimeUs() - httpData.getRequestStartTimeUs();
            receivedTime = httpData.getResponseCompleteTimeUs() - httpData.getResponseStartTimeUs();
        } else if (httpData.getConnectionEndTimeUs() > 0L) {
            sentTime = httpData.getConnectionEndTimeUs() - httpData.getRequestStartTimeUs();
            receivedTime = 0L;
        }
        FixedLegend sentLegend = new FixedLegend("Sent", TIME_FORMATTER.apply(sentTime));
        FixedLegend receivedLegend = new FixedLegend("Received", TIME_FORMATTER.apply(receivedTime));
        LegendComponentModel legendModel = new LegendComponentModel();
        legendModel.add((Legend)sentLegend);
        legendModel.add((Legend)receivedLegend);
        LegendComponent legend = new LegendComponent.Builder(legendModel).setLeftPadding(0).setVerticalPadding(JBUI.scale((int)8)).build();
        legend.setFont(ProfilerFonts.STANDARD_FONT);
        legend.configure((Legend)sentLegend, new LegendConfig(LegendConfig.IconType.BOX, connectionsChart.getColors().getColor((Enum)NetworkState.SENDING)));
        legend.configure((Legend)receivedLegend, new LegendConfig(LegendConfig.IconType.BOX, connectionsChart.getColors().getColor((Enum)NetworkState.RECEIVING)));
        panel2.add((Component)legend);
        return panel2;
    }

    @Override
    @NotNull
    public String getTitle() {
        return "Overview";
    }

    @Override
    @NotNull
    protected JComponent createComponent() {
        final TabularLayout layout = new TabularLayout("*").setVGap(TabUiUtils.PAGE_VGAP);
        this.myPanel = new JPanel((LayoutManager)layout);
        this.myPanel.setBorder((Border)new JBEmptyBorder(TabUiUtils.PAGE_VGAP, 15, 0, 15));
        final JBScrollPane overviewScroll = TabUiUtils.createVerticalScrollPane(this.myPanel);
        overviewScroll.getVerticalScrollBar().setUnitIncrement(TabUiUtils.SCROLL_UNIT);
        overviewScroll.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                layout.setRowSizing(0, new TabularLayout.SizingRule(TabularLayout.SizingRule.Type.FIXED, (int)((float)overviewScroll.getViewport().getHeight() * 0.4f)));
                layout.layoutContainer((Container)OverviewTabContent.this.myPanel);
            }
        });
        return overviewScroll;
    }

    @Override
    public void populateFor(@Nullable HttpData data) {
        this.myPanel.removeAll();
        if (data == null) {
            return;
        }
        Payload payload = Payload.newResponsePayload(this.myModel, data);
        String mimeType = payload.getContentType().getMimeType();
        DataViewer payloadViewer = this.myComponents.createDataViewer(payload.getBytes().toByteArray(), ContentType.fromMimeType(mimeType), DataViewer.Style.PRETTY);
        JComponent responsePayloadComponent = payloadViewer.getComponent();
        responsePayloadComponent.setName(ID_RESPONSE_PAYLOAD_VIEWER);
        this.myPanel.add((Component)responsePayloadComponent, new TabularLayout.Constraint(0, 0));
        BufferedImage image = payloadViewer instanceof ImageDataViewer ? ((ImageDataViewer)payloadViewer).getImage() : null;
        this.myPanel.add((Component)OverviewTabContent.createFields(data, image), new TabularLayout.Constraint(1, 0));
    }

    @Override
    public void trackWith(@NotNull FeatureTracker featureTracker) {
        featureTracker.trackSelectNetworkDetailsOverview();
    }

    @Nullable
    @VisibleForTesting
    JComponent findResponsePayloadViewer() {
        return TabUiUtils.findComponentWithUniqueName(this.myPanel, ID_RESPONSE_PAYLOAD_VIEWER);
    }

    @Nullable
    @VisibleForTesting
    JLabel findContentTypeValue() {
        return (JLabel)TabUiUtils.findComponentWithUniqueName(this.myPanel, ID_CONTENT_TYPE);
    }

    @Nullable
    @VisibleForTesting
    JLabel findSizeValue() {
        return (JLabel)TabUiUtils.findComponentWithUniqueName(this.myPanel, ID_SIZE);
    }

    @Nullable
    @VisibleForTesting
    JTextArea findUrlValue() {
        return (JTextArea)TabUiUtils.findComponentWithUniqueName(this.myPanel, ID_URL);
    }

    @Nullable
    @VisibleForTesting
    JComponent findTimingBar() {
        return TabUiUtils.findComponentWithUniqueName(this.myPanel, ID_TIMING);
    }

    @Nullable
    @VisibleForTesting
    JLabel findInitiatingThreadValue() {
        return (JLabel)TabUiUtils.findComponentWithUniqueName(this.myPanel, ID_INITIATING_THREAD);
    }

    @Nullable
    @VisibleForTesting
    JLabel findOtherThreadsValue() {
        return (JLabel)TabUiUtils.findComponentWithUniqueName(this.myPanel, ID_OTHER_THREADS);
    }

    private static class WrappedHyperlink
    extends JTextArea {
        public WrappedHyperlink(@NotNull String url) {
            super(url);
            this.setLineWrap(true);
            this.setEditable(false);
            this.setBackground(UIUtil.getLabelBackground());
            this.setFont(ProfilerFonts.STANDARD_FONT.deriveFont((Map<? extends AttributedCharacterIterator.Attribute, ?>)ImmutableMap.of((Object)TextAttribute.FOREGROUND, (Object)PlatformColors.BLUE, (Object)TextAttribute.BACKGROUND, (Object)UIUtil.getLabelBackground())));
            MouseAdapter mouseAdapter = this.getMouseAdapter(url);
            this.addMouseListener(mouseAdapter);
            this.addMouseMotionListener(mouseAdapter);
        }

        private MouseAdapter getMouseAdapter(final String url) {
            return new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    this.mouseMoved(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    this.setCursor(Cursor.getDefaultCursor());
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (this.isMouseOverText(e)) {
                        BrowserUtil.browse((String)url);
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.setCursor(this.isMouseOverText(e) ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
                }

                private boolean isMouseOverText(MouseEvent e) {
                    return this.viewToModel(e.getPoint()) < this.getDocument().getLength();
                }
            };
        }
    }

    static final class NoWrapBoldLabel
    extends BoldLabel {
        public NoWrapBoldLabel(String text) {
            super("<nobr>" + text + "</nobr>");
        }
    }
}

