/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.Range;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.NetworkProfiler;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class LegacyRpcNetworkConnectionsModel
implements NetworkConnectionsModel {
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub myTransportService;
    @NotNull
    private final NetworkServiceGrpc.NetworkServiceBlockingStub myNetworkService;
    @NotNull
    private final Common.Session mySession;

    public LegacyRpcNetworkConnectionsModel(@NotNull TransportServiceGrpc.TransportServiceBlockingStub transportService, @NotNull NetworkServiceGrpc.NetworkServiceBlockingStub networkService, @NotNull Common.Session session) {
        this.myTransportService = transportService;
        this.myNetworkService = networkService;
        this.mySession = session;
    }

    @Override
    @NotNull
    public List<HttpData> getData(@NotNull Range timeCurrentRangeUs) {
        NetworkProfiler.HttpRangeRequest request = NetworkProfiler.HttpRangeRequest.newBuilder().setSession(this.mySession).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin())).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax())).build();
        NetworkProfiler.HttpRangeResponse response = this.myNetworkService.getHttpRange(request);
        ArrayList<HttpData> httpDataList = new ArrayList<HttpData>(response.getDataList().size());
        for (NetworkProfiler.HttpConnectionData connection : response.getDataList()) {
            long startTimeUs = TimeUnit.NANOSECONDS.toMicros(connection.getStartTimestamp());
            long uploadedTimeUs = TimeUnit.NANOSECONDS.toMicros(connection.getUploadedTimestamp());
            long downloadingTimeUs = TimeUnit.NANOSECONDS.toMicros(connection.getDownloadingTimestamp());
            long endTimeUs = TimeUnit.NANOSECONDS.toMicros(connection.getEndTimestamp());
            HttpData.Builder httpBuilder = new HttpData.Builder(connection.getConnId(), startTimeUs, uploadedTimeUs, downloadingTimeUs, endTimeUs, endTimeUs, this.requestAccessingThreads(connection.getConnId()));
            this.requestHttpRequest(connection.getConnId(), httpBuilder);
            if (connection.getUploadedTimestamp() != 0L) {
                this.requestHttpRequestBody(connection.getConnId(), httpBuilder);
            }
            if (connection.getEndTimestamp() != 0L) {
                this.requestHttpResponse(connection.getConnId(), httpBuilder);
                this.requestHttpResponseBody(connection.getConnId(), httpBuilder);
            }
            httpDataList.add(httpBuilder.build());
        }
        return httpDataList;
    }

    private void requestHttpRequest(long connectionId, @NotNull HttpData.Builder httpBuilder) {
        NetworkProfiler.HttpDetailsResponse.Request result = this.getDetails(connectionId, NetworkProfiler.HttpDetailsRequest.Type.REQUEST).getRequest();
        httpBuilder.setUrl(result.getUrl());
        httpBuilder.setMethod(result.getMethod());
        httpBuilder.setRequestFields(result.getFields());
        if (!result.getTraceId().isEmpty()) {
            String trace = this.requestBytes(result.getTraceId()).toStringUtf8();
            httpBuilder.setTrace(trace);
        }
    }

    private void requestHttpRequestBody(long connectionId, @NotNull HttpData.Builder httpBuilder) {
        NetworkProfiler.HttpDetailsResponse result = this.getDetails(connectionId, NetworkProfiler.HttpDetailsRequest.Type.REQUEST_BODY);
        httpBuilder.setRequestPayloadId(result.getRequestBody().getPayloadId());
    }

    private void requestHttpResponseBody(long connectionId, @NotNull HttpData.Builder httpBuilder) {
        NetworkProfiler.HttpDetailsResponse response = this.getDetails(connectionId, NetworkProfiler.HttpDetailsRequest.Type.RESPONSE_BODY);
        String payloadId = response.getResponseBody().getPayloadId();
        httpBuilder.setResponsePayloadId(payloadId);
        httpBuilder.setResponsePayloadSize(response.getResponseBody().getPayloadSize());
    }

    @Override
    @NotNull
    public ByteString requestBytes(@NotNull String id) {
        if (StringUtil.isEmpty((String)id)) {
            return ByteString.EMPTY;
        }
        Transport.BytesRequest request = Transport.BytesRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setId(id).build();
        Transport.BytesResponse response = this.myTransportService.getBytes(request);
        return response.getContents();
    }

    private void requestHttpResponse(long connectionId, @NotNull HttpData.Builder httpBuilder) {
        NetworkProfiler.HttpDetailsResponse response = this.getDetails(connectionId, NetworkProfiler.HttpDetailsRequest.Type.RESPONSE);
        httpBuilder.setResponseFields(response.getResponse().getFields());
    }

    private List<HttpData.JavaThread> requestAccessingThreads(long connectionId) {
        NetworkProfiler.HttpDetailsResponse response = this.getDetails(connectionId, NetworkProfiler.HttpDetailsRequest.Type.ACCESSING_THREADS);
        return response.getAccessingThreads().getThreadList().stream().map(proto -> new HttpData.JavaThread(proto.getId(), proto.getName())).collect(Collectors.toList());
    }

    private NetworkProfiler.HttpDetailsResponse getDetails(long connectionId, NetworkProfiler.HttpDetailsRequest.Type type) {
        return this.myNetworkService.getHttpDetails(NetworkProfiler.HttpDetailsRequest.newBuilder().setConnId(connectionId).setSession(this.mySession).setType(type).build());
    }
}

