/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.chart;

import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.DataVisualizationColors;
import com.android.tools.profilers.memory.chart.ClassifierSetHNode;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/profilers/memory/chart/HeapSetNodeHRenderer;", "Lcom/android/tools/adtui/chart/hchart/HRenderer;", "Lcom/android/tools/profilers/memory/chart/ClassifierSetHNode;", "()V", "render", "", "g", "Ljava/awt/Graphics2D;", "node", "fullDrawingArea", "Ljava/awt/geom/Rectangle2D;", "drawingArea", "isFocused", "", "isDeselected", "intellij.android.profilers.ui"})
public final class HeapSetNodeHRenderer
implements HRenderer<ClassifierSetHNode> {
    public void render(@NotNull Graphics2D g, @NotNull ClassifierSetHNode node, @NotNull Rectangle2D fullDrawingArea, @NotNull Rectangle2D drawingArea, boolean isFocused, boolean isDeselected) {
        Font font;
        int index = node.getName().hashCode();
        Color color = (Color)DataVisualizationColors.INSTANCE.getColor(index, isFocused);
        if (isDeselected && !isFocused) {
            color = DataVisualizationColors.INSTANCE.toGrayscale(color);
        }
        g.setPaint(color);
        g.fill(drawingArea);
        Font restoreFont = font = g.getFont();
        Color textColor = (Color)DataVisualizationColors.INSTANCE.getFontColor(index);
        g.setPaint(textColor);
        if (node.isFiltered() && node.isMatched()) {
            font = font.deriveFont(1);
            g.setFont(font);
        } else if (node.isFiltered()) {
            g.setPaint(ColorUtil.withAlpha((Color)textColor, (double)0.2));
        }
        int marginPadding = 5;
        FontMetrics fontMetrics = g.getFontMetrics(font);
        float availableWidth = (float)drawingArea.getWidth() - (float)(2 * marginPadding);
        String text = AdtUiUtils.shrinkToFit((String)node.getName(), (FontMetrics)fontMetrics, (float)availableWidth, (float)1.0f);
        CharSequence charSequence = text;
        boolean bl = false;
        if (charSequence.length() > 0) {
            float textPositionX = (float)marginPadding + (float)drawingArea.getX();
            float textPositionY = (float)(drawingArea.getY() + (double)fontMetrics.getAscent());
            g.drawString(text, textPositionX, textPositionY);
        }
        g.setFont(restoreFont);
    }
}

