/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.NativeAllocationMethodSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NativeAllocationMethodClassifier
extends Classifier {
    @NotNull
    private final Map<String, NativeAllocationMethodSet> myAllocationMap = new LinkedHashMap<String, NativeAllocationMethodSet>();

    NativeAllocationMethodClassifier() {
    }

    @Override
    @Nullable
    public ClassifierSet getClassifierSet(@NotNull InstanceObject instance, boolean createIfAbsent) {
        ClassDb.ClassEntry classEntry = instance.getClassEntry();
        NativeAllocationMethodSet set = this.myAllocationMap.get(classEntry.getClassName());
        if (set == null && createIfAbsent) {
            set = new NativeAllocationMethodSet(classEntry.getClassName());
            this.myAllocationMap.put(classEntry.getClassName(), set);
        }
        return set;
    }

    @Override
    @NotNull
    public List<ClassifierSet> getFilteredClassifierSets() {
        return ContainerUtil.filter(this.myAllocationMap.values(), child -> !child.getIsFiltered());
    }

    @Override
    @NotNull
    protected List<ClassifierSet> getAllClassifierSets() {
        return new ArrayList<ClassifierSet>(this.myAllocationMap.values());
    }
}

