/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.cpu.nodemodel.CppFunctionModel;
import com.android.tools.profilers.cpu.simpleperf.NodeNameParser;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.LiveAllocationCaptureObject;
import com.android.tools.profilers.memory.adapters.LiveAllocationInstanceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.ThreadId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JniReferenceInstanceObject
implements InstanceObject {
    @NotNull
    private final LiveAllocationCaptureObject myCaptureObject;
    @NotNull
    private final LiveAllocationInstanceObject myReferencedObject;
    private long myAllocTime = Long.MIN_VALUE;
    private long myDeallocTime = Long.MAX_VALUE;
    private final long myRefValue;
    private final long myObjectTag;
    @NotNull
    private ThreadId myAllocThreadId = ThreadId.INVALID_THREAD_ID;
    @NotNull
    private ThreadId myDeallocThreadId = ThreadId.INVALID_THREAD_ID;
    @Nullable
    private Memory.NativeBacktrace myAllocationBacktrace;
    @Nullable
    private Memory.NativeBacktrace myDeallocationBacktrace;
    @Nullable
    private List<CodeLocation> myAllocationLocations;
    @Nullable
    private List<CodeLocation> myDeallocationLocations;
    @Nullable
    private List<FieldObject> myFields;
    private static final String REF_NAME_FORMATTER = "JNI Global Reference (0x%x)";
    private static final String OBJECT_NAME_FORMATTER = "%s@%d";
    private static final String APP_DIR_PATH_PREFIX = "/data/app/";

    public JniReferenceInstanceObject(@NotNull LiveAllocationCaptureObject captureObject, @NotNull LiveAllocationInstanceObject referencedObject, long objectTag, long refValue) {
        this.myCaptureObject = captureObject;
        this.myReferencedObject = referencedObject;
        this.myRefValue = refValue;
        this.myObjectTag = objectTag;
    }

    public void setAllocationTime(long allocTime) {
        this.myAllocTime = allocTime;
    }

    @Override
    public long getAllocTime() {
        return this.myAllocTime;
    }

    public void setDeallocTime(long deallocTime) {
        this.myDeallocTime = deallocTime;
    }

    @Override
    public long getDeallocTime() {
        return this.myDeallocTime;
    }

    @Override
    public int getCallStackDepth() {
        if (this.myAllocationBacktrace == null) {
            return 0;
        }
        return this.getAllocationCodeLocations().size();
    }

    @Override
    @NotNull
    public List<CodeLocation> getAllocationCodeLocations() {
        if (this.myAllocationLocations != null) {
            return this.myAllocationLocations;
        }
        this.myAllocationLocations = this.resolveBacktrace(this.myAllocationBacktrace);
        return this.myAllocationLocations;
    }

    @Override
    @NotNull
    public List<CodeLocation> getDeallocationCodeLocations() {
        if (this.myDeallocationLocations != null) {
            return this.myDeallocationLocations;
        }
        this.myDeallocationLocations = this.resolveBacktrace(this.myDeallocationBacktrace);
        return this.myDeallocationLocations;
    }

    @NotNull
    private List<CodeLocation> resolveBacktrace(@Nullable Memory.NativeBacktrace backtrace) {
        if (backtrace == null || backtrace.getAddressesCount() == 0) {
            return Collections.emptyList();
        }
        Memory.NativeCallStack resolvedStack = this.myCaptureObject.resolveNativeBacktrace(backtrace);
        ArrayList<CodeLocation> codeLocations = new ArrayList<CodeLocation>(resolvedStack.getFramesCount());
        for (Memory.NativeCallStack.NativeFrame frame : resolvedStack.getFramesList()) {
            if (JniReferenceInstanceObject.isHiddenFrame(frame)) continue;
            String functionName = frame.getSymbolName();
            String classOrNamespace = "";
            List<String> parameters = Collections.emptyList();
            try {
                CppFunctionModel nativeFunction = NodeNameParser.createCppFunctionModel(frame.getSymbolName(), false);
                functionName = nativeFunction.getName();
                parameters = nativeFunction.getParameters();
                classOrNamespace = nativeFunction.getClassOrNamespace();
            }
            catch (IllegalStateException | IndexOutOfBoundsException nativeFunction) {
                // empty catch block
            }
            int lineNumber = frame.getLineNumber() == 0 ? -1 : frame.getLineNumber() - 1;
            CodeLocation codeLocation = new CodeLocation.Builder(classOrNamespace).setMethodName(functionName).setMethodParameters(parameters).setNativeCode(true).setNativeModuleName(frame.getModuleName()).setLineNumber(lineNumber).setFileName(frame.getFileName()).build();
            codeLocations.add(codeLocation);
        }
        return codeLocations;
    }

    private static boolean isHiddenFrame(@NotNull Memory.NativeCallStack.NativeFrame frame) {
        String module = frame.getModuleName();
        return module == null || !module.startsWith(APP_DIR_PATH_PREFIX);
    }

    public void setAllocThreadId(@NotNull ThreadId allocThreadId) {
        this.myAllocThreadId = allocThreadId;
    }

    public void setDeallocThreadId(@NotNull ThreadId deallocThreadId) {
        this.myDeallocThreadId = deallocThreadId;
    }

    public void setAllocationBacktrace(@NotNull Memory.NativeBacktrace backtrace) {
        this.myAllocationLocations = null;
        this.myAllocationBacktrace = backtrace;
    }

    public void setDeallocationBacktrace(@NotNull Memory.NativeBacktrace backtrace) {
        this.myDeallocationLocations = null;
        this.myDeallocationBacktrace = backtrace;
    }

    @Override
    public boolean hasTimeData() {
        return this.hasAllocTime() || this.hasDeallocTime();
    }

    @Override
    public boolean hasAllocTime() {
        return this.myAllocTime != Long.MIN_VALUE;
    }

    @Override
    public boolean hasDeallocTime() {
        return this.myDeallocTime != Long.MAX_VALUE;
    }

    @Override
    @NotNull
    public String getName() {
        return "";
    }

    @Override
    public int getHeapId() {
        return 4;
    }

    @Override
    public int getShallowSize() {
        return this.myReferencedObject.getShallowSize();
    }

    @Override
    public boolean getIsRoot() {
        return true;
    }

    @Override
    public int getFieldCount() {
        return 1;
    }

    @Override
    @NotNull
    public List<FieldObject> getFields() {
        if (this.myFields == null) {
            this.myFields = Collections.singletonList(new JniRefField());
        }
        return this.myFields;
    }

    @Override
    @NotNull
    public ThreadId getAllocationThreadId() {
        return this.myAllocThreadId;
    }

    @Override
    @NotNull
    public ThreadId getDeallocationThreadId() {
        return this.myDeallocThreadId;
    }

    @Override
    @NotNull
    public ClassDb.ClassEntry getClassEntry() {
        return this.myReferencedObject.getClassEntry();
    }

    @Override
    @NotNull
    public ValueObject.ValueType getValueType() {
        return this.myReferencedObject.getValueType();
    }

    @Override
    @NotNull
    public String getValueText() {
        return String.format(REF_NAME_FORMATTER, this.myRefValue);
    }

    public long getRefValue() {
        return this.myRefValue;
    }

    private class JniRefField
    implements FieldObject {
        private JniRefField() {
        }

        @Override
        @NotNull
        public String getFieldName() {
            return "";
        }

        @Override
        @Nullable
        public InstanceObject getAsInstance() {
            return JniReferenceInstanceObject.this.myReferencedObject;
        }

        @Override
        @Nullable
        public Object getValue() {
            return "";
        }

        @Override
        @NotNull
        public ValueObject.ValueType getValueType() {
            return ValueObject.ValueType.OBJECT;
        }

        @Override
        @NotNull
        public String getValueText() {
            return String.format(JniReferenceInstanceObject.OBJECT_NAME_FORMATTER, JniReferenceInstanceObject.this.myReferencedObject.getValueText(), JniReferenceInstanceObject.this.myObjectTag);
        }

        @Override
        @NotNull
        public String getName() {
            return "";
        }
    }
}

