/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.CaptureDataSeries;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.CaptureEntry;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.NativeAllocationSampleCaptureObject;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class NativeAllocationSamplesSeries
extends CaptureDataSeries<CaptureObject> {
    @NotNull
    private final MemoryProfilerStage myStage;

    NativeAllocationSamplesSeries(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull FeatureTracker featureTracker, @NotNull MemoryProfilerStage stage) {
        super(client, session, featureTracker);
        this.myStage = stage;
    }

    public List<SeriesData<CaptureDurationData<CaptureObject>>> getDataForRange(Range range) {
        List<Memory.MemoryNativeSampleData> infos = MemoryProfiler.getNativeHeapSamplesForSession(this.myClient, this.mySession, range);
        ArrayList<SeriesData<CaptureDurationData<CaptureObject>>> seriesData = new ArrayList<SeriesData<CaptureDurationData<CaptureObject>>>();
        for (Memory.MemoryNativeSampleData info : infos) {
            seriesData.add((SeriesData<CaptureDurationData<CaptureObject>>)new SeriesData(NativeAllocationSamplesSeries.getHostTime(info.getStartTime()), new CaptureDurationData<CaptureObject>(NativeAllocationSamplesSeries.getDurationUs(info.getStartTime(), info.getEndTime()), false, false, new CaptureEntry<CaptureObject>(info, () -> new NativeAllocationSampleCaptureObject(this.myClient, this.mySession, info, this.myStage)), true)));
        }
        return seriesData;
    }
}

