/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.LifecycleAction;
import com.android.tools.adtui.model.event.LifecycleEventModel;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LifecycleTooltip
implements TooltipModel {
    @NotNull
    private final Timeline myTimeline;
    @NotNull
    private final LifecycleEventModel myEventModel;

    public LifecycleTooltip(@NotNull Timeline timeline, @NotNull LifecycleEventModel eventModel) {
        this.myTimeline = timeline;
        this.myEventModel = eventModel;
    }

    @NotNull
    public Timeline getTimeline() {
        return this.myTimeline;
    }

    @Nullable
    public LifecycleAction getActivityAt(double time) {
        List activitySeries = this.myEventModel.getActivitySeries().getSeries();
        for (SeriesData series : activitySeries) {
            if (!((double)((EventAction)series.value).getStartUs() <= time) || !((double)((EventAction)series.value).getEndUs() > time) && ((EventAction)series.value).getEndUs() != 0L) continue;
            return (LifecycleAction)series.value;
        }
        return null;
    }

    @NotNull
    public List<LifecycleAction> getFragmentsAt(@NotNull Range range) {
        List fragmentSeries = this.myEventModel.getFragmentSeries().getSeries();
        ArrayList<LifecycleAction> fragments = new ArrayList<LifecycleAction>();
        for (SeriesData series : fragmentSeries) {
            if (!((double)((EventAction)series.value).getStartUs() <= range.getMax()) || !((double)((EventAction)series.value).getEndUs() > range.getMin()) && ((EventAction)series.value).getEndUs() != 0L) continue;
            fragments.add((LifecycleAction)series.value);
        }
        return fragments;
    }
}

