/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.profilers.cpu.systemtrace.AtraceProducer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import org.jetbrains.annotations.NotNull;
import trebuchet.io.DataSlice;

public final class AtraceExporter {
    public static void export(@NotNull File file, @NotNull OutputStream output) throws IOException {
        if (!AtraceProducer.verifyFileHasAtraceHeader(file)) {
            throw new IOException("Unable to verify file type for export: " + file.getAbsolutePath());
        }
        AtraceProducer buffer = new AtraceProducer();
        if (!buffer.parseFile(file)) {
            throw new IOException("Failed to parse file for export: " + file.getAbsolutePath());
        }
        try (DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(output);){
            DataSlice line = buffer.next();
            output.write(AtraceProducer.HEADER.toByteArray());
            while ((line = buffer.next()) != null) {
                deflaterOutputStream.write(line.getBuffer());
            }
            deflaterOutputStream.flush();
        }
        catch (IOException ex) {
            throw new IOException("Failed to export atrace file.", ex);
        }
    }
}

