/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisChartModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import com.android.tools.profilers.cpu.analysis.FullTraceAnalysisSummaryTabModel;
import org.jetbrains.annotations.NotNull;

public class CpuFullTraceAnalysisModel
extends CpuAnalysisModel<CpuCapture> {
    private static final String DEFAULT_ANALYSIS_NAME = "All threads";

    public CpuFullTraceAnalysisModel(@NotNull CpuCapture capture, @NotNull Range selectionRange) {
        super(DEFAULT_ANALYSIS_NAME);
        this.init(capture, selectionRange);
    }

    private void init(@NotNull CpuCapture capture, @NotNull Range selectionRange) {
        FullTraceAnalysisSummaryTabModel summaryModel = new FullTraceAnalysisSummaryTabModel(capture.getRange(), selectionRange);
        summaryModel.getDataSeries().add(capture);
        this.addTabModel(summaryModel);
        CpuAnalysisChartModel<CpuCapture> flameModel = new CpuAnalysisChartModel<CpuCapture>(CpuAnalysisTabModel.Type.FLAME_CHART, selectionRange, capture, CpuCapture::getCaptureNodes);
        flameModel.getDataSeries().add(capture);
        this.addTabModel(flameModel);
        CpuAnalysisChartModel<CpuCapture> topDown = new CpuAnalysisChartModel<CpuCapture>(CpuAnalysisTabModel.Type.TOP_DOWN, selectionRange, capture, CpuCapture::getCaptureNodes);
        topDown.getDataSeries().add(capture);
        this.addTabModel(topDown);
        CpuAnalysisChartModel<CpuCapture> bottomUp = new CpuAnalysisChartModel<CpuCapture>(CpuAnalysisTabModel.Type.BOTTOM_UP, selectionRange, capture, CpuCapture::getCaptureNodes);
        bottomUp.getDataSeries().add(capture);
        this.addTabModel(bottomUp);
    }
}

