/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class CpuAnalysisModel<T> {
    private final String myName;
    private final String myMultiSelectNameFormat;
    private int myMultiSelectItemCount;
    private final SortedMap<CpuAnalysisTabModel.Type, CpuAnalysisTabModel<T>> myTabModels = new TreeMap<CpuAnalysisTabModel.Type, CpuAnalysisTabModel<T>>();

    public CpuAnalysisModel(@NotNull String name) {
        this(name, name);
    }

    public CpuAnalysisModel(@NotNull String name, @NotNull String multiSelectNameFormat) {
        this.myName = name;
        this.myMultiSelectItemCount = 1;
        this.myMultiSelectNameFormat = multiSelectNameFormat;
    }

    @NotNull
    public String getName() {
        return this.myMultiSelectItemCount < 2 ? this.myName : String.format(Locale.getDefault(), this.myMultiSelectNameFormat, this.myMultiSelectItemCount);
    }

    public void addTabModel(CpuAnalysisTabModel<T> tabModel) {
        this.myTabModels.put(tabModel.getTabType(), tabModel);
    }

    @NotNull
    public Iterable<CpuAnalysisTabModel<T>> getTabModels() {
        return this.myTabModels.values();
    }

    public int getTabSize() {
        return this.myTabModels.size();
    }

    @NotNull
    public CpuAnalysisTabModel<T> getTabModelAt(int index) throws IndexOutOfBoundsException {
        if (index >= this.myTabModels.size()) {
            throw new IndexOutOfBoundsException();
        }
        int count2 = 0;
        for (CpuAnalysisTabModel<T> tabModel : this.myTabModels.values()) {
            if (count2 == index) {
                return tabModel;
            }
            ++count2;
        }
        throw new IllegalStateException();
    }

    @NotNull
    public CpuAnalysisModel<T> mergeWith(@NotNull CpuAnalysisModel<T> anotherModel) {
        anotherModel.myTabModels.forEach((type, tabModel) -> {
            if (this.myTabModels.containsKey(type)) {
                ((CpuAnalysisTabModel)this.myTabModels.get(type)).getDataSeries().addAll(tabModel.getDataSeries());
            } else {
                this.myTabModels.put((CpuAnalysisTabModel.Type)((Object)type), (CpuAnalysisTabModel<T>)tabModel);
            }
        });
        ++this.myMultiSelectItemCount;
        return this;
    }
}

