/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.InMemoryDataSeries;
import com.android.tools.profilers.cpu.ThreadState;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ImportedTraceThreadDataSeries
extends InMemoryDataSeries<ThreadState> {
    private final int myThreadId;
    @NotNull
    private final List<SeriesData<ThreadState>> myStates;
    @NotNull
    private final CpuCapture myCapture;

    public ImportedTraceThreadDataSeries(@NotNull CpuCapture capture, int tid) {
        this.myCapture = capture;
        this.myThreadId = tid;
        this.myStates = this.buildThreadStates();
    }

    private List<SeriesData<ThreadState>> buildThreadStates() {
        ArrayList<SeriesData<ThreadState>> states = new ArrayList<SeriesData<ThreadState>>();
        CaptureNode root = this.myCapture.getCaptureNode(this.myThreadId);
        if (root == null) {
            ImportedTraceThreadDataSeries.getLogger().warn("Thread root node is unexpectedly null and thread states could not be built.");
            return states;
        }
        List<CaptureNode> rootChildren = root.getChildren();
        for (CaptureNode rootChild : rootChildren) {
            states.add((SeriesData<ThreadState>)new SeriesData(rootChild.getStart(), (Object)ThreadState.HAS_ACTIVITY));
            states.add((SeriesData<ThreadState>)new SeriesData(rootChild.getEnd(), (Object)ThreadState.NO_ACTIVITY));
        }
        return states;
    }

    @Override
    @NotNull
    protected List<SeriesData<ThreadState>> inMemoryDataList() {
        return this.myStates;
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(ImportedTraceThreadDataSeries.class);
    }
}

