/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.service;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.database.NetworkTable;
import com.android.tools.datastore.poller.NetworkDataPoller;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.NetworkProfiler;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import io.grpc.stub.StreamObserver;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class NetworkService
extends NetworkServiceGrpc.NetworkServiceImplBase
implements ServicePassThrough {
    private final NetworkTable myNetworkTable;
    private final Consumer<Runnable> myFetchExecutor;
    private final Map<Long, PollRunner> myRunners = new HashMap<Long, PollRunner>();
    private final DataStoreService myService;

    public NetworkService(@NotNull DataStoreService service, Consumer<Runnable> fetchExecutor) {
        this.myFetchExecutor = fetchExecutor;
        this.myService = service;
        this.myNetworkTable = new NetworkTable();
    }

    public void getData(NetworkProfiler.NetworkDataRequest request, StreamObserver<NetworkProfiler.NetworkDataResponse> responseObserver) {
        NetworkProfiler.NetworkDataResponse.Builder response = NetworkProfiler.NetworkDataResponse.newBuilder();
        List<NetworkProfiler.NetworkProfilerData> datas = this.myNetworkTable.getNetworkDataByRequest(request);
        response.addAllData(datas);
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void startMonitoringApp(NetworkProfiler.NetworkStartRequest request, StreamObserver<NetworkProfiler.NetworkStartResponse> responseObserver) {
        NetworkServiceGrpc.NetworkServiceBlockingStub client = this.myService.getNetworkClient(request.getSession().getStreamId());
        if (client != null) {
            responseObserver.onNext((Object)client.startMonitoringApp(request));
            responseObserver.onCompleted();
            long sessionId = request.getSession().getSessionId();
            this.myRunners.put(sessionId, new NetworkDataPoller(request.getSession(), this.myNetworkTable, client));
            this.myFetchExecutor.accept(this.myRunners.get(sessionId));
        } else {
            responseObserver.onNext((Object)NetworkProfiler.NetworkStartResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
    }

    public void stopMonitoringApp(NetworkProfiler.NetworkStopRequest request, StreamObserver<NetworkProfiler.NetworkStopResponse> responseObserver) {
        NetworkServiceGrpc.NetworkServiceBlockingStub service;
        long sessionId = request.getSession().getSessionId();
        PollRunner runner = this.myRunners.remove(sessionId);
        if (runner != null) {
            runner.stop();
        }
        if ((service = this.myService.getNetworkClient(request.getSession().getStreamId())) == null) {
            responseObserver.onNext((Object)NetworkProfiler.NetworkStopResponse.getDefaultInstance());
        } else {
            responseObserver.onNext((Object)service.stopMonitoringApp(request));
        }
        responseObserver.onCompleted();
    }

    public void getHttpRange(NetworkProfiler.HttpRangeRequest request, StreamObserver<NetworkProfiler.HttpRangeResponse> responseObserver) {
        NetworkProfiler.HttpRangeResponse.Builder response = NetworkProfiler.HttpRangeResponse.newBuilder();
        List<NetworkProfiler.HttpConnectionData> datas = this.myNetworkTable.getNetworkConnectionDataByRequest(request);
        response.addAllData(datas);
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void getHttpDetails(NetworkProfiler.HttpDetailsRequest request, StreamObserver<NetworkProfiler.HttpDetailsResponse> responseObserver) {
        NetworkProfiler.HttpDetailsResponse storedResponse = this.myNetworkTable.getHttpDetailsResponseById(request.getConnId(), request.getSession(), request.getType());
        NetworkProfiler.HttpDetailsResponse.Builder response = NetworkProfiler.HttpDetailsResponse.newBuilder();
        switch (request.getType()) {
            case REQUEST: {
                response.setRequest(storedResponse.getRequest());
                break;
            }
            case REQUEST_BODY: {
                response.setRequestBody(storedResponse.getRequestBody());
                break;
            }
            case RESPONSE: {
                response.setResponse(storedResponse.getResponse());
                break;
            }
            case RESPONSE_BODY: {
                response.setResponseBody(storedResponse.getResponseBody());
                break;
            }
            case ACCESSING_THREADS: {
                response.setAccessingThreads(storedResponse.getAccessingThreads());
                break;
            }
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    @Override
    @NotNull
    public List<DataStoreService.BackingNamespace> getBackingNamespaces() {
        return Collections.singletonList(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
    }

    @Override
    public void setBackingStore(@NotNull DataStoreService.BackingNamespace namespace, @NotNull Connection connection) {
        assert (namespace == DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        this.myNetworkTable.initialize(connection);
    }
}

