/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.configuration;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomExecutions;
import org.jetbrains.idea.maven.dom.model.MavenDomGoal;
import org.jetbrains.idea.maven.dom.model.MavenDomGoals;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinStatus;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.configuration.RepositoryDescription;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.framework.ui.ConfigureDialogWithModulesAndVersion;
import org.jetbrains.kotlin.idea.maven.KotlinMavenBundle;
import org.jetbrains.kotlin.idea.maven.Maven;
import org.jetbrains.kotlin.idea.maven.MavenModulesRelationshipKt;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.PomFileKt;
import org.jetbrains.kotlin.idea.quickfix.ChangeGeneralLanguageFeatureSupportFix;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 F2\u00020\u0001:\u0001FB)\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J(\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J*\u0010\u001d\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J(\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000f0+H\u0016J(\u0010,\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$H\u0016J(\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u0003H\u0014J8\u00102\u001a\u00020\r2\u0006\u00103\u001a\u00020/2\u0006\u00104\u001a\u0002012\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00107\u001a\u00020\u0005H\u0004J \u00108\u001a\u00020\r2\u0006\u00103\u001a\u00020/2\u0006\u00104\u001a\u0002012\u0006\u0010\u000e\u001a\u00020\u000fH$J\b\u00109\u001a\u00020\u0003H\u0014J\u0010\u0010:\u001a\u00020&2\u0006\u0010;\u001a\u00020<H\u0016J\u0018\u0010=\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u0003H$J\u0010\u0010>\u001a\u00020\u00052\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u0010?\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH$J\u0010\u0010@\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u0003H$J4\u0010A\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010B\u001a\u0004\u0018\u00010\u00032\b\u0010C\u001a\u0004\u0018\u00010\u00032\u0006\u0010D\u001a\u00020E2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/idea/maven/configuration/KotlinMavenConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "testArtifactId", "", "addJunit", "", "name", "presentableText", "(Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getPresentableText", "addLibraryDependency", "", "module", "Lcom/intellij/openapi/module/Module;", "element", "Lcom/intellij/psi/PsiElement;", "library", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "libraryJarDescriptors", "", "Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "changeGeneralFeatureConfiguration", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "state", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "forTests", "changeMavenFeatureConfiguration", "messageTitle", "changePomFile", "file", "Lcom/intellij/psi/PsiFile;", "version", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "checkKotlinPlugin", "Lorg/jetbrains/kotlin/idea/configuration/ConfigureKotlinStatus;", "configure", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "configureModule", "configurePlugin", "pom", "Lorg/jetbrains/kotlin/idea/maven/PomFile;", "plugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "createExecution", "pomFile", "kotlinPlugin", "executionId", "goalName", "isTest", "createExecutions", "getMinimumSupportedVersion", "getStatus", "moduleSourceRootGroup", "Lorg/jetbrains/kotlin/idea/configuration/ModuleSourceRootGroup;", "getStdlibArtifactId", "hasKotlinPlugin", "isKotlinModule", "isRelevantGoal", "updateLanguageVersion", "languageVersion", "apiVersion", "requiredStdlibVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "Companion", "kotlin.maven"})
public abstract class KotlinMavenConfigurator
implements KotlinProjectConfigurator {
    private final String testArtifactId;
    private final boolean addJunit;
    @NotNull
    private final String name;
    @NotNull
    private final String presentableText;
    @NotNull
    public static final String GROUP_ID = "org.jetbrains.kotlin";
    @NotNull
    public static final String MAVEN_PLUGIN_ID = "kotlin-maven-plugin";
    private static final String KOTLIN_VERSION_PROPERTY = "kotlin.version";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ConfigureKotlinStatus getStatus(@NotNull ModuleSourceRootGroup moduleSourceRootGroup) {
        Intrinsics.checkNotNullParameter((Object)moduleSourceRootGroup, (String)"moduleSourceRootGroup");
        Module module = moduleSourceRootGroup.getBaseModule();
        if (Intrinsics.areEqual((Object)BuildSystemTypeKt.getBuildSystemType((Module)module), (Object)((Object)Maven.INSTANCE)) ^ true) {
            return ConfigureKotlinStatus.NON_APPLICABLE;
        }
        PsiFile psi2 = (PsiFile)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<PsiFile>(module){
            final /* synthetic */ Module $module;

            @Nullable
            public final PsiFile invoke() {
                return KotlinMavenConfigurator.Companion.findModulePomFile(this.$module);
            }
            {
                this.$module = module;
                super(0);
            }
        }));
        if (psi2 == null || !psi2.isValid() || !(psi2 instanceof XmlFile) || ((XmlFile)psi2).getVirtualFile() == null) {
            return ConfigureKotlinStatus.BROKEN;
        }
        if (this.isKotlinModule(module)) {
            return (ConfigureKotlinStatus)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<ConfigureKotlinStatus>(this, module){
                final /* synthetic */ KotlinMavenConfigurator this$0;
                final /* synthetic */ Module $module;

                @NotNull
                public final ConfigureKotlinStatus invoke() {
                    return KotlinMavenConfigurator.access$checkKotlinPlugin(this.this$0, this.$module);
                }
                {
                    this.this$0 = kotlinMavenConfigurator;
                    this.$module = module;
                    super(0);
                }
            }));
        }
        return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
    }

    /*
     * WARNING - void declaration
     */
    private final ConfigureKotlinStatus checkKotlinPlugin(Module module) {
        boolean bl;
        block16: {
            Object v6;
            Object it;
            block14: {
                PsiFile psiFile = Companion.findModulePomFile(module);
                if (!(psiFile instanceof XmlFile)) {
                    psiFile = null;
                }
                XmlFile xmlFile = (XmlFile)psiFile;
                if (xmlFile == null) {
                    return ConfigureKotlinStatus.BROKEN;
                }
                XmlFile psi2 = xmlFile;
                PomFile pomFile = PomFile.Companion.forFileOrNull(psi2);
                if (pomFile == null) {
                    return ConfigureKotlinStatus.NON_APPLICABLE;
                }
                PomFile pom = pomFile;
                if (this.hasKotlinPlugin(pom)) {
                    return ConfigureKotlinStatus.CONFIGURED;
                }
                MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)module.getProject());
                MavenProject mavenProject = mavenProjectsManager.findProject(module);
                if (mavenProject == null) {
                    return ConfigureKotlinStatus.BROKEN;
                }
                Intrinsics.checkNotNullExpressionValue((Object)mavenProject, (String)"mavenProjectsManager.fin\u2026figureKotlinStatus.BROKEN");
                MavenProject mavenProject2 = mavenProject;
                MavenId kotlinPluginId = PomFileKt.kotlinPluginId(null);
                List list = mavenProject2.getPlugins();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mavenProject.plugins");
                Iterable iterable = list;
                boolean bl2 = false;
                Iterable iterable2 = iterable;
                boolean bl3 = false;
                Iterator iterator = iterable2.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    it = (MavenPlugin)t;
                    boolean bl4 = false;
                    MavenPlugin mavenPlugin = it;
                    Intrinsics.checkNotNullExpressionValue((Object)mavenPlugin, (String)"it");
                    if (!mavenPlugin.getMavenId().equals(kotlinPluginId.getGroupId(), kotlinPluginId.getArtifactId())) continue;
                    v6 = t;
                    break block14;
                }
                v6 = null;
            }
            MavenPlugin mavenPlugin = v6;
            if (mavenPlugin == null) {
                return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
            }
            MavenPlugin kotlinPlugin = mavenPlugin;
            List list = kotlinPlugin.getExecutions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"kotlinPlugin.executions");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl5;
                    block15: {
                        void $this$any$iv2;
                        MavenPlugin.Execution it2 = (MavenPlugin.Execution)element$iv;
                        boolean bl6 = false;
                        MavenPlugin.Execution execution = it2;
                        Intrinsics.checkNotNullExpressionValue((Object)execution, (String)"it");
                        List list2 = execution.getGoals();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"it.goals");
                        it = list2;
                        KotlinMavenConfigurator kotlinMavenConfigurator = this;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl5 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String p1 = (String)element$iv2;
                                boolean bl7 = false;
                                if (!kotlinMavenConfigurator.isRelevantGoal(p1)) continue;
                                bl5 = true;
                                break block15;
                            }
                            bl5 = false;
                        }
                    }
                    if (!bl5) continue;
                    bl = true;
                    break block16;
                }
                bl = false;
            }
        }
        if (bl) {
            return ConfigureKotlinStatus.CONFIGURED;
        }
        return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
    }

    private final boolean hasKotlinPlugin(PomFile pom) {
        boolean bl;
        block9: {
            MavenDomPlugin mavenDomPlugin = pom.findPlugin(PomFileKt.kotlinPluginId(null));
            if (mavenDomPlugin == null) {
                return false;
            }
            MavenDomPlugin plugin = mavenDomPlugin;
            MavenDomExecutions mavenDomExecutions = plugin.getExecutions();
            Intrinsics.checkNotNullExpressionValue((Object)mavenDomExecutions, (String)"plugin.executions");
            List list = mavenDomExecutions.getExecutions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"plugin.executions.executions");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block8: {
                        MavenDomPluginExecution it = (MavenDomPluginExecution)element$iv;
                        boolean bl3 = false;
                        MavenDomPluginExecution mavenDomPluginExecution = it;
                        Intrinsics.checkNotNullExpressionValue((Object)mavenDomPluginExecution, (String)"it");
                        MavenDomGoals mavenDomGoals = mavenDomPluginExecution.getGoals();
                        Intrinsics.checkNotNullExpressionValue((Object)mavenDomGoals, (String)"it.goals");
                        List list2 = mavenDomGoals.getGoals();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"it.goals.goals");
                        Iterable $this$any$iv2 = list2;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                MavenDomGoal it2 = (MavenDomGoal)element$iv2;
                                boolean bl4 = false;
                                MavenDomGoal mavenDomGoal = it2;
                                Intrinsics.checkNotNullExpressionValue((Object)mavenDomGoal, (String)"it");
                                String string = mavenDomGoal.getStringValue();
                                if (string == null) {
                                    string = "";
                                }
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.stringValue ?: \"\"");
                                if (!this.isRelevantGoal(string)) continue;
                                bl2 = true;
                                break block8;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    public void configure(@NotNull Project project, @NotNull Collection<? extends Module> excludeModules) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(excludeModules, (String)"excludeModules");
        ConfigureDialogWithModulesAndVersion dialog = new ConfigureDialogWithModulesAndVersion(project, (KotlinProjectConfigurator)this, excludeModules, this.getMinimumSupportedVersion());
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(this, project, dialog){
            final /* synthetic */ KotlinMavenConfigurator this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ConfigureDialogWithModulesAndVersion $dialog;

            public final void run() {
                NotificationMessageCollector collector = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector((Project)this.$project);
                List list = this.$dialog.getModulesToConfigure();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"dialog.modulesToConfigure");
                for (Module module : MavenModulesRelationshipKt.excludeMavenChildrenModules(this.$project, list)) {
                    PsiFile file = KotlinMavenConfigurator.Companion.findModulePomFile(module);
                    if (file != null && org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator$Companion.access$canConfigureFile(KotlinMavenConfigurator.Companion, file)) {
                        String string = this.$dialog.getKotlinVersion();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dialog.kotlinVersion");
                        this.this$0.configureModule(module, file, string, collector);
                        OpenFileAction.openFile((VirtualFile)file.getVirtualFile(), (Project)this.$project);
                        continue;
                    }
                    Object[] objectArray = new Object[1];
                    String string = module.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
                    objectArray[0] = string;
                    org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator$Companion.access$showErrorMessage(KotlinMavenConfigurator.Companion, this.$project, KotlinMavenBundle.message("error.cant.find.pom.for.module", objectArray));
                }
                collector.showNotification();
            }
            {
                this.this$0 = kotlinMavenConfigurator;
                this.$project = project;
                this.$dialog = configureDialogWithModulesAndVersion;
            }
        });
    }

    @NotNull
    protected String getMinimumSupportedVersion() {
        return "1.0.0";
    }

    protected abstract boolean isKotlinModule(@NotNull Module var1);

    protected abstract boolean isRelevantGoal(@NotNull String var1);

    protected abstract void createExecutions(@NotNull PomFile var1, @NotNull MavenDomPlugin var2, @NotNull Module var3);

    @NotNull
    protected abstract String getStdlibArtifactId(@NotNull Module var1, @NotNull String var2);

    public boolean configureModule(@NotNull Module module, @NotNull PsiFile file, @NotNull String version, @NotNull NotificationMessageCollector collector) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        return this.changePomFile(module, file, version, collector);
    }

    private final boolean changePomFile(Module module, PsiFile file, String version, NotificationMessageCollector collector) {
        RepositoryDescription repositoryDescription;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            String string = "Virtual file should exists for psi file " + file.getName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        VirtualFile virtualFile2 = virtualFile;
        MavenDomProjectModel domModel = MavenDomUtil.getMavenDomProjectModel((Project)module.getProject(), (VirtualFile)virtualFile2);
        if (domModel == null) {
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            KotlinMavenConfigurator.Companion.showErrorMessage(project, null);
            return false;
        }
        PsiFile psiFile = file;
        if (psiFile == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
        }
        PomFile pomFile = PomFile.Companion.forFileOrNull((XmlFile)psiFile);
        if (pomFile == null) {
            return false;
        }
        PomFile pom = pomFile;
        pom.addProperty(KOTLIN_VERSION_PROPERTY, version);
        pom.addDependency(new MavenId(GROUP_ID, this.getStdlibArtifactId(module, version), "${kotlin.version}"), MavenArtifactScope.COMPILE, null, false, null);
        if (this.testArtifactId != null) {
            pom.addDependency(new MavenId(GROUP_ID, this.testArtifactId, "${kotlin.version}"), MavenArtifactScope.TEST, null, false, null);
        }
        if (this.addJunit) {
            pom.addDependency(new MavenId("junit", "junit", "4.12"), MavenArtifactScope.TEST, null, false, null);
        }
        if ((repositoryDescription = ConfigureKotlinInProjectUtilsKt.getRepositoryForVersion((String)version)) != null) {
            pom.addLibraryRepository(repositoryDescription);
            pom.addPluginRepository(repositoryDescription);
        }
        MavenDomPlugin plugin = pom.addPlugin(new MavenId(GROUP_ID, MAVEN_PLUGIN_ID, "${kotlin.version}"));
        this.createExecutions(pom, plugin, module);
        this.configurePlugin(pom, plugin, module, version);
        CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)file));
        Object[] objectArray = new Object[1];
        String string = virtualFile2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"virtualFile.path");
        objectArray[0] = string;
        collector.addMessage(KotlinMavenBundle.message("file.was.modified", objectArray));
        return true;
    }

    protected void configurePlugin(@NotNull PomFile pom, @NotNull MavenDomPlugin plugin, @NotNull Module module, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)pom, (String)"pom");
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
    }

    protected final void createExecution(@NotNull PomFile pomFile, @NotNull MavenDomPlugin kotlinPlugin, @NotNull String executionId, @NotNull String goalName, @NotNull Module module, boolean isTest) {
        Intrinsics.checkNotNullParameter((Object)pomFile, (String)"pomFile");
        Intrinsics.checkNotNullParameter((Object)kotlinPlugin, (String)"kotlinPlugin");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)goalName, (String)"goalName");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        pomFile.addKotlinExecution(module, kotlinPlugin, executionId, PomFile.Companion.getPhase(false, isTest), isTest, CollectionsKt.listOf((Object)goalName));
        if (KotlinMavenConfigurator.Companion.hasJavaFiles(module)) {
            pomFile.addJavacExecutions(module, kotlinPlugin);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void updateLanguageVersion(@NotNull Module module, @Nullable String languageVersion, @Nullable String apiVersion, @NotNull ApiVersion requiredStdlibVersion, boolean forTests) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)requiredStdlibVersion, (String)"requiredStdlibVersion");
        $fun$doUpdateMavenLanguageVersion$1 = new Function0<PsiElement>(module, languageVersion, apiVersion){
            final /* synthetic */ Module $module;
            final /* synthetic */ String $languageVersion;
            final /* synthetic */ String $apiVersion;

            @Nullable
            public final PsiElement invoke() {
                PsiFile psiFile = KotlinMavenConfigurator.Companion.findModulePomFile(this.$module);
                if (!(psiFile instanceof XmlFile)) {
                    psiFile = null;
                }
                XmlFile xmlFile = (XmlFile)psiFile;
                if (xmlFile == null) {
                    return null;
                }
                XmlFile psi2 = xmlFile;
                PomFile pomFile = PomFile.Companion.forFileOrNull(psi2);
                if (pomFile == null) {
                    return null;
                }
                PomFile pom = pomFile;
                return PomFileKt.changeLanguageVersion(pom, this.$languageVersion, this.$apiVersion);
            }
            {
                this.$module = module;
                this.$languageVersion = string;
                this.$apiVersion = string2;
                super(0);
            }
        };
        v0 = KotlinVersionInfoProviderKt.getRuntimeLibraryVersion((Module)module);
        if (v0 == null) ** GOTO lbl-1000
        var8_7 = v0;
        var9_8 = false;
        var10_9 = false;
        it = var8_7;
        $i$a$-let-KotlinMavenConfigurator$updateLanguageVersion$runtimeUpdateRequired$1 = false;
        v0 = ApiVersion.Companion.parse(it);
        if (v0 != null) {
            var8_7 = v0;
            var9_8 = false;
            var10_9 = false;
            runtimeVersion = var8_7;
            $i$a$-let-KotlinMavenConfigurator$updateLanguageVersion$runtimeUpdateRequired$2 = false;
            v1 = runtimeVersion.compareTo(requiredStdlibVersion) < 0;
        } else lbl-1000:
        // 2 sources

        {
            v1 = runtimeUpdateRequired = false;
        }
        if (runtimeUpdateRequired) {
            Messages.showErrorDialog((Project)module.getProject(), (String)KotlinMavenBundle.message("update.language.version.feature", new Object[]{requiredStdlibVersion}), (String)KotlinMavenBundle.message("update.language.version.title", new Object[0]));
            return;
        }
        element = $fun$doUpdateMavenLanguageVersion$1.invoke();
        if (element == null) {
            Messages.showErrorDialog((Project)module.getProject(), (String)KotlinMavenBundle.message("error.failed.update.pom", new Object[0]), (String)KotlinMavenBundle.message("update.language.version.title", new Object[0]));
        } else {
            v2 = module.getProject();
            v3 = element.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"element.containingFile");
            v4 = v3.getVirtualFile();
            v5 = element.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"element.textRange");
            new OpenFileDescriptor(v2, v4, v5.getStartOffset()).navigate(true);
        }
    }

    public void addLibraryDependency(@NotNull Module module, @NotNull PsiElement element, @NotNull ExternalLibraryDescriptor library, @NotNull List<? extends LibraryJarDescriptor> libraryJarDescriptors) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter(libraryJarDescriptors, (String)"libraryJarDescriptors");
        DependencyScope dependencyScope = OrderEntryFix.suggestScopeByLocation((Module)module, (PsiElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)dependencyScope, (String)"OrderEntryFix.suggestSco\u2026Location(module, element)");
        DependencyScope scope = dependencyScope;
        JavaProjectModelModificationService.getInstance((Project)module.getProject()).addDependency(module, library, scope);
    }

    public void changeGeneralFeatureConfiguration(@NotNull Module module, @NotNull LanguageFeature feature, @NotNull LanguageFeature.State state, boolean forTests) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ApiVersion sinceVersion = feature.getSinceApiVersion();
        String messageTitle = ChangeGeneralLanguageFeatureSupportFix.Companion.getFixText(feature, state);
        if (state != LanguageFeature.State.DISABLED && KotlinVersionInfoProviderKt.toApiVersion((String)KotlinVersionInfoProviderKt.getRuntimeLibraryVersion((Module)module)).compareTo(sinceVersion) < 0) {
            Messages.showErrorDialog((Project)module.getProject(), (String)KotlinMavenBundle.message("update.language.version.feature.support", feature.getPresentableName(), sinceVersion), (String)messageTitle);
            return;
        }
        PsiElement element = this.changeMavenFeatureConfiguration(module, feature, state, messageTitle);
        if (element != null) {
            Project project = module.getProject();
            PsiFile psiFile = element.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"element.containingFile");
            VirtualFile virtualFile = psiFile.getVirtualFile();
            TextRange textRange = element.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.textRange");
            new OpenFileDescriptor(project, virtualFile, textRange.getStartOffset()).navigate(true);
        }
    }

    private final PsiElement changeMavenFeatureConfiguration(Module module, LanguageFeature feature, LanguageFeature.State state, String messageTitle) {
        PsiFile psiFile = Companion.findModulePomFile(module);
        if (!(psiFile instanceof XmlFile)) {
            psiFile = null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        if (xmlFile == null) {
            return null;
        }
        XmlFile psi2 = xmlFile;
        PomFile pomFile = PomFile.Companion.forFileOrNull(psi2);
        if (pomFile == null) {
            return null;
        }
        PomFile pom = pomFile;
        PsiElement element = PomFileKt.changeFeatureConfiguration(pom, feature, state);
        if (element == null) {
            Messages.showErrorDialog((Project)module.getProject(), (String)KotlinMavenBundle.message("error.failed.update.pom", new Object[0]), (String)messageTitle);
        }
        return element;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getPresentableText() {
        return this.presentableText;
    }

    protected KotlinMavenConfigurator(@Nullable String testArtifactId, boolean addJunit, @NotNull String name, @NotNull String presentableText) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)presentableText, (String)"presentableText");
        this.testArtifactId = testArtifactId;
        this.addJunit = addJunit;
        this.name = name;
        this.presentableText = presentableText;
    }

    public static final /* synthetic */ ConfigureKotlinStatus access$checkKotlinPlugin(KotlinMavenConfigurator $this, Module module) {
        return $this.checkKotlinPlugin(module);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/maven/configuration/KotlinMavenConfigurator$Companion;", "", "()V", "GROUP_ID", "", "KOTLIN_VERSION_PROPERTY", "MAVEN_PLUGIN_ID", "canConfigureFile", "", "file", "Lcom/intellij/psi/PsiFile;", "findModulePomFile", "module", "Lcom/intellij/openapi/module/Module;", "hasJavaFiles", "showErrorMessage", "", "project", "Lcom/intellij/openapi/project/Project;", "message", "kotlin.maven"})
    public static final class Companion {
        private final boolean hasJavaFiles(Module module) {
            return !FileTypeIndex.getFiles((FileType)((FileType)JavaFileType.INSTANCE), (GlobalSearchScope)GlobalSearchScope.moduleScope((Module)module)).isEmpty();
        }

        @Nullable
        public final PsiFile findModulePomFile(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)module.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"MavenProjectsManager.getInstance(module.project)");
            List list = mavenProjectsManager.getProjectsFiles();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"MavenProjectsManager.get\u2026le.project).projectsFiles");
            List files = list;
            for (VirtualFile file : files) {
                PsiFile psiFile;
                Module fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)module.getProject());
                if (Intrinsics.areEqual((Object)module, (Object)fileModule) ^ true) continue;
                if (PsiManager.getInstance((Project)module.getProject()).findFile(file) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiManager.getInstance(m\u2026indFile(file) ?: continue");
                if (!MavenDomUtil.isProjectFile((PsiFile)psiFile)) continue;
                return psiFile;
            }
            return null;
        }

        private final boolean canConfigureFile(PsiFile file) {
            return WritingAccessProvider.isPotentiallyWritable((VirtualFile)file.getVirtualFile(), null);
        }

        private final void showErrorMessage(Project project, String message) {
            String cantConfigureAutomatically = KotlinMavenBundle.message("error.cant.configure.maven.automatically", new Object[0]);
            String seeInstructions = KotlinMavenBundle.message("error.see.installation.instructions", new Object[0]);
            Messages.showErrorDialog((Project)project, (String)("<html>" + cantConfigureAutomatically + "<br/>" + (message != null ? message + "</br>" : "") + seeInstructions + "</html>"), (String)KotlinMavenBundle.message("configure.title", new Object[0]));
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$canConfigureFile(Companion $this, PsiFile file) {
            return $this.canConfigureFile(file);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

