/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast;

import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.incremental.java.ExternalJavacOptionsProvider;
import org.jetbrains.jps.javac.ast.api.JavacFileReferencesRegistrar;
import org.jetbrains.jps.service.JpsServiceManager;

public class ReferenceCollectorExternalJavacOptionsProvider
implements ExternalJavacOptionsProvider {
    @Override
    @NotNull
    public Collection<String> getOptions(@NotNull JavaCompilingTool tool) {
        if (tool.getId().equals("Javac")) {
            return Collections.singletonList("-Dexternal.java.process.ref.collector.enabled=" + ReferenceCollectorExternalJavacOptionsProvider.isEnabled());
        }
        return Collections.emptyList();
    }

    private static boolean isEnabled() {
        for (JavacFileReferencesRegistrar listener : JpsServiceManager.getInstance().getExtensions(JavacFileReferencesRegistrar.class)) {
            if (!listener.isEnabled()) continue;
            return true;
        }
        return false;
    }
}

