/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.relativizer;

import com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.relativizer.PathRelativizer;

class CommonPathRelativizer
implements PathRelativizer {
    private final String myPath;
    private final String myIdentifier;

    CommonPathRelativizer(@Nullable String path, @NotNull String identifier) {
        this.myPath = path;
        this.myIdentifier = identifier;
    }

    @Override
    @Nullable
    public String toRelativePath(@NotNull String path) {
        if (this.myPath == null || !FileUtil.startsWith((String)path, (String)this.myPath)) {
            return null;
        }
        return this.myIdentifier + path.substring(this.myPath.length());
    }

    @Override
    @Nullable
    public String toAbsolutePath(@NotNull String path) {
        if (this.myPath == null || !path.startsWith(this.myIdentifier)) {
            return null;
        }
        return this.myPath + path.substring(this.myIdentifier.length());
    }
}

