/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.dependencies;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.dependencies.DependencyResolvingBuilder;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;

public final class ProjectDependenciesResolver
extends TargetBuilder<BuildRootDescriptor, ProjectDependenciesResolvingTarget> {
    public static final String TARGET_TYPE_ID = "project-dependencies-resolving";

    public ProjectDependenciesResolver() {
        super(Collections.singletonList(ProjectDependenciesResolvingTargetType.INSTANCE));
    }

    @Override
    public void build(@NotNull ProjectDependenciesResolvingTarget target, @NotNull DirtyFilesHolder<BuildRootDescriptor, ProjectDependenciesResolvingTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) {
        context.processMessage(new ProgressMessage("Resolving repository libraries in the project..."));
        try {
            DependencyResolvingBuilder.resolveMissingDependencies(context, context.getProjectDescriptor().getProject().getModules(), BuildTargetChunk.forSingleTarget(target));
        }
        catch (Exception e) {
            DependencyResolvingBuilder.reportError(context, "project", e);
        }
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return "Project Dependencies Resolver";
    }

    public static class ProjectDependenciesResolvingTargetType
    extends BuildTargetType<ProjectDependenciesResolvingTarget> {
        public static final ProjectDependenciesResolvingTargetType INSTANCE = new ProjectDependenciesResolvingTargetType();

        public ProjectDependenciesResolvingTargetType() {
            super(ProjectDependenciesResolver.TARGET_TYPE_ID);
        }

        @Override
        @NotNull
        public List<ProjectDependenciesResolvingTarget> computeAllTargets(@NotNull JpsModel model) {
            return Collections.singletonList(new ProjectDependenciesResolvingTarget());
        }

        @Override
        @NotNull
        public BuildTargetLoader<ProjectDependenciesResolvingTarget> createLoader(@NotNull JpsModel model) {
            return new BuildTargetLoader<ProjectDependenciesResolvingTarget>(){

                @Override
                public ProjectDependenciesResolvingTarget createTarget(@NotNull String targetId) {
                    return new ProjectDependenciesResolvingTarget();
                }
            };
        }
    }

    public static class ProjectDependenciesResolvingTarget
    extends BuildTarget<BuildRootDescriptor> {
        public ProjectDependenciesResolvingTarget() {
            super(ProjectDependenciesResolvingTargetType.INSTANCE);
        }

        @Override
        public String getId() {
            return "project";
        }

        @Override
        public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<BuildRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public BuildRootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
            return null;
        }

        @Override
        @NotNull
        public String getPresentableName() {
            return "Project Dependencies Resolving";
        }

        @Override
        @NotNull
        public Collection<File> getOutputRoots(CompileContext context) {
            return Collections.emptyList();
        }
    }
}

