/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IntentionPolicy {
    public boolean mayInvokeIntention(@NotNull IntentionAction action) {
        String familyName;
        if (!action.startInWriteAction() || this.shouldSkipIntention(action.getText())) {
            return false;
        }
        IntentionAction original = IntentionActionDelegate.unwrap((IntentionAction)action);
        if (original instanceof QuickFixWrapper) {
            LocalQuickFix fix = ((QuickFixWrapper)original).getFix();
            familyName = fix.getFamilyName();
        } else {
            familyName = original.getFamilyName();
        }
        return !this.shouldSkipByFamilyName(familyName);
    }

    protected boolean shouldSkipIntention(@NotNull String actionText) {
        return actionText.startsWith("Typo: Change to...") || actionText.startsWith("Convert to project line separators");
    }

    protected boolean shouldSkipByFamilyName(@NotNull String familyName) {
        return false;
    }

    protected boolean shouldCheckPreview(@NotNull IntentionAction action) {
        return false;
    }

    public boolean mayBreakCode(@NotNull IntentionAction action, @NotNull Editor editor, @NotNull PsiFile file2) {
        return "Flip ','".equals(action.getText());
    }

    public boolean checkComments(IntentionAction intention) {
        return false;
    }

    public boolean trackComment(PsiComment comment) {
        return true;
    }

    @NotNull
    public List<PsiElement> getElementsToWrap(@NotNull PsiElement currentElement) {
        return Collections.emptyList();
    }

    @NotNull
    public String getWrapPrefix() {
        return "";
    }

    public String getWrapSuffix() {
        return "";
    }

    public boolean shouldTolerateIntroducedError(@NotNull HighlightInfo info) {
        return false;
    }
}

