/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class RunAll
implements Runnable {
    private final List<? extends ThrowableRunnable<?>> myActions;

    @SafeVarargs
    public RunAll(ThrowableRunnable<Throwable> ... actions) {
        this(Arrays.asList(actions));
    }

    public RunAll(@NotNull List<? extends ThrowableRunnable<?>> actions) {
        this.myActions = actions;
    }

    @SafeVarargs
    public static void runAll(ThrowableRunnable<Throwable> ... actions) {
        CompoundRuntimeException.throwIfNotEmpty(RunAll.collectExceptions(Arrays.asList(actions)));
    }

    @SafeVarargs
    @Contract(pure=true)
    public final RunAll append(ThrowableRunnable<Throwable> ... actions) {
        return new RunAll(ContainerUtil.concat(this.myActions, actions.length == 1 ? Collections.singletonList(actions[0]) : Arrays.asList(actions)));
    }

    @Override
    public void run() {
        this.run(Collections.emptyList());
    }

    public void run(@NotNull List<? extends Throwable> suppressedExceptions) {
        CompoundRuntimeException.throwIfNotEmpty((List)ContainerUtil.concat(suppressedExceptions, RunAll.collectExceptions(this.myActions)));
    }

    @NotNull
    private static List<Throwable> collectExceptions(@NotNull List<? extends ThrowableRunnable<?>> actions) {
        SmartList result = null;
        for (ThrowableRunnable<?> action : actions) {
            try {
                action.run();
            }
            catch (CompoundRuntimeException e) {
                if (result == null) {
                    result = new ArrayList();
                }
                result.addAll(e.getExceptions());
            }
            catch (Throwable e) {
                if (result == null) {
                    result = new SmartList();
                }
                result.add(e);
            }
        }
        return ContainerUtil.notNullize(result);
    }
}

