/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.EdtTestUtilKt;
import com.intellij.testFramework.FileStructureTestFixture;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightFixtureTestCase;
import com.intellij.util.PathUtil;
import javax.swing.JTree;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileStructureTestBase
extends CodeInsightFixtureTestCase {
    protected FileStructureTestFixture myPopupFixture;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myPopupFixture = new FileStructureTestFixture(this.myFixture);
    }

    protected void configureDefault() {
        this.myFixture.configureByFile(PathUtil.makeFileName((String)this.getTestName(false), (String)this.getFileExtension()));
    }

    protected abstract String getFileExtension();

    @Override
    public void tearDown() throws Exception {
        try {
            Disposer.dispose((Disposable)this.myPopupFixture);
            this.myPopupFixture = null;
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected void checkTree(String filter) {
        this.checkTree(filter, true);
    }

    protected void checkTree() {
        EdtTestUtilKt.runInEdtAndWait((Function0<Unit>)((Function0)() -> {
            this.checkTree(null, true);
            return null;
        }));
    }

    protected void checkTree(boolean expandAll) {
        this.checkTree(null, expandAll);
    }

    protected void checkTree(@Nullable String filter, boolean expandAll) {
        this.configureDefault();
        this.myPopupFixture.update();
        if (filter != null) {
            this.setSearchFilter(filter);
        }
        if (expandAll) {
            PlatformTestUtil.expandAll((JTree)this.myPopupFixture.getTree());
        }
        this.checkResult();
    }

    protected void setSearchFilter(@NotNull String filter) {
        this.myPopupFixture.getPopup().setSearchFilterForTests(filter);
        PlatformTestUtil.waitForPromise(this.myPopupFixture.getPopup().rebuildAndUpdate());
        this.myPopupFixture.getSpeedSearch().findAndSelectElement(filter);
    }

    protected void checkResult() {
        String expectedFileName = this.getTestDataPath() + "/" + PathUtil.makeFileName((String)this.getTestName(false), (String)"tree");
        PlatformTestUtil.waitWhileBusy((JTree)this.myPopupFixture.getTree());
        FileStructureTestBase.assertSameLinesWithFile(expectedFileName, PlatformTestUtil.print((JTree)this.myPopupFixture.getTree(), true).trim());
    }
}

