/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class AsyncValueLoader<T> {
    private final AtomicReference<Promise<T>> ref = new AtomicReference();
    private volatile long modificationCount;
    private volatile long loadedModificationCount;
    private final Consumer<T> doneHandler = new Consumer<T>(){

        @Override
        public void accept(T o) {
            AsyncValueLoader.this.loadedModificationCount = AsyncValueLoader.this.modificationCount;
        }
    };

    @NotNull
    public final Promise<T> get() {
        return this.get(true);
    }

    public final T getResultIfFullFilled() {
        Promise<T> result = this.ref.get();
        try {
            return (T)(result != null && result.isSucceeded() ? result.blockingGet(0) : null);
        }
        catch (ExecutionException | TimeoutException e) {
            return null;
        }
    }

    public final void reset() {
        Promise oldValue = this.ref.getAndSet(null);
        if (oldValue instanceof AsyncPromise) {
            this.rejectAndDispose((AsyncPromise)oldValue);
        }
    }

    private void rejectAndDispose(@NotNull AsyncPromise<? extends T> asyncResult) {
        Object result;
        if (asyncResult.setError("rejected")) {
            return;
        }
        try {
            result = asyncResult.blockingGet(0);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        if (result != null) {
            this.disposeResult(result);
        }
    }

    protected void disposeResult(@NotNull T result) {
        if (result instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)result), (boolean)false);
        }
    }

    @NotNull
    public final Promise<T> get(boolean checkFreshness) {
        Promise<T> promise = this.ref.get();
        if (promise == null) {
            promise = new AsyncPromise();
            if (!this.ref.compareAndSet(null, promise)) {
                return this.ref.get();
            }
        } else {
            Promise.State state = promise.getState();
            if (state == Promise.State.PENDING) {
                return promise;
            }
            if (state == Promise.State.SUCCEEDED) {
                if (!checkFreshness || this.isUpToDate()) {
                    return promise;
                }
                if (!this.ref.compareAndSet(promise, promise = new AsyncPromise())) {
                    Promise<T> valueFromAnotherThread = this.ref.get();
                    while (valueFromAnotherThread == null) {
                        if (this.ref.compareAndSet(null, promise)) {
                            return this.getPromise((AsyncPromise)promise);
                        }
                        valueFromAnotherThread = this.ref.get();
                    }
                    return valueFromAnotherThread;
                }
            }
        }
        return this.getPromise((AsyncPromise)promise);
    }

    protected boolean isCancelOnReject() {
        return false;
    }

    @NotNull
    private Promise<T> getPromise(@NotNull AsyncPromise<T> promise) {
        Promise<T> effectivePromise;
        try {
            effectivePromise = this.load(promise);
            if (effectivePromise != promise) {
                this.ref.compareAndSet(promise, effectivePromise);
            }
        }
        catch (Throwable e) {
            this.ref.compareAndSet(promise, null);
            this.rejectAndDispose(promise);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        effectivePromise.onSuccess(this.doneHandler);
        if (this.isCancelOnReject()) {
            effectivePromise.onError(throwable -> this.ref.compareAndSet(effectivePromise, null));
        }
        if (effectivePromise != promise) {
            effectivePromise.processed(promise);
        }
        return effectivePromise;
    }

    @NotNull
    protected abstract Promise<T> load(@NotNull AsyncPromise<T> var1) throws IOException;

    private boolean isUpToDate() {
        return this.loadedModificationCount == this.modificationCount;
    }

    public final void set(@NotNull T result) {
        Promise<T> oldValue = this.ref.getAndSet(Promises.resolvedPromise(result));
        if (oldValue instanceof AsyncPromise) {
            this.rejectAndDispose((AsyncPromise)oldValue);
        }
    }

    public final void markDirty() {
        ++this.modificationCount;
    }
}

