/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.util;

import android.os.Handler;
import com.android.utils.Pair;
import java.util.LinkedList;
import java.util.WeakHashMap;

public class HandlerMessageQueue {
    private final WeakHashMap<Handler, LinkedList<Pair<Long, Runnable>>> runnablesMap = new WeakHashMap();

    public void add(Handler h, long uptimeMillis, Runnable r) {
        int idx;
        LinkedList runnables = this.runnablesMap.computeIfAbsent(h, k -> new LinkedList());
        for (idx = 0; idx < runnables.size() && (Long)((Pair)runnables.get(idx)).getFirst() <= uptimeMillis; ++idx) {
        }
        runnables.add(idx, Pair.of((Object)uptimeMillis, (Object)r));
    }

    public Runnable extractFirst(long uptimeMillis) {
        HandlerWrapper w = new HandlerWrapper();
        this.runnablesMap.forEach((h, l) -> {
            long currentUptime;
            if (!(l.isEmpty() || (currentUptime = ((Long)((Pair)l.getFirst()).getFirst()).longValue()) > uptimeMillis || w.handler != null && currentUptime >= (Long)this.runnablesMap.get(w.handler).getFirst().getFirst())) {
                w.handler = h;
            }
        });
        if (w.handler != null) {
            return (Runnable)this.runnablesMap.get(w.handler).pollFirst().getSecond();
        }
        return null;
    }

    public boolean isNotEmpty() {
        return this.runnablesMap.values().stream().anyMatch(l -> !l.isEmpty());
    }

    public int size() {
        return this.runnablesMap.values().stream().mapToInt(LinkedList::size).sum();
    }

    public void clear() {
        this.runnablesMap.clear();
    }

    private static class HandlerWrapper {
        public Handler handler;

        private HandlerWrapper() {
        }
    }
}

