/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.R;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.CaptioningManager;

public class SubtitleView
extends View {
    private static final float INNER_PADDING_RATIO = 0.125f;
    private static final int COLOR_BEVEL_DARK = Integer.MIN_VALUE;
    private static final int COLOR_BEVEL_LIGHT = -2130706433;
    private final float mCornerRadius;
    private final float mOutlineWidth;
    private final float mShadowRadius;
    private final float mShadowOffsetX;
    private final float mShadowOffsetY;
    private final RectF mLineBounds = new RectF();
    private final SpannableStringBuilder mText = new SpannableStringBuilder();
    private Layout.Alignment mAlignment = Layout.Alignment.ALIGN_CENTER;
    private TextPaint mTextPaint;
    private Paint mPaint;
    private int mForegroundColor;
    private int mBackgroundColor;
    private int mEdgeColor;
    private int mEdgeType;
    private boolean mHasMeasurements;
    private int mLastMeasuredWidth;
    private StaticLayout mLayout;
    private float mSpacingMult = 1.0f;
    private float mSpacingAdd = 0.0f;
    private int mInnerPaddingX = 0;

    public SubtitleView(Context context) {
        this(context, null);
    }

    public SubtitleView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SubtitleView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public SubtitleView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TextView, defStyleAttr, defStyleRes);
        CharSequence text = "";
        int textSize = 15;
        int n = a.getIndexCount();
        block6: for (int i = 0; i < n; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 18: {
                    text = a.getText(attr2);
                    continue block6;
                }
                case 53: {
                    this.mSpacingAdd = a.getDimensionPixelSize(attr2, (int)this.mSpacingAdd);
                    continue block6;
                }
                case 54: {
                    this.mSpacingMult = a.getFloat(attr2, this.mSpacingMult);
                    continue block6;
                }
                case 0: {
                    textSize = a.getDimensionPixelSize(attr2, textSize);
                }
            }
        }
        Resources res = this.getContext().getResources();
        this.mCornerRadius = res.getDimensionPixelSize(17105485);
        this.mOutlineWidth = res.getDimensionPixelSize(17105486);
        this.mShadowRadius = res.getDimensionPixelSize(17105488);
        this.mShadowOffsetY = this.mShadowOffsetX = (float)res.getDimensionPixelSize(17105487);
        this.mTextPaint = new TextPaint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setSubpixelText(true);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.setText(text);
        this.setTextSize(textSize);
    }

    public void setText(int resId) {
        CharSequence text = this.getContext().getText(resId);
        this.setText(text);
    }

    public void setText(CharSequence text) {
        this.mText.clear();
        this.mText.append(text);
        this.mHasMeasurements = false;
        this.requestLayout();
        this.invalidate();
    }

    public void setForegroundColor(int color2) {
        this.mForegroundColor = color2;
        this.invalidate();
    }

    @Override
    public void setBackgroundColor(int color2) {
        this.mBackgroundColor = color2;
        this.invalidate();
    }

    public void setEdgeType(int edgeType) {
        this.mEdgeType = edgeType;
        this.invalidate();
    }

    public void setEdgeColor(int color2) {
        this.mEdgeColor = color2;
        this.invalidate();
    }

    public void setTextSize(float size) {
        if (this.mTextPaint.getTextSize() != size) {
            this.mTextPaint.setTextSize(size);
            this.mInnerPaddingX = (int)(size * 0.125f + 0.5f);
            this.mHasMeasurements = false;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setTypeface(Typeface typeface) {
        if (this.mTextPaint.getTypeface() != typeface) {
            this.mTextPaint.setTypeface(typeface);
            this.mHasMeasurements = false;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setAlignment(Layout.Alignment textAlignment) {
        if (this.mAlignment != textAlignment) {
            this.mAlignment = textAlignment;
            this.mHasMeasurements = false;
            this.requestLayout();
            this.invalidate();
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpec = View.MeasureSpec.getSize(widthMeasureSpec);
        if (this.computeMeasurements(widthSpec)) {
            StaticLayout layout2 = this.mLayout;
            int paddingX = this.mPaddingLeft + this.mPaddingRight + this.mInnerPaddingX * 2;
            int width = layout2.getWidth() + paddingX;
            int height = layout2.getHeight() + this.mPaddingTop + this.mPaddingBottom;
            this.setMeasuredDimension(width, height);
        } else {
            this.setMeasuredDimension(0x1000000, 0x1000000);
        }
    }

    @Override
    public void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = r - l;
        this.computeMeasurements(width);
    }

    private boolean computeMeasurements(int maxWidth) {
        if (this.mHasMeasurements && maxWidth == this.mLastMeasuredWidth) {
            return true;
        }
        int paddingX = this.mPaddingLeft + this.mPaddingRight + this.mInnerPaddingX * 2;
        if ((maxWidth -= paddingX) <= 0) {
            return false;
        }
        this.mHasMeasurements = true;
        this.mLastMeasuredWidth = maxWidth;
        this.mLayout = StaticLayout.Builder.obtain(this.mText, 0, this.mText.length(), this.mTextPaint, maxWidth).setAlignment(this.mAlignment).setLineSpacing(this.mSpacingAdd, this.mSpacingMult).setUseLineSpacingFromFallbacks(true).build();
        return true;
    }

    public void setStyle(int styleId) {
        Context context = this.mContext;
        ContentResolver cr = context.getContentResolver();
        CaptioningManager.CaptionStyle style2 = styleId == -1 ? CaptioningManager.CaptionStyle.getCustomStyle(cr) : CaptioningManager.CaptionStyle.PRESETS[styleId];
        CaptioningManager.CaptionStyle defStyle = CaptioningManager.CaptionStyle.DEFAULT;
        this.mForegroundColor = style2.hasForegroundColor() ? style2.foregroundColor : defStyle.foregroundColor;
        this.mBackgroundColor = style2.hasBackgroundColor() ? style2.backgroundColor : defStyle.backgroundColor;
        this.mEdgeType = style2.hasEdgeType() ? style2.edgeType : defStyle.edgeType;
        this.mEdgeColor = style2.hasEdgeColor() ? style2.edgeColor : defStyle.edgeColor;
        this.mHasMeasurements = false;
        Typeface typeface = style2.getTypeface();
        this.setTypeface(typeface);
        this.requestLayout();
    }

    @Override
    protected void onDraw(Canvas c) {
        int edgeType;
        StaticLayout layout2 = this.mLayout;
        if (layout2 == null) {
            return;
        }
        int saveCount = c.save();
        int innerPaddingX = this.mInnerPaddingX;
        c.translate(this.mPaddingLeft + innerPaddingX, this.mPaddingTop);
        int lineCount = layout2.getLineCount();
        TextPaint textPaint = this.mTextPaint;
        Paint paint = this.mPaint;
        RectF bounds = this.mLineBounds;
        if (Color.alpha(this.mBackgroundColor) > 0) {
            float cornerRadius = this.mCornerRadius;
            float previousBottom = layout2.getLineTop(0);
            paint.setColor(this.mBackgroundColor);
            paint.setStyle(Paint.Style.FILL);
            for (int i = 0; i < lineCount; ++i) {
                bounds.left = layout2.getLineLeft(i) - (float)innerPaddingX;
                bounds.right = layout2.getLineRight(i) + (float)innerPaddingX;
                bounds.top = previousBottom;
                previousBottom = bounds.bottom = (float)layout2.getLineBottom(i);
                c.drawRoundRect(bounds, cornerRadius, cornerRadius, paint);
            }
        }
        if ((edgeType = this.mEdgeType) == 1) {
            textPaint.setStrokeJoin(Paint.Join.ROUND);
            textPaint.setStrokeWidth(this.mOutlineWidth);
            textPaint.setColor(this.mEdgeColor);
            textPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            for (int i = 0; i < lineCount; ++i) {
                layout2.drawText(c, i, i);
            }
        } else if (edgeType == 2) {
            textPaint.setShadowLayer(this.mShadowRadius, this.mShadowOffsetX, this.mShadowOffsetY, this.mEdgeColor);
        } else if (edgeType == 3 || edgeType == 4) {
            boolean raised = edgeType == 3;
            int colorUp = raised ? -1 : this.mEdgeColor;
            int colorDown = raised ? this.mEdgeColor : -1;
            float offset = this.mShadowRadius / 2.0f;
            textPaint.setColor(this.mForegroundColor);
            textPaint.setStyle(Paint.Style.FILL);
            textPaint.setShadowLayer(this.mShadowRadius, -offset, -offset, colorUp);
            for (int i = 0; i < lineCount; ++i) {
                layout2.drawText(c, i, i);
            }
            textPaint.setShadowLayer(this.mShadowRadius, offset, offset, colorDown);
        }
        textPaint.setColor(this.mForegroundColor);
        textPaint.setStyle(Paint.Style.FILL);
        for (int i = 0; i < lineCount; ++i) {
            layout2.drawText(c, i, i);
        }
        textPaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
        c.restoreToCount(saveCount);
    }
}

