/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.internal.util.Preconditions;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.LockPatternView;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class LockscreenCredential
implements Parcelable,
AutoCloseable {
    private final int mType;
    private byte[] mCredential;
    public static final Parcelable.Creator<LockscreenCredential> CREATOR = new Parcelable.Creator<LockscreenCredential>(){

        @Override
        public LockscreenCredential createFromParcel(Parcel source) {
            return new LockscreenCredential(source.readInt(), source.createByteArray());
        }

        public LockscreenCredential[] newArray(int size) {
            return new LockscreenCredential[size];
        }
    };

    private LockscreenCredential(int type, byte[] credential) {
        Objects.requireNonNull(credential);
        if (type == -1) {
            Preconditions.checkArgument(credential.length == 0);
        } else {
            Preconditions.checkArgument(type == 3 || type == 4 || type == 1);
            Preconditions.checkArgument(credential.length > 0);
        }
        this.mType = type;
        this.mCredential = credential;
    }

    public static LockscreenCredential createNone() {
        return new LockscreenCredential(-1, new byte[0]);
    }

    public static LockscreenCredential createPattern(List<LockPatternView.Cell> pattern) {
        return new LockscreenCredential(1, LockPatternUtils.patternToByteArray(pattern));
    }

    public static LockscreenCredential createPassword(CharSequence password) {
        return new LockscreenCredential(4, LockscreenCredential.charSequenceToByteArray(password));
    }

    public static LockscreenCredential createManagedPassword(byte[] password) {
        return new LockscreenCredential(4, Arrays.copyOf(password, password.length));
    }

    public static LockscreenCredential createPin(CharSequence pin) {
        return new LockscreenCredential(3, LockscreenCredential.charSequenceToByteArray(pin));
    }

    public static LockscreenCredential createPasswordOrNone(CharSequence password) {
        if (TextUtils.isEmpty(password)) {
            return LockscreenCredential.createNone();
        }
        return LockscreenCredential.createPassword(password);
    }

    public static LockscreenCredential createPinOrNone(CharSequence pin) {
        if (TextUtils.isEmpty(pin)) {
            return LockscreenCredential.createNone();
        }
        return LockscreenCredential.createPin(pin);
    }

    private void ensureNotZeroized() {
        Preconditions.checkState(this.mCredential != null, "Credential is already zeroized");
    }

    public int getType() {
        this.ensureNotZeroized();
        return this.mType;
    }

    public byte[] getCredential() {
        this.ensureNotZeroized();
        return this.mCredential;
    }

    public int getStorageCryptType() {
        if (this.isNone()) {
            return 1;
        }
        if (this.isPattern()) {
            return 2;
        }
        if (this.isPin()) {
            return 3;
        }
        if (this.isPassword()) {
            return 0;
        }
        throw new IllegalStateException("Unhandled credential type");
    }

    public boolean isNone() {
        this.ensureNotZeroized();
        return this.mType == -1;
    }

    public boolean isPattern() {
        this.ensureNotZeroized();
        return this.mType == 1;
    }

    public boolean isPin() {
        this.ensureNotZeroized();
        return this.mType == 3;
    }

    public boolean isPassword() {
        this.ensureNotZeroized();
        return this.mType == 4;
    }

    public int size() {
        this.ensureNotZeroized();
        return this.mCredential.length;
    }

    public LockscreenCredential duplicate() {
        return new LockscreenCredential(this.mType, this.mCredential != null ? Arrays.copyOf(this.mCredential, this.mCredential.length) : null);
    }

    public void zeroize() {
        if (this.mCredential != null) {
            Arrays.fill(this.mCredential, (byte)0);
            this.mCredential = null;
        }
    }

    public void checkLength() {
        if (this.isNone()) {
            return;
        }
        if (this.isPattern()) {
            if (this.size() < 4) {
                throw new IllegalArgumentException("pattern must not be null and at least 4 dots long.");
            }
            return;
        }
        if (this.isPassword() || this.isPin()) {
            if (this.size() < 4) {
                throw new IllegalArgumentException("password must not be null and at least of length 4");
            }
            return;
        }
    }

    public boolean checkAgainstStoredType(int storedCredentialType) {
        if (storedCredentialType == 2) {
            return this.getType() == 4 || this.getType() == 3;
        }
        return this.getType() == storedCredentialType;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mType);
        dest.writeByteArray(this.mCredential);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void close() {
        this.zeroize();
    }

    public int hashCode() {
        return (17 + this.mType) * 31 + this.mCredential.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LockscreenCredential)) {
            return false;
        }
        LockscreenCredential other = (LockscreenCredential)o;
        return this.mType == other.mType && Arrays.equals(this.mCredential, other.mCredential);
    }

    private static byte[] charSequenceToByteArray(CharSequence chars) {
        if (chars == null) {
            return new byte[0];
        }
        byte[] bytes = new byte[chars.length()];
        for (int i = 0; i < chars.length(); ++i) {
            bytes[i] = (byte)chars.charAt(i);
        }
        return bytes;
    }
}

