/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.SystemClock;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.IndentingPrintWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class StatLogger {
    private static final String TAG = "StatLogger";
    private final Object mLock = new Object();
    private final int SIZE;
    @GuardedBy(value={"mLock"})
    private final int[] mCountStats;
    @GuardedBy(value={"mLock"})
    private final long[] mDurationStats;
    @GuardedBy(value={"mLock"})
    private final int[] mCallsPerSecond;
    @GuardedBy(value={"mLock"})
    private final long[] mDurationPerSecond;
    @GuardedBy(value={"mLock"})
    private final int[] mMaxCallsPerSecond;
    @GuardedBy(value={"mLock"})
    private final long[] mMaxDurationPerSecond;
    @GuardedBy(value={"mLock"})
    private final long[] mMaxDurationStats;
    @GuardedBy(value={"mLock"})
    private long mNextTickTime = SystemClock.elapsedRealtime() + 1000L;
    private final String[] mLabels;

    public StatLogger(String[] eventLabels) {
        this.SIZE = eventLabels.length;
        this.mCountStats = new int[this.SIZE];
        this.mDurationStats = new long[this.SIZE];
        this.mCallsPerSecond = new int[this.SIZE];
        this.mMaxCallsPerSecond = new int[this.SIZE];
        this.mDurationPerSecond = new long[this.SIZE];
        this.mMaxDurationPerSecond = new long[this.SIZE];
        this.mMaxDurationStats = new long[this.SIZE];
        this.mLabels = eventLabels;
    }

    public long getTime() {
        return SystemClock.elapsedRealtimeNanos() / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long logDurationStat(int eventId, long start) {
        Object object = this.mLock;
        synchronized (object) {
            long nowRealtime;
            long duration = this.getTime() - start;
            if (eventId < 0 || eventId >= this.SIZE) {
                Slog.wtf(TAG, "Invalid event ID: " + eventId);
                return duration;
            }
            int n = eventId;
            this.mCountStats[n] = this.mCountStats[n] + 1;
            int n2 = eventId;
            this.mDurationStats[n2] = this.mDurationStats[n2] + duration;
            if (this.mMaxDurationStats[eventId] < duration) {
                this.mMaxDurationStats[eventId] = duration;
            }
            if ((nowRealtime = SystemClock.elapsedRealtime()) > this.mNextTickTime) {
                if (this.mMaxCallsPerSecond[eventId] < this.mCallsPerSecond[eventId]) {
                    this.mMaxCallsPerSecond[eventId] = this.mCallsPerSecond[eventId];
                }
                if (this.mMaxDurationPerSecond[eventId] < this.mDurationPerSecond[eventId]) {
                    this.mMaxDurationPerSecond[eventId] = this.mDurationPerSecond[eventId];
                }
                this.mCallsPerSecond[eventId] = 0;
                this.mDurationPerSecond[eventId] = 0L;
                this.mNextTickTime = nowRealtime + 1000L;
            }
            int n3 = eventId;
            this.mCallsPerSecond[n3] = this.mCallsPerSecond[n3] + 1;
            int n4 = eventId;
            this.mDurationPerSecond[n4] = this.mDurationPerSecond[n4] + duration;
            return duration;
        }
    }

    public void dump(PrintWriter pw, String prefix) {
        this.dump(new IndentingPrintWriter((Writer)pw, "  ").setIndent(prefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Stats:");
            pw.increaseIndent();
            for (int i = 0; i < this.SIZE; ++i) {
                int count = this.mCountStats[i];
                double durationMs = (double)this.mDurationStats[i] / 1000.0;
                pw.println(String.format("%s: count=%d, total=%.1fms, avg=%.3fms, max calls/s=%d max dur/s=%.1fms max time=%.1fms", this.mLabels[i], count, durationMs, count == 0 ? 0.0 : durationMs / (double)count, this.mMaxCallsPerSecond[i], (double)this.mMaxDurationPerSecond[i] / 1000.0, (double)this.mMaxDurationStats[i] / 1000.0));
            }
            pw.decreaseIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpProto(ProtoOutputStream proto, long fieldId) {
        Object object = this.mLock;
        synchronized (object) {
            long outer = proto.start(fieldId);
            for (int i = 0; i < this.mLabels.length; ++i) {
                long inner = proto.start(2246267895809L);
                proto.write(0x10500000001L, i);
                proto.write(1138166333442L, this.mLabels[i]);
                proto.write(1120986464259L, this.mCountStats[i]);
                proto.write(1112396529668L, this.mDurationStats[i]);
                proto.write(0x10500000005L, this.mMaxCallsPerSecond[i]);
                proto.write(1112396529670L, this.mMaxDurationPerSecond[i]);
                proto.write(1112396529671L, this.mMaxDurationStats[i]);
                proto.end(inner);
            }
            proto.end(outer);
        }
    }
}

