/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.animation.HasNativeInterpolator;
import android.graphics.animation.NativeInterpolator;
import android.graphics.animation.NativeInterpolatorFactory;
import android.util.AttributeSet;
import android.view.animation.BaseInterpolator;
import com.android.internal.R;

@HasNativeInterpolator
public class AccelerateInterpolator
extends BaseInterpolator
implements NativeInterpolator {
    private final float mFactor;
    private final double mDoubleFactor;

    public AccelerateInterpolator() {
        this.mFactor = 1.0f;
        this.mDoubleFactor = 2.0;
    }

    public AccelerateInterpolator(float factor) {
        this.mFactor = factor;
        this.mDoubleFactor = 2.0f * this.mFactor;
    }

    public AccelerateInterpolator(Context context, AttributeSet attrs) {
        this(context.getResources(), context.getTheme(), attrs);
    }

    public AccelerateInterpolator(Resources res, Resources.Theme theme, AttributeSet attrs) {
        TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, R.styleable.AccelerateInterpolator, 0, 0) : res.obtainAttributes(attrs, R.styleable.AccelerateInterpolator);
        this.mFactor = a.getFloat(0, 1.0f);
        this.mDoubleFactor = 2.0f * this.mFactor;
        this.setChangingConfiguration(a.getChangingConfigurations());
        a.recycle();
    }

    @Override
    public float getInterpolation(float input) {
        if (this.mFactor == 1.0f) {
            return input * input;
        }
        return (float)Math.pow(input, this.mDoubleFactor);
    }

    @Override
    public long createNativeInterpolator() {
        return NativeInterpolatorFactory.createAccelerateInterpolator(this.mFactor);
    }
}

