/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.Handler;
import android.os.RemoteException;
import android.util.CloseGuard;
import android.view.IScrollCaptureClient;
import android.view.IScrollCaptureController;
import android.view.ScrollCaptureSession;
import android.view.ScrollCaptureTarget;
import android.view.Surface;
import android.view.View;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class ScrollCaptureClient
extends IScrollCaptureClient.Stub {
    private static final String TAG = "ScrollCaptureClient";
    private static final int DEFAULT_TIMEOUT = 1000;
    private final Handler mHandler;
    private ScrollCaptureTarget mSelectedTarget;
    private int mTimeoutMillis = 1000;
    protected Surface mSurface;
    private IScrollCaptureController mController;
    private final Rect mScrollBounds;
    private final Point mPositionInWindow;
    private final CloseGuard mCloseGuard;
    private ScrollCaptureSession mSession;
    private DelayedAction mTimeoutAction;

    public ScrollCaptureClient(final ScrollCaptureTarget selectedTarget, IScrollCaptureController controller) {
        Objects.requireNonNull(selectedTarget, "<selectedTarget> must non-null");
        Objects.requireNonNull(controller, "<controller> must non-null");
        Rect scrollBounds = Objects.requireNonNull(selectedTarget.getScrollBounds(), "target.getScrollBounds() must be non-null to construct a client");
        this.mSelectedTarget = selectedTarget;
        this.mHandler = selectedTarget.getContainingView().getHandler();
        this.mScrollBounds = new Rect(scrollBounds);
        this.mPositionInWindow = new Point(selectedTarget.getPositionInWindow());
        this.mController = controller;
        this.mCloseGuard = new CloseGuard();
        this.mCloseGuard.open("close");
        selectedTarget.getContainingView().addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            @Override
            public void onViewAttachedToWindow(View v) {
            }

            @Override
            public void onViewDetachedFromWindow(View v) {
                selectedTarget.getContainingView().removeOnAttachStateChangeListener(this);
                ScrollCaptureClient.this.endCapture();
            }
        });
    }

    @VisibleForTesting
    public void setTimeoutMillis(int timeoutMillis) {
        this.mTimeoutMillis = timeoutMillis;
    }

    @VisibleForTesting
    public DelayedAction getTimeoutAction() {
        return this.mTimeoutAction;
    }

    private void checkConnected() {
        if (this.mSelectedTarget == null || this.mController == null) {
            throw new IllegalStateException("This client has been disconnected.");
        }
    }

    private void checkStarted() {
        if (this.mSession == null) {
            throw new IllegalStateException("Capture session has not been started!");
        }
    }

    @Override
    public void startCapture(Surface surface) throws RemoteException {
        this.checkConnected();
        this.mSurface = surface;
        this.scheduleTimeout(this.mTimeoutMillis, this::onStartCaptureTimeout);
        this.mSession = new ScrollCaptureSession(this.mSurface, this.mScrollBounds, this.mPositionInWindow, this);
        this.mHandler.post(() -> this.mSelectedTarget.getCallback().onScrollCaptureStart(this.mSession, this::onStartCaptureCompleted));
    }

    private void onStartCaptureCompleted() {
        if (this.cancelTimeout()) {
            this.mHandler.post(() -> {
                try {
                    this.mController.onCaptureStarted();
                }
                catch (RemoteException e) {
                    this.doShutdown();
                }
            });
        }
    }

    private void onStartCaptureTimeout() {
        this.endCapture();
    }

    @Override
    public void requestImage(Rect requestRect) {
        this.checkConnected();
        this.checkStarted();
        this.scheduleTimeout(this.mTimeoutMillis, this::onRequestImageTimeout);
        this.mHandler.post(() -> this.mSelectedTarget.getCallback().onScrollCaptureImageRequest(this.mSession, new Rect(requestRect)));
    }

    void onRequestImageCompleted(long frameNumber, Rect capturedArea) {
        Rect finalCapturedArea = new Rect(capturedArea);
        if (this.cancelTimeout()) {
            this.mHandler.post(() -> {
                try {
                    this.mController.onCaptureBufferSent(frameNumber, finalCapturedArea);
                }
                catch (RemoteException e) {
                    this.doShutdown();
                }
            });
        }
    }

    private void onRequestImageTimeout() {
        this.endCapture();
    }

    @Override
    public void endCapture() {
        if (this.isStarted()) {
            this.scheduleTimeout(this.mTimeoutMillis, this::onEndCaptureTimeout);
            this.mHandler.post(() -> this.mSelectedTarget.getCallback().onScrollCaptureEnd(this::onEndCaptureCompleted));
        } else {
            this.disconnect();
        }
    }

    private boolean isStarted() {
        return this.mController != null && this.mSelectedTarget != null;
    }

    private void onEndCaptureCompleted() {
        if (this.cancelTimeout()) {
            this.doShutdown();
        }
    }

    private void onEndCaptureTimeout() {
        this.doShutdown();
    }

    private void doShutdown() {
        try {
            if (this.mController != null) {
                this.mController.onConnectionClosed();
            }
        }
        catch (RemoteException remoteException) {
        }
        finally {
            this.disconnect();
        }
    }

    public void disconnect() {
        if (this.mSession != null) {
            this.mSession.disconnect();
            this.mSession = null;
        }
        this.mSelectedTarget = null;
        this.mController = null;
    }

    public String toString() {
        return "ScrollCaptureClient{, session=" + this.mSession + ", selectedTarget=" + this.mSelectedTarget + ", clientCallbacks=" + this.mController + "}";
    }

    private boolean cancelTimeout() {
        if (this.mTimeoutAction != null) {
            return this.mTimeoutAction.cancel();
        }
        return false;
    }

    private void scheduleTimeout(long timeoutMillis, Runnable action) {
        if (this.mTimeoutAction != null) {
            this.mTimeoutAction.cancel();
        }
        this.mTimeoutAction = new DelayedAction(this.mHandler, timeoutMillis, action);
    }

    @VisibleForTesting
    public static class DelayedAction {
        private final AtomicBoolean mCompleted = new AtomicBoolean();
        private final Object mToken = new Object();
        private final Handler mHandler;
        private final Runnable mAction;

        @VisibleForTesting
        public DelayedAction(Handler handler, long timeoutMillis, Runnable action) {
            this.mHandler = handler;
            this.mAction = action;
            this.mHandler.postDelayed(this::onTimeout, this.mToken, timeoutMillis);
        }

        private boolean onTimeout() {
            if (this.mCompleted.compareAndSet(false, true)) {
                this.mAction.run();
                return true;
            }
            return false;
        }

        @VisibleForTesting
        public boolean timeoutNow() {
            return this.onTimeout();
        }

        public boolean cancel() {
            if (!this.mCompleted.compareAndSet(false, true)) {
                return false;
            }
            this.mHandler.removeCallbacksAndMessages(this.mToken);
            return true;
        }
    }
}

