/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IStatsCompanionService
extends IInterface {
    public void statsdReady() throws RemoteException;

    public void setAnomalyAlarm(long var1) throws RemoteException;

    public void cancelAnomalyAlarm() throws RemoteException;

    public void setPullingAlarm(long var1) throws RemoteException;

    public void cancelPullingAlarm() throws RemoteException;

    public void setAlarmForSubscriberTriggering(long var1) throws RemoteException;

    public void cancelAlarmForSubscriberTriggering() throws RemoteException;

    public boolean checkPermission(String var1, int var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IStatsCompanionService {
        private static final String DESCRIPTOR = "android.os.IStatsCompanionService";
        static final int TRANSACTION_statsdReady = 1;
        static final int TRANSACTION_setAnomalyAlarm = 2;
        static final int TRANSACTION_cancelAnomalyAlarm = 3;
        static final int TRANSACTION_setPullingAlarm = 4;
        static final int TRANSACTION_cancelPullingAlarm = 5;
        static final int TRANSACTION_setAlarmForSubscriberTriggering = 6;
        static final int TRANSACTION_cancelAlarmForSubscriberTriggering = 7;
        static final int TRANSACTION_checkPermission = 8;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IStatsCompanionService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IStatsCompanionService) {
                return (IStatsCompanionService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "statsdReady";
                }
                case 2: {
                    return "setAnomalyAlarm";
                }
                case 3: {
                    return "cancelAnomalyAlarm";
                }
                case 4: {
                    return "setPullingAlarm";
                }
                case 5: {
                    return "cancelPullingAlarm";
                }
                case 6: {
                    return "setAlarmForSubscriberTriggering";
                }
                case 7: {
                    return "cancelAlarmForSubscriberTriggering";
                }
                case 8: {
                    return "checkPermission";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    this.statsdReady();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    this.setAnomalyAlarm(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    this.cancelAnomalyAlarm();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    this.setPullingAlarm(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    this.cancelPullingAlarm();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    this.setAlarmForSubscriberTriggering(_arg0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    this.cancelAlarmForSubscriberTriggering();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    boolean _result = this.checkPermission(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IStatsCompanionService impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IStatsCompanionService getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IStatsCompanionService {
            private IBinder mRemote;
            public static IStatsCompanionService sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void statsdReady() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().statsdReady();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAnomalyAlarm(long timestampMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(timestampMs);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setAnomalyAlarm(timestampMs);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void cancelAnomalyAlarm() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().cancelAnomalyAlarm();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPullingAlarm(long nextPullTimeMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(nextPullTimeMs);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setPullingAlarm(nextPullTimeMs);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void cancelPullingAlarm() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().cancelPullingAlarm();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAlarmForSubscriberTriggering(long timestampMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(timestampMs);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setAlarmForSubscriberTriggering(timestampMs);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void cancelAlarmForSubscriberTriggering() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().cancelAlarmForSubscriberTriggering();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean checkPermission(String permission2, int pid, int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(permission2);
                    _data.writeInt(pid);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().checkPermission(permission2, pid, uid);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IStatsCompanionService {
        @Override
        public void statsdReady() throws RemoteException {
        }

        @Override
        public void setAnomalyAlarm(long timestampMs) throws RemoteException {
        }

        @Override
        public void cancelAnomalyAlarm() throws RemoteException {
        }

        @Override
        public void setPullingAlarm(long nextPullTimeMs) throws RemoteException {
        }

        @Override
        public void cancelPullingAlarm() throws RemoteException {
        }

        @Override
        public void setAlarmForSubscriberTriggering(long timestampMs) throws RemoteException {
        }

        @Override
        public void cancelAlarmForSubscriberTriggering() throws RemoteException {
        }

        @Override
        public boolean checkPermission(String permission2, int pid, int uid) throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

