/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.wifi.IWifiScanner;
import android.net.wifi.ScanResult;
import android.net.wifi.SynchronousExecutor;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.WorkSource;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.util.AsyncChannel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
public class WifiScanner {
    public static final int WIFI_BAND_INDEX_24_GHZ = 0;
    public static final int WIFI_BAND_INDEX_5_GHZ = 1;
    public static final int WIFI_BAND_INDEX_5_GHZ_DFS_ONLY = 2;
    public static final int WIFI_BAND_INDEX_6_GHZ = 3;
    public static final int WIFI_BAND_COUNT = 4;
    public static final int WIFI_BAND_UNSPECIFIED = 0;
    public static final int WIFI_BAND_24_GHZ = 1;
    public static final int WIFI_BAND_5_GHZ = 2;
    public static final int WIFI_BAND_5_GHZ_DFS_ONLY = 4;
    public static final int WIFI_BAND_6_GHZ = 8;
    public static final int WIFI_BAND_BOTH = 3;
    public static final int WIFI_BAND_24_GHZ_WITH_5GHZ_DFS = 5;
    public static final int WIFI_BAND_5_GHZ_WITH_DFS = 6;
    public static final int WIFI_BAND_BOTH_WITH_DFS = 7;
    public static final int WIFI_BAND_24_5_6_GHZ = 11;
    public static final int WIFI_BAND_24_5_WITH_DFS_6_GHZ = 15;
    public static final int WIFI_BAND_ALL = 15;
    public static final int MIN_SCAN_PERIOD_MS = 1000;
    public static final int MAX_SCAN_PERIOD_MS = 1024000;
    public static final int REASON_SUCCEEDED = 0;
    public static final int REASON_UNSPECIFIED = -1;
    public static final int REASON_INVALID_LISTENER = -2;
    public static final int REASON_INVALID_REQUEST = -3;
    public static final int REASON_NOT_AUTHORIZED = -4;
    public static final int REASON_DUPLICATE_REQEUST = -5;
    public static final String GET_AVAILABLE_CHANNELS_EXTRA = "Channels";
    @Deprecated
    public static final int REPORT_EVENT_AFTER_BUFFER_FULL = 0;
    public static final int REPORT_EVENT_AFTER_EACH_SCAN = 1;
    public static final int REPORT_EVENT_FULL_SCAN_RESULT = 2;
    public static final int REPORT_EVENT_NO_BATCH = 4;
    public static final int SCAN_TYPE_LOW_LATENCY = 0;
    public static final int SCAN_TYPE_LOW_POWER = 1;
    public static final int SCAN_TYPE_HIGH_ACCURACY = 2;
    public static final String SCAN_PARAMS_SCAN_SETTINGS_KEY = "ScanSettings";
    public static final String SCAN_PARAMS_WORK_SOURCE_KEY = "WorkSource";
    public static final String REQUEST_PACKAGE_NAME_KEY = "PackageName";
    public static final String REQUEST_FEATURE_ID_KEY = "FeatureId";
    public static final String PNO_PARAMS_PNO_SETTINGS_KEY = "PnoSettings";
    public static final String PNO_PARAMS_SCAN_SETTINGS_KEY = "ScanSettings";
    private static final String TAG = "WifiScanner";
    private static final boolean DBG = false;
    private static final int BASE = 159744;
    public static final int CMD_START_BACKGROUND_SCAN = 159746;
    public static final int CMD_STOP_BACKGROUND_SCAN = 159747;
    public static final int CMD_GET_SCAN_RESULTS = 159748;
    public static final int CMD_SCAN_RESULT = 159749;
    public static final int CMD_OP_SUCCEEDED = 159761;
    public static final int CMD_OP_FAILED = 159762;
    public static final int CMD_FULL_SCAN_RESULT = 159764;
    public static final int CMD_START_SINGLE_SCAN = 159765;
    public static final int CMD_STOP_SINGLE_SCAN = 159766;
    public static final int CMD_SINGLE_SCAN_COMPLETED = 159767;
    public static final int CMD_START_PNO_SCAN = 159768;
    public static final int CMD_STOP_PNO_SCAN = 159769;
    public static final int CMD_PNO_NETWORK_FOUND = 159770;
    public static final int CMD_REGISTER_SCAN_LISTENER = 159771;
    public static final int CMD_DEREGISTER_SCAN_LISTENER = 159772;
    public static final int CMD_GET_SINGLE_SCAN_RESULTS = 159773;
    public static final int CMD_ENABLE = 159774;
    public static final int CMD_DISABLE = 159775;
    private Context mContext;
    private IWifiScanner mService;
    private static final int INVALID_KEY = 0;
    private int mListenerKey = 1;
    private final SparseArray mListenerMap = new SparseArray();
    private final SparseArray<Executor> mExecutorMap = new SparseArray();
    private final Object mListenerMapLock = new Object();
    private AsyncChannel mAsyncChannel;
    private final Handler mInternalHandler;

    public static boolean isFullBandScan(int bandScanned, boolean excludeDfs) {
        return (bandScanned | 8 | (excludeDfs ? 4 : 0)) == 15;
    }

    @SystemApi
    public List<Integer> getAvailableChannels(int band) {
        try {
            Bundle bundle = this.mService.getAvailableChannels(band, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            ArrayList channels = bundle.getIntegerArrayList(GET_AVAILABLE_CHANNELS_EXTRA);
            return channels == null ? new ArrayList() : channels;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void setScanningEnabled(boolean enable) {
        this.validateChannel();
        this.mAsyncChannel.sendMessage(enable ? 159774 : 159775);
    }

    public void registerScanListener(Executor executor, ScanListener listener) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(listener, "listener cannot be null");
        int key = this.addListener(listener, executor);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        this.mAsyncChannel.sendMessage(159771, 0, key);
    }

    public void registerScanListener(ScanListener listener) {
        this.registerScanListener(new SynchronousExecutor(), listener);
    }

    public void unregisterScanListener(ScanListener listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        int key = this.removeListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        this.mAsyncChannel.sendMessage(159772, 0, key);
    }

    public void startBackgroundScan(ScanSettings settings, ScanListener listener) {
        this.startBackgroundScan(settings, listener, null);
    }

    @Deprecated
    public void startBackgroundScan(ScanSettings settings, ScanListener listener, WorkSource workSource) {
        Objects.requireNonNull(listener, "listener cannot be null");
        int key = this.addListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        Bundle scanParams = new Bundle();
        scanParams.putParcelable("ScanSettings", settings);
        scanParams.putParcelable(SCAN_PARAMS_WORK_SOURCE_KEY, workSource);
        scanParams.putString(REQUEST_PACKAGE_NAME_KEY, this.mContext.getOpPackageName());
        scanParams.putString(REQUEST_FEATURE_ID_KEY, this.mContext.getAttributionTag());
        this.mAsyncChannel.sendMessage(159746, 0, key, scanParams);
    }

    @Deprecated
    public void stopBackgroundScan(ScanListener listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        int key = this.removeListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        Bundle scanParams = new Bundle();
        scanParams.putString(REQUEST_PACKAGE_NAME_KEY, this.mContext.getOpPackageName());
        scanParams.putString(REQUEST_FEATURE_ID_KEY, this.mContext.getAttributionTag());
        this.mAsyncChannel.sendMessage(159747, 0, key, scanParams);
    }

    @Deprecated
    public boolean getScanResults() {
        this.validateChannel();
        Bundle scanParams = new Bundle();
        scanParams.putString(REQUEST_PACKAGE_NAME_KEY, this.mContext.getOpPackageName());
        scanParams.putString(REQUEST_FEATURE_ID_KEY, this.mContext.getAttributionTag());
        Message reply = this.mAsyncChannel.sendMessageSynchronously(159748, 0, 0, scanParams);
        return reply.what == 159761;
    }

    public void startScan(ScanSettings settings, ScanListener listener) {
        this.startScan(settings, listener, null);
    }

    public void startScan(ScanSettings settings, ScanListener listener, WorkSource workSource) {
        this.startScan(settings, null, listener, workSource);
    }

    public void startScan(ScanSettings settings, Executor executor, ScanListener listener, WorkSource workSource) {
        Objects.requireNonNull(listener, "listener cannot be null");
        int key = this.addListener(listener, executor);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        Bundle scanParams = new Bundle();
        scanParams.putParcelable("ScanSettings", settings);
        scanParams.putParcelable(SCAN_PARAMS_WORK_SOURCE_KEY, workSource);
        scanParams.putString(REQUEST_PACKAGE_NAME_KEY, this.mContext.getOpPackageName());
        scanParams.putString(REQUEST_FEATURE_ID_KEY, this.mContext.getAttributionTag());
        this.mAsyncChannel.sendMessage(159765, 0, key, scanParams);
    }

    public void stopScan(ScanListener listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        int key = this.removeListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        Bundle scanParams = new Bundle();
        scanParams.putString(REQUEST_PACKAGE_NAME_KEY, this.mContext.getOpPackageName());
        scanParams.putString(REQUEST_FEATURE_ID_KEY, this.mContext.getAttributionTag());
        this.mAsyncChannel.sendMessage(159766, 0, key, scanParams);
    }

    public List<ScanResult> getSingleScanResults() {
        this.validateChannel();
        Bundle scanParams = new Bundle();
        scanParams.putString(REQUEST_PACKAGE_NAME_KEY, this.mContext.getOpPackageName());
        scanParams.putString(REQUEST_FEATURE_ID_KEY, this.mContext.getAttributionTag());
        Message reply = this.mAsyncChannel.sendMessageSynchronously(159773, 0, 0, scanParams);
        if (reply.what == 159761) {
            return Arrays.asList(((ParcelableScanResults)reply.obj).getResults());
        }
        OperationResult result = (OperationResult)reply.obj;
        Log.e(TAG, "Error retrieving SingleScan results reason: " + result.reason + " description: " + result.description);
        return new ArrayList<ScanResult>();
    }

    private void startPnoScan(ScanSettings scanSettings, PnoSettings pnoSettings, int key) {
        Bundle pnoParams = new Bundle();
        scanSettings.isPnoScan = true;
        pnoParams.putParcelable("ScanSettings", scanSettings);
        pnoParams.putParcelable(PNO_PARAMS_PNO_SETTINGS_KEY, pnoSettings);
        this.mAsyncChannel.sendMessage(159768, 0, key, pnoParams);
    }

    public void startConnectedPnoScan(ScanSettings scanSettings, PnoSettings pnoSettings, Executor executor, PnoScanListener listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        Objects.requireNonNull(pnoSettings, "pnoSettings cannot be null");
        int key = this.addListener(listener, executor);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        pnoSettings.isConnected = true;
        this.startPnoScan(scanSettings, pnoSettings, key);
    }

    public void startDisconnectedPnoScan(ScanSettings scanSettings, PnoSettings pnoSettings, Executor executor, PnoScanListener listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        Objects.requireNonNull(pnoSettings, "pnoSettings cannot be null");
        int key = this.addListener(listener, executor);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        pnoSettings.isConnected = false;
        this.startPnoScan(scanSettings, pnoSettings, key);
    }

    public void stopPnoScan(ScanListener listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        int key = this.removeListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        this.mAsyncChannel.sendMessage(159769, 0, key);
    }

    @Deprecated
    @SuppressLint(value={"Doclava125"})
    public void configureWifiChange(int rssiSampleSize, int lostApSampleSize, int unchangedSampleSize, int minApsBreachingThreshold, int periodInMs, BssidInfo[] bssidInfos) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @SuppressLint(value={"Doclava125"})
    public void startTrackingWifiChange(WifiChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @SuppressLint(value={"Doclava125"})
    public void stopTrackingWifiChange(WifiChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    @SystemApi
    @Deprecated
    @SuppressLint(value={"Doclava125"})
    public void configureWifiChange(WifiChangeSettings settings) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @SuppressLint(value={"Doclava125"})
    public void startTrackingBssids(BssidInfo[] bssidInfos, int apLostThreshold, BssidListener listener) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @SuppressLint(value={"Doclava125"})
    public void stopTrackingBssids(BssidListener listener) {
        throw new UnsupportedOperationException();
    }

    public WifiScanner(Context context, IWifiScanner service, Looper looper) {
        this.mContext = context;
        this.mService = service;
        Messenger messenger = null;
        try {
            messenger = this.mService.getMessenger();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (messenger == null) {
            throw new IllegalStateException("getMessenger() returned null!  This is invalid.");
        }
        this.mAsyncChannel = new AsyncChannel();
        this.mInternalHandler = new ServiceHandler(looper);
        this.mAsyncChannel.connectSync(this.mContext, this.mInternalHandler, messenger);
        this.mAsyncChannel.sendMessage(69633);
    }

    private void validateChannel() {
        if (this.mAsyncChannel == null) {
            throw new IllegalStateException("No permission to access and change wifi or a bad initialization");
        }
    }

    private int addListener(ActionListener listener) {
        return this.addListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addListener(ActionListener listener, Executor executor) {
        Object object = this.mListenerMapLock;
        synchronized (object) {
            boolean keyExists = this.getListenerKey(listener) != 0;
            int key = this.putListener(listener);
            if (keyExists) {
                OperationResult operationResult = new OperationResult(-5, "Outstanding request with same key not stopped yet");
                Message message = Message.obtain(this.mInternalHandler, 159762, 0, key, operationResult);
                message.sendToTarget();
                return 0;
            }
            this.mExecutorMap.put(key, executor);
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int putListener(Object listener) {
        int key;
        if (listener == null) {
            return 0;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            do {
                ++this.mListenerKey;
            } while (key == 0);
            this.mListenerMap.put(key, listener);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenerWithExecutor getListenerWithExecutor(int key) {
        if (key == 0) {
            return new ListenerWithExecutor(null, null);
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            Object listener = this.mListenerMap.get(key);
            Executor executor = this.mExecutorMap.get(key);
            return new ListenerWithExecutor(listener, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getListenerKey(Object listener) {
        if (listener == null) {
            return 0;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            int index = this.mListenerMap.indexOfValue(listener);
            if (index == -1) {
                return 0;
            }
            return this.mListenerMap.keyAt(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object removeListener(int key) {
        if (key == 0) {
            return null;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            Object listener = this.mListenerMap.get(key);
            this.mListenerMap.remove(key);
            this.mExecutorMap.remove(key);
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeListener(Object listener) {
        int key = this.getListenerKey(listener);
        if (key == 0) {
            Log.e(TAG, "listener cannot be found");
            return key;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            this.mListenerMap.remove(key);
            this.mExecutorMap.remove(key);
            return key;
        }
    }

    private class ServiceHandler
    extends Handler {
        ServiceHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 69634: {
                    return;
                }
                case 69636: {
                    Log.e(WifiScanner.TAG, "Channel connection lost");
                    WifiScanner.this.mAsyncChannel = null;
                    this.getLooper().quit();
                    return;
                }
            }
            ListenerWithExecutor listenerWithExecutor = WifiScanner.this.getListenerWithExecutor(msg.arg2);
            Object listener = listenerWithExecutor.mListener;
            if (listener == null) {
                return;
            }
            Executor executor = listenerWithExecutor.mExecutor;
            if (executor == null) {
                executor = new SynchronousExecutor();
            }
            switch (msg.what) {
                case 159761: {
                    ActionListener actionListener = (ActionListener)listener;
                    Binder.clearCallingIdentity();
                    executor.execute(actionListener::onSuccess);
                    break;
                }
                case 159762: {
                    OperationResult result = (OperationResult)msg.obj;
                    ActionListener actionListener = (ActionListener)listener;
                    WifiScanner.this.removeListener(msg.arg2);
                    Binder.clearCallingIdentity();
                    executor.execute(() -> actionListener.onFailure(result.reason, result.description));
                    break;
                }
                case 159749: {
                    ScanListener scanListener = (ScanListener)listener;
                    ParcelableScanData parcelableScanData = (ParcelableScanData)msg.obj;
                    Binder.clearCallingIdentity();
                    executor.execute(() -> scanListener.onResults(parcelableScanData.getResults()));
                    break;
                }
                case 159764: {
                    ScanResult result = (ScanResult)msg.obj;
                    ScanListener scanListener = (ScanListener)listener;
                    Binder.clearCallingIdentity();
                    executor.execute(() -> scanListener.onFullResult(result));
                    break;
                }
                case 159767: {
                    WifiScanner.this.removeListener(msg.arg2);
                    break;
                }
                case 159770: {
                    PnoScanListener pnoScanListener = (PnoScanListener)listener;
                    ParcelableScanResults parcelableScanResults = (ParcelableScanResults)msg.obj;
                    Binder.clearCallingIdentity();
                    executor.execute(() -> pnoScanListener.onPnoNetworkFound(parcelableScanResults.getResults()));
                    break;
                }
            }
        }
    }

    public static class OperationResult
    implements Parcelable {
        public int reason;
        public String description;
        public static final Parcelable.Creator<OperationResult> CREATOR = new Parcelable.Creator<OperationResult>(){

            @Override
            public OperationResult createFromParcel(Parcel in) {
                int reason = in.readInt();
                String description = in.readString();
                return new OperationResult(reason, description);
            }

            public OperationResult[] newArray(int size) {
                return new OperationResult[size];
            }
        };

        public OperationResult(int reason, String description) {
            this.reason = reason;
            this.description = description;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.reason);
            dest.writeString(this.description);
        }
    }

    private static class ListenerWithExecutor {
        final Object mListener;
        final Executor mExecutor;

        ListenerWithExecutor(Object listener, Executor executor) {
            this.mListener = listener;
            this.mExecutor = executor;
        }
    }

    @SystemApi
    @Deprecated
    public static class HotlistSettings
    implements Parcelable {
        public BssidInfo[] bssidInfos;
        public int apLostThreshold;
        public static final Parcelable.Creator<HotlistSettings> CREATOR = new Parcelable.Creator<HotlistSettings>(){

            @Override
            public HotlistSettings createFromParcel(Parcel in) {
                HotlistSettings settings = new HotlistSettings();
                return settings;
            }

            public HotlistSettings[] newArray(int size) {
                return new HotlistSettings[size];
            }
        };

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
        }
    }

    @Deprecated
    public static interface BssidListener
    extends ActionListener {
        public void onFound(ScanResult[] var1);

        public void onLost(ScanResult[] var1);
    }

    @Deprecated
    public static interface WifiChangeListener
    extends ActionListener {
        public void onChanging(ScanResult[] var1);

        public void onQuiescence(ScanResult[] var1);
    }

    @SystemApi
    @Deprecated
    public static class WifiChangeSettings
    implements Parcelable {
        public int rssiSampleSize;
        public int lostApSampleSize;
        public int unchangedSampleSize;
        public int minApsBreachingThreshold;
        public int periodInMs;
        public BssidInfo[] bssidInfos;
        public static final Parcelable.Creator<WifiChangeSettings> CREATOR = new Parcelable.Creator<WifiChangeSettings>(){

            @Override
            public WifiChangeSettings createFromParcel(Parcel in) {
                return new WifiChangeSettings();
            }

            public WifiChangeSettings[] newArray(int size) {
                return new WifiChangeSettings[size];
            }
        };

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
        }
    }

    @Deprecated
    public static class BssidInfo {
        public String bssid;
        public int low;
        public int high;
        public int frequencyHint;
    }

    public static interface PnoScanListener
    extends ScanListener {
        public void onPnoNetworkFound(ScanResult[] var1);
    }

    public static interface ScanListener
    extends ActionListener {
        @Deprecated
        public void onPeriodChanged(int var1);

        public void onResults(ScanData[] var1);

        public void onFullResult(ScanResult var1);
    }

    public static class PnoSettings
    implements Parcelable {
        public boolean isConnected;
        public int min5GHzRssi;
        public int min24GHzRssi;
        public int min6GHzRssi;
        public PnoNetwork[] networkList;
        public static final Parcelable.Creator<PnoSettings> CREATOR = new Parcelable.Creator<PnoSettings>(){

            @Override
            public PnoSettings createFromParcel(Parcel in) {
                PnoSettings settings = new PnoSettings();
                settings.isConnected = in.readInt() == 1;
                settings.min5GHzRssi = in.readInt();
                settings.min24GHzRssi = in.readInt();
                settings.min6GHzRssi = in.readInt();
                int numNetworks = in.readInt();
                settings.networkList = new PnoNetwork[numNetworks];
                for (int i = 0; i < numNetworks; ++i) {
                    String ssid = in.readString();
                    PnoNetwork network = new PnoNetwork(ssid);
                    network.flags = in.readByte();
                    network.authBitField = in.readByte();
                    network.frequencies = in.createIntArray();
                    settings.networkList[i] = network;
                }
                return settings;
            }

            public PnoSettings[] newArray(int size) {
                return new PnoSettings[size];
            }
        };

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.isConnected ? 1 : 0);
            dest.writeInt(this.min5GHzRssi);
            dest.writeInt(this.min24GHzRssi);
            dest.writeInt(this.min6GHzRssi);
            if (this.networkList != null) {
                dest.writeInt(this.networkList.length);
                for (int i = 0; i < this.networkList.length; ++i) {
                    dest.writeString(this.networkList[i].ssid);
                    dest.writeByte(this.networkList[i].flags);
                    dest.writeByte(this.networkList[i].authBitField);
                    dest.writeIntArray(this.networkList[i].frequencies);
                }
            } else {
                dest.writeInt(0);
            }
        }

        public static class PnoNetwork {
            public static final byte FLAG_DIRECTED_SCAN = 1;
            public static final byte FLAG_A_BAND = 2;
            public static final byte FLAG_G_BAND = 4;
            public static final byte FLAG_STRICT_MATCH = 8;
            public static final byte FLAG_SAME_NETWORK = 16;
            public static final byte AUTH_CODE_OPEN = 1;
            public static final byte AUTH_CODE_PSK = 2;
            public static final byte AUTH_CODE_EAPOL = 4;
            public String ssid;
            public byte flags = 0;
            public byte authBitField = 0;
            public int[] frequencies = new int[0];

            public PnoNetwork(String ssid) {
                this.ssid = ssid;
            }

            public int hashCode() {
                return Objects.hash(this.ssid, this.flags, this.authBitField);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof PnoNetwork)) {
                    return false;
                }
                PnoNetwork lhs = (PnoNetwork)obj;
                return TextUtils.equals(this.ssid, lhs.ssid) && this.flags == lhs.flags && this.authBitField == lhs.authBitField;
            }
        }
    }

    public static class ParcelableScanResults
    implements Parcelable {
        public ScanResult[] mResults;
        public static final Parcelable.Creator<ParcelableScanResults> CREATOR = new Parcelable.Creator<ParcelableScanResults>(){

            @Override
            public ParcelableScanResults createFromParcel(Parcel in) {
                int n = in.readInt();
                ScanResult[] results = new ScanResult[n];
                for (int i = 0; i < n; ++i) {
                    results[i] = ScanResult.CREATOR.createFromParcel(in);
                }
                return new ParcelableScanResults(results);
            }

            public ParcelableScanResults[] newArray(int size) {
                return new ParcelableScanResults[size];
            }
        };

        public ParcelableScanResults(ScanResult[] results) {
            this.mResults = results;
        }

        public ScanResult[] getResults() {
            return this.mResults;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            if (this.mResults != null) {
                dest.writeInt(this.mResults.length);
                for (int i = 0; i < this.mResults.length; ++i) {
                    ScanResult result = this.mResults[i];
                    result.writeToParcel(dest, flags);
                }
            } else {
                dest.writeInt(0);
            }
        }
    }

    public static class ParcelableScanData
    implements Parcelable {
        public ScanData[] mResults;
        public static final Parcelable.Creator<ParcelableScanData> CREATOR = new Parcelable.Creator<ParcelableScanData>(){

            @Override
            public ParcelableScanData createFromParcel(Parcel in) {
                int n = in.readInt();
                ScanData[] results = new ScanData[n];
                for (int i = 0; i < n; ++i) {
                    results[i] = ScanData.CREATOR.createFromParcel(in);
                }
                return new ParcelableScanData(results);
            }

            public ParcelableScanData[] newArray(int size) {
                return new ParcelableScanData[size];
            }
        };

        public ParcelableScanData(ScanData[] results) {
            this.mResults = results;
        }

        public ScanData[] getResults() {
            return this.mResults;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            if (this.mResults != null) {
                dest.writeInt(this.mResults.length);
                for (int i = 0; i < this.mResults.length; ++i) {
                    ScanData result = this.mResults[i];
                    result.writeToParcel(dest, flags);
                }
            } else {
                dest.writeInt(0);
            }
        }
    }

    public static class ScanData
    implements Parcelable {
        private int mId;
        private int mFlags;
        private int mBucketsScanned;
        private int mBandScanned;
        private final List<ScanResult> mResults;
        public static final Parcelable.Creator<ScanData> CREATOR = new Parcelable.Creator<ScanData>(){

            @Override
            public ScanData createFromParcel(Parcel in) {
                int id2 = in.readInt();
                int flags = in.readInt();
                int bucketsScanned = in.readInt();
                int bandScanned = in.readInt();
                ArrayList<ScanResult> results = new ArrayList<ScanResult>();
                in.readParcelableList(results, ScanResult.class.getClassLoader());
                return new ScanData(id2, flags, bucketsScanned, bandScanned, results);
            }

            public ScanData[] newArray(int size) {
                return new ScanData[size];
            }
        };

        ScanData() {
            this.mResults = new ArrayList<ScanResult>();
        }

        public ScanData(int id2, int flags, ScanResult[] results) {
            this.mId = id2;
            this.mFlags = flags;
            this.mResults = new ArrayList<ScanResult>(Arrays.asList(results));
        }

        public ScanData(int id2, int flags, int bucketsScanned, int bandScanned, ScanResult[] results) {
            this(id2, flags, bucketsScanned, bandScanned, new ArrayList<ScanResult>(Arrays.asList(results)));
        }

        public ScanData(int id2, int flags, int bucketsScanned, int bandScanned, List<ScanResult> results) {
            this.mId = id2;
            this.mFlags = flags;
            this.mBucketsScanned = bucketsScanned;
            this.mBandScanned = bandScanned;
            this.mResults = results;
        }

        public ScanData(ScanData s) {
            this.mId = s.mId;
            this.mFlags = s.mFlags;
            this.mBucketsScanned = s.mBucketsScanned;
            this.mBandScanned = s.mBandScanned;
            this.mResults = new ArrayList<ScanResult>();
            for (ScanResult scanResult : s.mResults) {
                this.mResults.add(new ScanResult(scanResult));
            }
        }

        public int getId() {
            return this.mId;
        }

        public int getFlags() {
            return this.mFlags;
        }

        public int getBucketsScanned() {
            return this.mBucketsScanned;
        }

        public int getBandScanned() {
            return this.mBandScanned;
        }

        public ScanResult[] getResults() {
            return this.mResults.toArray(new ScanResult[0]);
        }

        public void addResults(ScanResult[] newResults) {
            for (ScanResult result : newResults) {
                this.mResults.add(new ScanResult(result));
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mId);
            dest.writeInt(this.mFlags);
            dest.writeInt(this.mBucketsScanned);
            dest.writeInt(this.mBandScanned);
            dest.writeParcelableList(this.mResults, 0);
        }
    }

    public static class ScanSettings
    implements Parcelable {
        public int band;
        public ChannelSpec[] channels;
        public final List<HiddenNetwork> hiddenNetworks = new ArrayList<HiddenNetwork>();
        @Deprecated
        public int periodInMs;
        @Deprecated
        public int reportEvents;
        @Deprecated
        public int numBssidsPerScan;
        @Deprecated
        public int maxScansToCache;
        @Deprecated
        public int maxPeriodInMs;
        @Deprecated
        public int stepCount;
        public boolean isPnoScan;
        public int type = 0;
        @SystemApi
        public boolean ignoreLocationSettings;
        @SystemApi
        public boolean hideFromAppOps;
        public static final Parcelable.Creator<ScanSettings> CREATOR = new Parcelable.Creator<ScanSettings>(){

            @Override
            public ScanSettings createFromParcel(Parcel in) {
                ScanSettings settings = new ScanSettings();
                settings.band = in.readInt();
                settings.periodInMs = in.readInt();
                settings.reportEvents = in.readInt();
                settings.numBssidsPerScan = in.readInt();
                settings.maxScansToCache = in.readInt();
                settings.maxPeriodInMs = in.readInt();
                settings.stepCount = in.readInt();
                settings.isPnoScan = in.readInt() == 1;
                settings.type = in.readInt();
                settings.ignoreLocationSettings = in.readInt() == 1;
                settings.hideFromAppOps = in.readInt() == 1;
                int num_channels = in.readInt();
                settings.channels = new ChannelSpec[num_channels];
                for (int i = 0; i < num_channels; ++i) {
                    int frequency = in.readInt();
                    ChannelSpec spec = new ChannelSpec(frequency);
                    spec.dwellTimeMS = in.readInt();
                    spec.passive = in.readInt() == 1;
                    settings.channels[i] = spec;
                }
                int numNetworks = in.readInt();
                settings.hiddenNetworks.clear();
                for (int i = 0; i < numNetworks; ++i) {
                    String ssid = in.readString();
                    settings.hiddenNetworks.add(new HiddenNetwork(ssid));
                }
                return settings;
            }

            public ScanSettings[] newArray(int size) {
                return new ScanSettings[size];
            }
        };

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.band);
            dest.writeInt(this.periodInMs);
            dest.writeInt(this.reportEvents);
            dest.writeInt(this.numBssidsPerScan);
            dest.writeInt(this.maxScansToCache);
            dest.writeInt(this.maxPeriodInMs);
            dest.writeInt(this.stepCount);
            dest.writeInt(this.isPnoScan ? 1 : 0);
            dest.writeInt(this.type);
            dest.writeInt(this.ignoreLocationSettings ? 1 : 0);
            dest.writeInt(this.hideFromAppOps ? 1 : 0);
            if (this.channels != null) {
                dest.writeInt(this.channels.length);
                for (int i = 0; i < this.channels.length; ++i) {
                    dest.writeInt(this.channels[i].frequency);
                    dest.writeInt(this.channels[i].dwellTimeMS);
                    dest.writeInt(this.channels[i].passive ? 1 : 0);
                }
            } else {
                dest.writeInt(0);
            }
            dest.writeInt(this.hiddenNetworks.size());
            for (HiddenNetwork hiddenNetwork : this.hiddenNetworks) {
                dest.writeString(hiddenNetwork.ssid);
            }
        }

        public static class HiddenNetwork {
            public final String ssid;

            public HiddenNetwork(String ssid) {
                this.ssid = ssid;
            }
        }
    }

    public static class ChannelSpec {
        public int frequency;
        public boolean passive;
        public int dwellTimeMS;

        public ChannelSpec(int frequency) {
            this.frequency = frequency;
            this.passive = false;
            this.dwellTimeMS = 0;
        }
    }

    @SystemApi
    public static interface ActionListener {
        public void onSuccess();

        public void onFailure(int var1, String var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiBand {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiBandIndex {
    }
}

