/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SystemApi;
import android.net.MacAddress;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiEnterpriseConfig;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.net.wifi.hotspot2.PasspointConfiguration;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.internal.util.Preconditions;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class WifiNetworkSuggestion
implements Parcelable {
    public final WifiConfiguration wifiConfiguration;
    public final PasspointConfiguration passpointConfiguration;
    public final boolean isAppInteractionRequired;
    public final boolean isUserInteractionRequired;
    public final boolean isUserAllowedToManuallyConnect;
    public final boolean isInitialAutoJoinEnabled;
    public static final Parcelable.Creator<WifiNetworkSuggestion> CREATOR = new Parcelable.Creator<WifiNetworkSuggestion>(){

        @Override
        public WifiNetworkSuggestion createFromParcel(Parcel in) {
            return new WifiNetworkSuggestion((WifiConfiguration)in.readParcelable(null), (PasspointConfiguration)in.readParcelable(null), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readBoolean());
        }

        public WifiNetworkSuggestion[] newArray(int size) {
            return new WifiNetworkSuggestion[size];
        }
    };

    public WifiNetworkSuggestion() {
        this.wifiConfiguration = new WifiConfiguration();
        this.passpointConfiguration = null;
        this.isAppInteractionRequired = false;
        this.isUserInteractionRequired = false;
        this.isUserAllowedToManuallyConnect = true;
        this.isInitialAutoJoinEnabled = true;
    }

    public WifiNetworkSuggestion(WifiConfiguration networkConfiguration, PasspointConfiguration passpointConfiguration, boolean isAppInteractionRequired, boolean isUserInteractionRequired, boolean isUserAllowedToManuallyConnect, boolean isInitialAutoJoinEnabled) {
        Preconditions.checkNotNull(networkConfiguration);
        this.wifiConfiguration = networkConfiguration;
        this.passpointConfiguration = passpointConfiguration;
        this.isAppInteractionRequired = isAppInteractionRequired;
        this.isUserInteractionRequired = isUserInteractionRequired;
        this.isUserAllowedToManuallyConnect = isUserAllowedToManuallyConnect;
        this.isInitialAutoJoinEnabled = isInitialAutoJoinEnabled;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.wifiConfiguration, flags);
        dest.writeParcelable(this.passpointConfiguration, flags);
        dest.writeBoolean(this.isAppInteractionRequired);
        dest.writeBoolean(this.isUserInteractionRequired);
        dest.writeBoolean(this.isUserAllowedToManuallyConnect);
        dest.writeBoolean(this.isInitialAutoJoinEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.wifiConfiguration.SSID, this.wifiConfiguration.BSSID, this.wifiConfiguration.allowedKeyManagement, this.wifiConfiguration.getKey());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WifiNetworkSuggestion)) {
            return false;
        }
        WifiNetworkSuggestion lhs = (WifiNetworkSuggestion)obj;
        if (this.passpointConfiguration == null ^ lhs.passpointConfiguration == null) {
            return false;
        }
        return TextUtils.equals(this.wifiConfiguration.SSID, lhs.wifiConfiguration.SSID) && TextUtils.equals(this.wifiConfiguration.BSSID, lhs.wifiConfiguration.BSSID) && Objects.equals(this.wifiConfiguration.allowedKeyManagement, lhs.wifiConfiguration.allowedKeyManagement) && TextUtils.equals(this.wifiConfiguration.getKey(), lhs.wifiConfiguration.getKey());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WifiNetworkSuggestion[ ").append("SSID=").append(this.wifiConfiguration.SSID).append(", BSSID=").append(this.wifiConfiguration.BSSID).append(", FQDN=").append(this.wifiConfiguration.FQDN).append(", isAppInteractionRequired=").append(this.isAppInteractionRequired).append(", isUserInteractionRequired=").append(this.isUserInteractionRequired).append(", isCredentialSharedWithUser=").append(this.isUserAllowedToManuallyConnect).append(", isInitialAutoJoinEnabled=").append(this.isInitialAutoJoinEnabled).append(", isUnTrusted=").append(!this.wifiConfiguration.trusted).append(" ]");
        return sb.toString();
    }

    @SystemApi
    public WifiConfiguration getWifiConfiguration() {
        return this.wifiConfiguration;
    }

    public MacAddress getBssid() {
        if (this.wifiConfiguration.BSSID == null) {
            return null;
        }
        return MacAddress.fromString(this.wifiConfiguration.BSSID);
    }

    public boolean isCredentialSharedWithUser() {
        return this.isUserAllowedToManuallyConnect;
    }

    public boolean isAppInteractionRequired() {
        return this.isAppInteractionRequired;
    }

    public boolean isEnhancedOpen() {
        return this.wifiConfiguration.allowedKeyManagement.get(9);
    }

    public boolean isHiddenSsid() {
        return this.wifiConfiguration.hiddenSSID;
    }

    public boolean isInitialAutojoinEnabled() {
        return this.isInitialAutoJoinEnabled;
    }

    public boolean isMetered() {
        return this.wifiConfiguration.meteredOverride == 1;
    }

    public boolean isUserInteractionRequired() {
        return this.isUserInteractionRequired;
    }

    public PasspointConfiguration getPasspointConfig() {
        return this.passpointConfiguration;
    }

    public int getPriority() {
        return this.wifiConfiguration.priority;
    }

    public String getSsid() {
        if (this.wifiConfiguration.SSID == null) {
            return null;
        }
        return WifiInfo.sanitizeSsid(this.wifiConfiguration.SSID);
    }

    public boolean isUntrusted() {
        return !this.wifiConfiguration.trusted;
    }

    public WifiEnterpriseConfig getEnterpriseConfig() {
        return this.wifiConfiguration.enterpriseConfig;
    }

    public String getPassphrase() {
        if (this.wifiConfiguration.preSharedKey == null) {
            return null;
        }
        return WifiInfo.removeDoubleQuotes(this.wifiConfiguration.preSharedKey);
    }

    public static class Builder {
        private static final int UNASSIGNED_PRIORITY = -1;
        private String mSsid = null;
        private MacAddress mBssid = null;
        private boolean mIsEnhancedOpen = false;
        private String mWpa2PskPassphrase = null;
        private String mWpa3SaePassphrase = null;
        private WifiEnterpriseConfig mWpa2EnterpriseConfig = null;
        private WifiEnterpriseConfig mWpa3EnterpriseConfig = null;
        private PasspointConfiguration mPasspointConfiguration = null;
        private boolean mIsHiddenSSID = false;
        private boolean mIsAppInteractionRequired = false;
        private boolean mIsUserInteractionRequired = false;
        private int mMeteredOverride = 0;
        private int mPriority = -1;
        private int mCarrierId = -1;
        private boolean mIsSharedWithUser = true;
        private boolean mIsSharedWithUserSet = false;
        private boolean mIsInitialAutojoinEnabled = true;
        private String mWapiPskPassphrase = null;
        private WifiEnterpriseConfig mWapiEnterpriseConfig = null;
        private boolean mIsNetworkUntrusted = false;

        public Builder setSsid(String ssid) {
            Preconditions.checkNotNull(ssid);
            CharsetEncoder unicodeEncoder = StandardCharsets.UTF_8.newEncoder();
            if (!unicodeEncoder.canEncode(ssid)) {
                throw new IllegalArgumentException("SSID is not a valid unicode string");
            }
            this.mSsid = new String(ssid);
            return this;
        }

        public Builder setBssid(MacAddress bssid) {
            Preconditions.checkNotNull(bssid);
            this.mBssid = MacAddress.fromBytes(bssid.toByteArray());
            return this;
        }

        public Builder setIsEnhancedOpen(boolean isEnhancedOpen) {
            this.mIsEnhancedOpen = isEnhancedOpen;
            return this;
        }

        public Builder setWpa2Passphrase(String passphrase) {
            Preconditions.checkNotNull(passphrase);
            CharsetEncoder asciiEncoder = StandardCharsets.US_ASCII.newEncoder();
            if (!asciiEncoder.canEncode(passphrase)) {
                throw new IllegalArgumentException("passphrase not ASCII encodable");
            }
            this.mWpa2PskPassphrase = passphrase;
            return this;
        }

        public Builder setWpa3Passphrase(String passphrase) {
            Preconditions.checkNotNull(passphrase);
            CharsetEncoder asciiEncoder = StandardCharsets.US_ASCII.newEncoder();
            if (!asciiEncoder.canEncode(passphrase)) {
                throw new IllegalArgumentException("passphrase not ASCII encodable");
            }
            this.mWpa3SaePassphrase = passphrase;
            return this;
        }

        public Builder setWpa2EnterpriseConfig(WifiEnterpriseConfig enterpriseConfig) {
            Preconditions.checkNotNull(enterpriseConfig);
            if (enterpriseConfig.isInsecure()) {
                throw new IllegalArgumentException("Enterprise configuration is insecure");
            }
            this.mWpa2EnterpriseConfig = new WifiEnterpriseConfig(enterpriseConfig);
            return this;
        }

        public Builder setWpa3EnterpriseConfig(WifiEnterpriseConfig enterpriseConfig) {
            Preconditions.checkNotNull(enterpriseConfig);
            if (enterpriseConfig.isInsecure()) {
                throw new IllegalArgumentException("Enterprise configuration is insecure");
            }
            this.mWpa3EnterpriseConfig = new WifiEnterpriseConfig(enterpriseConfig);
            return this;
        }

        public Builder setPasspointConfig(PasspointConfiguration passpointConfig) {
            Preconditions.checkNotNull(passpointConfig);
            if (!passpointConfig.validate()) {
                throw new IllegalArgumentException("Passpoint configuration is invalid");
            }
            this.mPasspointConfiguration = passpointConfig;
            return this;
        }

        @SystemApi
        public Builder setCarrierId(int carrierId) {
            this.mCarrierId = carrierId;
            return this;
        }

        public Builder setWapiPassphrase(String passphrase) {
            Preconditions.checkNotNull(passphrase);
            CharsetEncoder asciiEncoder = StandardCharsets.US_ASCII.newEncoder();
            if (!asciiEncoder.canEncode(passphrase)) {
                throw new IllegalArgumentException("passphrase not ASCII encodable");
            }
            this.mWapiPskPassphrase = passphrase;
            return this;
        }

        public Builder setWapiEnterpriseConfig(WifiEnterpriseConfig enterpriseConfig) {
            Preconditions.checkNotNull(enterpriseConfig);
            this.mWapiEnterpriseConfig = new WifiEnterpriseConfig(enterpriseConfig);
            return this;
        }

        public Builder setIsHiddenSsid(boolean isHiddenSsid) {
            this.mIsHiddenSSID = isHiddenSsid;
            return this;
        }

        public Builder setIsAppInteractionRequired(boolean isAppInteractionRequired) {
            this.mIsAppInteractionRequired = isAppInteractionRequired;
            return this;
        }

        public Builder setIsUserInteractionRequired(boolean isUserInteractionRequired) {
            this.mIsUserInteractionRequired = isUserInteractionRequired;
            return this;
        }

        public Builder setPriority(int priority) {
            if (priority < 0) {
                throw new IllegalArgumentException("Invalid priority value " + priority);
            }
            this.mPriority = priority;
            return this;
        }

        public Builder setIsMetered(boolean isMetered) {
            this.mMeteredOverride = isMetered ? 1 : 2;
            return this;
        }

        public Builder setCredentialSharedWithUser(boolean isShared) {
            this.mIsSharedWithUser = isShared;
            this.mIsSharedWithUserSet = true;
            return this;
        }

        public Builder setIsInitialAutojoinEnabled(boolean enabled) {
            this.mIsInitialAutojoinEnabled = enabled;
            return this;
        }

        public Builder setUntrusted(boolean isUntrusted) {
            this.mIsNetworkUntrusted = isUntrusted;
            return this;
        }

        private void setSecurityParamsInWifiConfiguration(WifiConfiguration configuration) {
            if (!TextUtils.isEmpty(this.mWpa2PskPassphrase)) {
                configuration.setSecurityParams(2);
                configuration.preSharedKey = "\"" + this.mWpa2PskPassphrase + "\"";
            } else if (!TextUtils.isEmpty(this.mWpa3SaePassphrase)) {
                configuration.setSecurityParams(4);
                configuration.preSharedKey = "\"" + this.mWpa3SaePassphrase + "\"";
            } else if (this.mWpa2EnterpriseConfig != null) {
                configuration.setSecurityParams(3);
                configuration.enterpriseConfig = this.mWpa2EnterpriseConfig;
            } else if (this.mWpa3EnterpriseConfig != null) {
                configuration.setSecurityParams(5);
                configuration.enterpriseConfig = this.mWpa3EnterpriseConfig;
            } else if (this.mIsEnhancedOpen) {
                configuration.setSecurityParams(6);
            } else if (!TextUtils.isEmpty(this.mWapiPskPassphrase)) {
                configuration.setSecurityParams(7);
                configuration.preSharedKey = "\"" + this.mWapiPskPassphrase + "\"";
            } else if (this.mWapiEnterpriseConfig != null) {
                configuration.setSecurityParams(8);
                configuration.enterpriseConfig = this.mWapiEnterpriseConfig;
            } else {
                configuration.setSecurityParams(0);
            }
        }

        private WifiConfiguration buildWifiConfiguration() {
            WifiConfiguration wifiConfiguration = new WifiConfiguration();
            wifiConfiguration.SSID = "\"" + this.mSsid + "\"";
            if (this.mBssid != null) {
                wifiConfiguration.BSSID = this.mBssid.toString();
            }
            this.setSecurityParamsInWifiConfiguration(wifiConfiguration);
            wifiConfiguration.hiddenSSID = this.mIsHiddenSSID;
            wifiConfiguration.priority = this.mPriority;
            wifiConfiguration.meteredOverride = this.mMeteredOverride;
            wifiConfiguration.carrierId = this.mCarrierId;
            wifiConfiguration.trusted = !this.mIsNetworkUntrusted;
            return wifiConfiguration;
        }

        private void validateSecurityParams() {
            int numSecurityTypes = 0;
            numSecurityTypes += this.mIsEnhancedOpen ? 1 : 0;
            numSecurityTypes += !TextUtils.isEmpty(this.mWpa2PskPassphrase) ? 1 : 0;
            numSecurityTypes += !TextUtils.isEmpty(this.mWpa3SaePassphrase) ? 1 : 0;
            numSecurityTypes += !TextUtils.isEmpty(this.mWapiPskPassphrase) ? 1 : 0;
            numSecurityTypes += this.mWpa2EnterpriseConfig != null ? 1 : 0;
            numSecurityTypes += this.mWpa3EnterpriseConfig != null ? 1 : 0;
            numSecurityTypes += this.mWapiEnterpriseConfig != null ? 1 : 0;
            if ((numSecurityTypes += this.mPasspointConfiguration != null ? 1 : 0) > 1) {
                throw new IllegalStateException("only one of setIsEnhancedOpen, setWpa2Passphrase, setWpa3Passphrase, setWpa2EnterpriseConfig, setWpa3EnterpriseConfig setWapiPassphrase, setWapiCertSuite, setIsWapiCertSuiteAuto or setPasspointConfig can be invoked for network suggestion");
            }
        }

        private WifiConfiguration buildWifiConfigurationForPasspoint() {
            WifiConfiguration wifiConfiguration = new WifiConfiguration();
            wifiConfiguration.FQDN = this.mPasspointConfiguration.getHomeSp().getFqdn();
            wifiConfiguration.setPasspointUniqueId(this.mPasspointConfiguration.getUniqueId());
            wifiConfiguration.priority = this.mPriority;
            wifiConfiguration.meteredOverride = this.mMeteredOverride;
            wifiConfiguration.trusted = !this.mIsNetworkUntrusted;
            this.mPasspointConfiguration.setCarrierId(this.mCarrierId);
            this.mPasspointConfiguration.setMeteredOverride(wifiConfiguration.meteredOverride);
            return wifiConfiguration;
        }

        public WifiNetworkSuggestion build() {
            WifiConfiguration wifiConfiguration;
            this.validateSecurityParams();
            if (this.mPasspointConfiguration != null) {
                if (this.mSsid != null) {
                    throw new IllegalStateException("setSsid should not be invoked for suggestion with Passpoint configuration");
                }
                if (this.mIsHiddenSSID) {
                    throw new IllegalStateException("setIsHiddenSsid should not be invoked for suggestion with Passpoint configuration");
                }
                wifiConfiguration = this.buildWifiConfigurationForPasspoint();
            } else {
                if (this.mSsid == null) {
                    throw new IllegalStateException("setSsid should be invoked for suggestion");
                }
                if (TextUtils.isEmpty(this.mSsid)) {
                    throw new IllegalStateException("invalid ssid for suggestion");
                }
                if (this.mBssid != null && (this.mBssid.equals(MacAddress.BROADCAST_ADDRESS) || this.mBssid.equals(WifiManager.ALL_ZEROS_MAC_ADDRESS))) {
                    throw new IllegalStateException("invalid bssid for suggestion");
                }
                wifiConfiguration = this.buildWifiConfiguration();
                if (wifiConfiguration.isOpenNetwork()) {
                    if (this.mIsSharedWithUserSet && this.mIsSharedWithUser) {
                        throw new IllegalStateException("Open network should not be setCredentialSharedWithUser to true");
                    }
                    this.mIsSharedWithUser = false;
                }
            }
            if (!this.mIsSharedWithUser && !this.mIsInitialAutojoinEnabled) {
                throw new IllegalStateException("Should have not a network with both setCredentialSharedWithUser and setIsAutojoinEnabled set to false");
            }
            if (this.mIsNetworkUntrusted) {
                if (this.mIsSharedWithUserSet && this.mIsSharedWithUser) {
                    throw new IllegalStateException("Should not be bothsetCredentialSharedWithUser and +setIsNetworkAsUntrusted to true");
                }
                this.mIsSharedWithUser = false;
            }
            return new WifiNetworkSuggestion(wifiConfiguration, this.mPasspointConfiguration, this.mIsAppInteractionRequired, this.mIsUserInteractionRequired, this.mIsSharedWithUser, this.mIsInitialAutojoinEnabled);
        }
    }
}

