/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SystemApi;
import android.net.MacAddress;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SoftApConfiguration
implements Parcelable {
    private static final String TAG = "SoftApConfiguration";
    @VisibleForTesting
    static final int PSK_MIN_LEN = 8;
    @VisibleForTesting
    static final int PSK_MAX_LEN = 63;
    @SystemApi
    public static final int BAND_2GHZ = 1;
    @SystemApi
    public static final int BAND_5GHZ = 2;
    @SystemApi
    public static final int BAND_6GHZ = 4;
    @SystemApi
    public static final int BAND_ANY = 7;
    private static final int MIN_CH_2G_BAND = 1;
    private static final int MAX_CH_2G_BAND = 14;
    private static final int MIN_CH_5G_BAND = 34;
    private static final int MAX_CH_5G_BAND = 196;
    private static final int MIN_CH_6G_BAND = 1;
    private static final int MAX_CH_6G_BAND = 253;
    private final String mSsid;
    private final MacAddress mBssid;
    private final String mPassphrase;
    private final boolean mHiddenSsid;
    private final int mBand;
    private final int mChannel;
    private final int mMaxNumberOfClients;
    private final int mSecurityType;
    private final boolean mClientControlByUser;
    private final List<MacAddress> mBlockedClientList;
    private final List<MacAddress> mAllowedClientList;
    private final boolean mAutoShutdownEnabled;
    private final long mShutdownTimeoutMillis;
    public static final int SECURITY_TYPE_OPEN = 0;
    public static final int SECURITY_TYPE_WPA2_PSK = 1;
    public static final int SECURITY_TYPE_WPA3_SAE_TRANSITION = 2;
    public static final int SECURITY_TYPE_WPA3_SAE = 3;
    public static final Parcelable.Creator<SoftApConfiguration> CREATOR = new Parcelable.Creator<SoftApConfiguration>(){

        @Override
        public SoftApConfiguration createFromParcel(Parcel in) {
            return new SoftApConfiguration(in.readString(), (MacAddress)in.readParcelable(MacAddress.class.getClassLoader()), in.readString(), in.readBoolean(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readBoolean(), in.readLong(), in.readBoolean(), in.createTypedArrayList(MacAddress.CREATOR), in.createTypedArrayList(MacAddress.CREATOR));
        }

        public SoftApConfiguration[] newArray(int size) {
            return new SoftApConfiguration[size];
        }
    };

    private static boolean isBandValid(int band) {
        return band != 0 && (band & 0xFFFFFFF8) == 0;
    }

    private static boolean isChannelBandPairValid(int channel, int band) {
        switch (band) {
            case 1: {
                if (channel >= 1 && channel <= 14) break;
                return false;
            }
            case 2: {
                if (channel >= 34 && channel <= 196) break;
                return false;
            }
            case 4: {
                if (channel >= 1 && channel <= 253) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private SoftApConfiguration(String ssid, MacAddress bssid, String passphrase, boolean hiddenSsid, int band, int channel, int securityType, int maxNumberOfClients, boolean shutdownTimeoutEnabled, long shutdownTimeoutMillis, boolean clientControlByUser, List<MacAddress> blockedList, List<MacAddress> allowedList) {
        this.mSsid = ssid;
        this.mBssid = bssid;
        this.mPassphrase = passphrase;
        this.mHiddenSsid = hiddenSsid;
        this.mBand = band;
        this.mChannel = channel;
        this.mSecurityType = securityType;
        this.mMaxNumberOfClients = maxNumberOfClients;
        this.mAutoShutdownEnabled = shutdownTimeoutEnabled;
        this.mShutdownTimeoutMillis = shutdownTimeoutMillis;
        this.mClientControlByUser = clientControlByUser;
        this.mBlockedClientList = new ArrayList<MacAddress>(blockedList);
        this.mAllowedClientList = new ArrayList<MacAddress>(allowedList);
    }

    public boolean equals(Object otherObj) {
        if (this == otherObj) {
            return true;
        }
        if (!(otherObj instanceof SoftApConfiguration)) {
            return false;
        }
        SoftApConfiguration other = (SoftApConfiguration)otherObj;
        return Objects.equals(this.mSsid, other.mSsid) && Objects.equals(this.mBssid, other.mBssid) && Objects.equals(this.mPassphrase, other.mPassphrase) && this.mHiddenSsid == other.mHiddenSsid && this.mBand == other.mBand && this.mChannel == other.mChannel && this.mSecurityType == other.mSecurityType && this.mMaxNumberOfClients == other.mMaxNumberOfClients && this.mAutoShutdownEnabled == other.mAutoShutdownEnabled && this.mShutdownTimeoutMillis == other.mShutdownTimeoutMillis && this.mClientControlByUser == other.mClientControlByUser && Objects.equals(this.mBlockedClientList, other.mBlockedClientList) && Objects.equals(this.mAllowedClientList, other.mAllowedClientList);
    }

    public int hashCode() {
        return Objects.hash(this.mSsid, this.mBssid, this.mPassphrase, this.mHiddenSsid, this.mBand, this.mChannel, this.mSecurityType, this.mMaxNumberOfClients, this.mAutoShutdownEnabled, this.mShutdownTimeoutMillis, this.mClientControlByUser, this.mBlockedClientList, this.mAllowedClientList);
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("ssid=").append(this.mSsid);
        if (this.mBssid != null) {
            sbuf.append(" \n bssid=").append(this.mBssid.toString());
        }
        sbuf.append(" \n Passphrase =").append(TextUtils.isEmpty(this.mPassphrase) ? "<empty>" : "<non-empty>");
        sbuf.append(" \n HiddenSsid =").append(this.mHiddenSsid);
        sbuf.append(" \n Band =").append(this.mBand);
        sbuf.append(" \n Channel =").append(this.mChannel);
        sbuf.append(" \n SecurityType=").append(this.getSecurityType());
        sbuf.append(" \n MaxClient=").append(this.mMaxNumberOfClients);
        sbuf.append(" \n AutoShutdownEnabled=").append(this.mAutoShutdownEnabled);
        sbuf.append(" \n ShutdownTimeoutMillis=").append(this.mShutdownTimeoutMillis);
        sbuf.append(" \n ClientControlByUser=").append(this.mClientControlByUser);
        sbuf.append(" \n BlockedClientList=").append(this.mBlockedClientList);
        sbuf.append(" \n AllowedClientList=").append(this.mAllowedClientList);
        return sbuf.toString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mSsid);
        dest.writeParcelable(this.mBssid, flags);
        dest.writeString(this.mPassphrase);
        dest.writeBoolean(this.mHiddenSsid);
        dest.writeInt(this.mBand);
        dest.writeInt(this.mChannel);
        dest.writeInt(this.mSecurityType);
        dest.writeInt(this.mMaxNumberOfClients);
        dest.writeBoolean(this.mAutoShutdownEnabled);
        dest.writeLong(this.mShutdownTimeoutMillis);
        dest.writeBoolean(this.mClientControlByUser);
        dest.writeTypedList(this.mBlockedClientList);
        dest.writeTypedList(this.mAllowedClientList);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getSsid() {
        return this.mSsid;
    }

    public MacAddress getBssid() {
        return this.mBssid;
    }

    public String getPassphrase() {
        return this.mPassphrase;
    }

    public boolean isHiddenSsid() {
        return this.mHiddenSsid;
    }

    @SystemApi
    public int getBand() {
        return this.mBand;
    }

    @SystemApi
    public int getChannel() {
        return this.mChannel;
    }

    public int getSecurityType() {
        return this.mSecurityType;
    }

    @SystemApi
    public int getMaxNumberOfClients() {
        return this.mMaxNumberOfClients;
    }

    @SystemApi
    public boolean isAutoShutdownEnabled() {
        return this.mAutoShutdownEnabled;
    }

    @SystemApi
    public long getShutdownTimeoutMillis() {
        return this.mShutdownTimeoutMillis;
    }

    @SystemApi
    public boolean isClientControlByUserEnabled() {
        return this.mClientControlByUser;
    }

    @SystemApi
    public List<MacAddress> getBlockedClientList() {
        return this.mBlockedClientList;
    }

    @SystemApi
    public List<MacAddress> getAllowedClientList() {
        return this.mAllowedClientList;
    }

    @SystemApi
    public WifiConfiguration toWifiConfiguration() {
        WifiConfiguration wifiConfig = new WifiConfiguration();
        wifiConfig.SSID = this.mSsid;
        wifiConfig.preSharedKey = this.mPassphrase;
        wifiConfig.hiddenSSID = this.mHiddenSsid;
        wifiConfig.apChannel = this.mChannel;
        switch (this.mSecurityType) {
            case 0: {
                wifiConfig.allowedKeyManagement.set(0);
                break;
            }
            case 1: {
                wifiConfig.allowedKeyManagement.set(4);
                break;
            }
            default: {
                Log.e(TAG, "Convert fail, unsupported security type :" + this.mSecurityType);
                return null;
            }
        }
        switch (this.mBand) {
            case 1: {
                wifiConfig.apBand = 0;
                break;
            }
            case 2: {
                wifiConfig.apBand = 1;
                break;
            }
            case 3: {
                wifiConfig.apBand = -1;
                break;
            }
            case 7: {
                wifiConfig.apBand = -1;
                break;
            }
            default: {
                Log.e(TAG, "Convert fail, unsupported band setting :" + this.mBand);
                return null;
            }
        }
        return wifiConfig;
    }

    @SystemApi
    public static class Builder {
        private String mSsid;
        private MacAddress mBssid;
        private String mPassphrase;
        private boolean mHiddenSsid;
        private int mBand;
        private int mChannel;
        private int mMaxNumberOfClients;
        private int mSecurityType;
        private boolean mAutoShutdownEnabled;
        private long mShutdownTimeoutMillis;
        private boolean mClientControlByUser;
        private List<MacAddress> mBlockedClientList;
        private List<MacAddress> mAllowedClientList;

        public Builder() {
            this.mSsid = null;
            this.mBssid = null;
            this.mPassphrase = null;
            this.mHiddenSsid = false;
            this.mBand = 1;
            this.mChannel = 0;
            this.mMaxNumberOfClients = 0;
            this.mSecurityType = 0;
            this.mAutoShutdownEnabled = true;
            this.mShutdownTimeoutMillis = 0L;
            this.mClientControlByUser = false;
            this.mBlockedClientList = new ArrayList<MacAddress>();
            this.mAllowedClientList = new ArrayList<MacAddress>();
        }

        public Builder(SoftApConfiguration other) {
            Objects.requireNonNull(other);
            this.mSsid = other.mSsid;
            this.mBssid = other.mBssid;
            this.mPassphrase = other.mPassphrase;
            this.mHiddenSsid = other.mHiddenSsid;
            this.mBand = other.mBand;
            this.mChannel = other.mChannel;
            this.mMaxNumberOfClients = other.mMaxNumberOfClients;
            this.mSecurityType = other.mSecurityType;
            this.mAutoShutdownEnabled = other.mAutoShutdownEnabled;
            this.mShutdownTimeoutMillis = other.mShutdownTimeoutMillis;
            this.mClientControlByUser = other.mClientControlByUser;
            this.mBlockedClientList = new ArrayList<MacAddress>(other.mBlockedClientList);
            this.mAllowedClientList = new ArrayList<MacAddress>(other.mAllowedClientList);
        }

        public SoftApConfiguration build() {
            for (MacAddress client : this.mAllowedClientList) {
                if (!this.mBlockedClientList.contains(client)) continue;
                throw new IllegalArgumentException("A MacAddress exist in both client list");
            }
            return new SoftApConfiguration(this.mSsid, this.mBssid, this.mPassphrase, this.mHiddenSsid, this.mBand, this.mChannel, this.mSecurityType, this.mMaxNumberOfClients, this.mAutoShutdownEnabled, this.mShutdownTimeoutMillis, this.mClientControlByUser, this.mBlockedClientList, this.mAllowedClientList);
        }

        public Builder setSsid(String ssid) {
            if (ssid != null) {
                Preconditions.checkStringNotEmpty(ssid);
                Preconditions.checkArgument(StandardCharsets.UTF_8.newEncoder().canEncode(ssid));
            }
            this.mSsid = ssid;
            return this;
        }

        public Builder setBssid(MacAddress bssid) {
            if (bssid != null) {
                Preconditions.checkArgument(!bssid.equals(WifiManager.ALL_ZEROS_MAC_ADDRESS));
                Preconditions.checkArgument(!bssid.equals(MacAddress.BROADCAST_ADDRESS));
            }
            this.mBssid = bssid;
            return this;
        }

        public Builder setPassphrase(String passphrase, int securityType) {
            if (securityType == 0) {
                if (passphrase != null) {
                    throw new IllegalArgumentException("passphrase should be null when security type is open");
                }
            } else {
                Preconditions.checkStringNotEmpty(passphrase);
                CharsetEncoder asciiEncoder = StandardCharsets.US_ASCII.newEncoder();
                if (!asciiEncoder.canEncode(passphrase)) {
                    throw new IllegalArgumentException("passphrase not ASCII encodable");
                }
                if (!(securityType != 1 && securityType != 2 || passphrase.length() >= 8 && passphrase.length() <= 63)) {
                    throw new IllegalArgumentException("Password size must be at least 8 and no more than 63 for WPA2_PSK and WPA3_SAE_TRANSITION Mode");
                }
            }
            this.mSecurityType = securityType;
            this.mPassphrase = passphrase;
            return this;
        }

        public Builder setHiddenSsid(boolean hiddenSsid) {
            this.mHiddenSsid = hiddenSsid;
            return this;
        }

        public Builder setBand(int band) {
            if (!SoftApConfiguration.isBandValid(band)) {
                throw new IllegalArgumentException("Invalid band type");
            }
            this.mBand = band;
            this.mChannel = 0;
            return this;
        }

        public Builder setChannel(int channel, int band) {
            if (!SoftApConfiguration.isChannelBandPairValid(channel, band)) {
                throw new IllegalArgumentException("Invalid band type");
            }
            this.mBand = band;
            this.mChannel = channel;
            return this;
        }

        public Builder setMaxNumberOfClients(int maxNumberOfClients) {
            if (maxNumberOfClients < 0) {
                throw new IllegalArgumentException("maxNumberOfClients should be not negative");
            }
            this.mMaxNumberOfClients = maxNumberOfClients;
            return this;
        }

        public Builder setAutoShutdownEnabled(boolean enable) {
            this.mAutoShutdownEnabled = enable;
            return this;
        }

        public Builder setShutdownTimeoutMillis(long timeoutMillis) {
            if (timeoutMillis < 0L) {
                throw new IllegalArgumentException("Invalid timeout value");
            }
            this.mShutdownTimeoutMillis = timeoutMillis;
            return this;
        }

        public Builder setClientControlByUserEnabled(boolean enabled) {
            this.mClientControlByUser = enabled;
            return this;
        }

        public Builder setAllowedClientList(List<MacAddress> allowedClientList) {
            this.mAllowedClientList = new ArrayList<MacAddress>(allowedClientList);
            return this;
        }

        public Builder setBlockedClientList(List<MacAddress> blockedClientList) {
            this.mBlockedClientList = new ArrayList<MacAddress>(blockedClientList);
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SecurityType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BandType {
    }
}

