/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.pm.ParceledListSlice;
import android.net.DhcpInfo;
import android.net.Network;
import android.net.wifi.IActionListener;
import android.net.wifi.IDppCallback;
import android.net.wifi.ILocalOnlyHotspotCallback;
import android.net.wifi.INetworkRequestMatchCallback;
import android.net.wifi.IOnWifiActivityEnergyInfoListener;
import android.net.wifi.IOnWifiUsabilityStatsListener;
import android.net.wifi.IScanResultsCallback;
import android.net.wifi.ISoftApCallback;
import android.net.wifi.ISuggestionConnectionStatusListener;
import android.net.wifi.ITrafficStateCallback;
import android.net.wifi.IWifiConnectedNetworkScorer;
import android.net.wifi.ScanResult;
import android.net.wifi.SoftApConfiguration;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiNetworkSuggestion;
import android.net.wifi.hotspot2.IProvisioningCallback;
import android.net.wifi.hotspot2.OsuProvider;
import android.net.wifi.hotspot2.PasspointConfiguration;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.WorkSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface IWifiManager
extends IInterface {
    public long getSupportedFeatures() throws RemoteException;

    public void getWifiActivityEnergyInfoAsync(IOnWifiActivityEnergyInfoListener var1) throws RemoteException;

    public ParceledListSlice getConfiguredNetworks(String var1, String var2) throws RemoteException;

    public ParceledListSlice getPrivilegedConfiguredNetworks(String var1, String var2) throws RemoteException;

    public Map getAllMatchingFqdnsForScanResults(List<ScanResult> var1) throws RemoteException;

    public Map getMatchingOsuProviders(List<ScanResult> var1) throws RemoteException;

    public Map getMatchingPasspointConfigsForOsuProviders(List<OsuProvider> var1) throws RemoteException;

    public int addOrUpdateNetwork(WifiConfiguration var1, String var2) throws RemoteException;

    public boolean addOrUpdatePasspointConfiguration(PasspointConfiguration var1, String var2) throws RemoteException;

    public boolean removePasspointConfiguration(String var1, String var2) throws RemoteException;

    public List<PasspointConfiguration> getPasspointConfigurations(String var1) throws RemoteException;

    public List<WifiConfiguration> getWifiConfigsForPasspointProfiles(List<String> var1) throws RemoteException;

    public void queryPasspointIcon(long var1, String var3) throws RemoteException;

    public int matchProviderWithCurrentNetwork(String var1) throws RemoteException;

    public void deauthenticateNetwork(long var1, boolean var3) throws RemoteException;

    public boolean removeNetwork(int var1, String var2) throws RemoteException;

    public boolean enableNetwork(int var1, boolean var2, String var3) throws RemoteException;

    public boolean disableNetwork(int var1, String var2) throws RemoteException;

    public void allowAutojoinGlobal(boolean var1) throws RemoteException;

    public void allowAutojoin(int var1, boolean var2) throws RemoteException;

    public void allowAutojoinPasspoint(String var1, boolean var2) throws RemoteException;

    public void setMacRandomizationSettingPasspointEnabled(String var1, boolean var2) throws RemoteException;

    public void setPasspointMeteredOverride(String var1, int var2) throws RemoteException;

    public boolean startScan(String var1, String var2) throws RemoteException;

    public List<ScanResult> getScanResults(String var1, String var2) throws RemoteException;

    public boolean disconnect(String var1) throws RemoteException;

    public boolean reconnect(String var1) throws RemoteException;

    public boolean reassociate(String var1) throws RemoteException;

    public WifiInfo getConnectionInfo(String var1, String var2) throws RemoteException;

    public boolean setWifiEnabled(String var1, boolean var2) throws RemoteException;

    public int getWifiEnabledState() throws RemoteException;

    public String getCountryCode() throws RemoteException;

    public boolean is5GHzBandSupported() throws RemoteException;

    public boolean is6GHzBandSupported() throws RemoteException;

    public boolean isWifiStandardSupported(int var1) throws RemoteException;

    public DhcpInfo getDhcpInfo() throws RemoteException;

    public void setScanAlwaysAvailable(boolean var1) throws RemoteException;

    public boolean isScanAlwaysAvailable() throws RemoteException;

    public boolean acquireWifiLock(IBinder var1, int var2, String var3, WorkSource var4) throws RemoteException;

    public void updateWifiLockWorkSource(IBinder var1, WorkSource var2) throws RemoteException;

    public boolean releaseWifiLock(IBinder var1) throws RemoteException;

    public void initializeMulticastFiltering() throws RemoteException;

    public boolean isMulticastEnabled() throws RemoteException;

    public void acquireMulticastLock(IBinder var1, String var2) throws RemoteException;

    public void releaseMulticastLock(String var1) throws RemoteException;

    public void updateInterfaceIpState(String var1, int var2) throws RemoteException;

    public boolean startSoftAp(WifiConfiguration var1) throws RemoteException;

    public boolean startTetheredHotspot(SoftApConfiguration var1) throws RemoteException;

    public boolean stopSoftAp() throws RemoteException;

    public int startLocalOnlyHotspot(ILocalOnlyHotspotCallback var1, String var2, String var3, SoftApConfiguration var4) throws RemoteException;

    public void stopLocalOnlyHotspot() throws RemoteException;

    public void startWatchLocalOnlyHotspot(ILocalOnlyHotspotCallback var1) throws RemoteException;

    public void stopWatchLocalOnlyHotspot() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/wifi/java/android/net/wifi/IWifiManager.aidl:162:1:162:25")
    public int getWifiApEnabledState() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/wifi/java/android/net/wifi/IWifiManager.aidl:165:1:165:25")
    public WifiConfiguration getWifiApConfiguration() throws RemoteException;

    public SoftApConfiguration getSoftApConfiguration() throws RemoteException;

    public boolean setWifiApConfiguration(WifiConfiguration var1, String var2) throws RemoteException;

    public boolean setSoftApConfiguration(SoftApConfiguration var1, String var2) throws RemoteException;

    public void notifyUserOfApBandConversion(String var1) throws RemoteException;

    public void enableTdls(String var1, boolean var2) throws RemoteException;

    public void enableTdlsWithMacAddress(String var1, boolean var2) throws RemoteException;

    public String getCurrentNetworkWpsNfcConfigurationToken() throws RemoteException;

    public void enableVerboseLogging(int var1) throws RemoteException;

    public int getVerboseLoggingLevel() throws RemoteException;

    public void disableEphemeralNetwork(String var1, String var2) throws RemoteException;

    public void factoryReset(String var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/wifi/java/android/net/wifi/IWifiManager.aidl:190:1:190:25")
    public Network getCurrentNetwork() throws RemoteException;

    public byte[] retrieveBackupData() throws RemoteException;

    public void restoreBackupData(byte[] var1) throws RemoteException;

    public byte[] retrieveSoftApBackupData() throws RemoteException;

    public SoftApConfiguration restoreSoftApBackupData(byte[] var1) throws RemoteException;

    public void restoreSupplicantBackupData(byte[] var1, byte[] var2) throws RemoteException;

    public void startSubscriptionProvisioning(OsuProvider var1, IProvisioningCallback var2) throws RemoteException;

    public void registerSoftApCallback(IBinder var1, ISoftApCallback var2, int var3) throws RemoteException;

    public void unregisterSoftApCallback(int var1) throws RemoteException;

    public void addOnWifiUsabilityStatsListener(IBinder var1, IOnWifiUsabilityStatsListener var2, int var3) throws RemoteException;

    public void removeOnWifiUsabilityStatsListener(int var1) throws RemoteException;

    public void registerTrafficStateCallback(IBinder var1, ITrafficStateCallback var2, int var3) throws RemoteException;

    public void unregisterTrafficStateCallback(int var1) throws RemoteException;

    public void registerNetworkRequestMatchCallback(IBinder var1, INetworkRequestMatchCallback var2, int var3) throws RemoteException;

    public void unregisterNetworkRequestMatchCallback(int var1) throws RemoteException;

    public int addNetworkSuggestions(List<WifiNetworkSuggestion> var1, String var2, String var3) throws RemoteException;

    public int removeNetworkSuggestions(List<WifiNetworkSuggestion> var1, String var2) throws RemoteException;

    public List<WifiNetworkSuggestion> getNetworkSuggestions(String var1) throws RemoteException;

    public String[] getFactoryMacAddresses() throws RemoteException;

    public void setDeviceMobilityState(int var1) throws RemoteException;

    public void startDppAsConfiguratorInitiator(IBinder var1, String var2, int var3, int var4, IDppCallback var5) throws RemoteException;

    public void startDppAsEnrolleeInitiator(IBinder var1, String var2, IDppCallback var3) throws RemoteException;

    public void stopDppSession() throws RemoteException;

    public void updateWifiUsabilityScore(int var1, int var2, int var3) throws RemoteException;

    public void connect(WifiConfiguration var1, int var2, IBinder var3, IActionListener var4, int var5) throws RemoteException;

    public void save(WifiConfiguration var1, IBinder var2, IActionListener var3, int var4) throws RemoteException;

    public void forget(int var1, IBinder var2, IActionListener var3, int var4) throws RemoteException;

    public void registerScanResultsCallback(IScanResultsCallback var1) throws RemoteException;

    public void unregisterScanResultsCallback(IScanResultsCallback var1) throws RemoteException;

    public void registerSuggestionConnectionStatusListener(IBinder var1, ISuggestionConnectionStatusListener var2, int var3, String var4, String var5) throws RemoteException;

    public void unregisterSuggestionConnectionStatusListener(int var1, String var2) throws RemoteException;

    public int calculateSignalLevel(int var1) throws RemoteException;

    public List<WifiConfiguration> getWifiConfigForMatchedNetworkSuggestionsSharedWithUser(List<ScanResult> var1) throws RemoteException;

    public boolean setWifiConnectedNetworkScorer(IBinder var1, IWifiConnectedNetworkScorer var2) throws RemoteException;

    public void clearWifiConnectedNetworkScorer() throws RemoteException;

    public Map getMatchingScanResults(List<WifiNetworkSuggestion> var1, List<ScanResult> var2, String var3, String var4) throws RemoteException;

    public void setScanThrottleEnabled(boolean var1) throws RemoteException;

    public boolean isScanThrottleEnabled() throws RemoteException;

    public Map getAllMatchingPasspointProfilesForScanResults(List<ScanResult> var1) throws RemoteException;

    public void setAutoWakeupEnabled(boolean var1) throws RemoteException;

    public boolean isAutoWakeupEnabled() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWifiManager {
        private static final String DESCRIPTOR = "android.net.wifi.IWifiManager";
        static final int TRANSACTION_getSupportedFeatures = 1;
        static final int TRANSACTION_getWifiActivityEnergyInfoAsync = 2;
        static final int TRANSACTION_getConfiguredNetworks = 3;
        static final int TRANSACTION_getPrivilegedConfiguredNetworks = 4;
        static final int TRANSACTION_getAllMatchingFqdnsForScanResults = 5;
        static final int TRANSACTION_getMatchingOsuProviders = 6;
        static final int TRANSACTION_getMatchingPasspointConfigsForOsuProviders = 7;
        static final int TRANSACTION_addOrUpdateNetwork = 8;
        static final int TRANSACTION_addOrUpdatePasspointConfiguration = 9;
        static final int TRANSACTION_removePasspointConfiguration = 10;
        static final int TRANSACTION_getPasspointConfigurations = 11;
        static final int TRANSACTION_getWifiConfigsForPasspointProfiles = 12;
        static final int TRANSACTION_queryPasspointIcon = 13;
        static final int TRANSACTION_matchProviderWithCurrentNetwork = 14;
        static final int TRANSACTION_deauthenticateNetwork = 15;
        static final int TRANSACTION_removeNetwork = 16;
        static final int TRANSACTION_enableNetwork = 17;
        static final int TRANSACTION_disableNetwork = 18;
        static final int TRANSACTION_allowAutojoinGlobal = 19;
        static final int TRANSACTION_allowAutojoin = 20;
        static final int TRANSACTION_allowAutojoinPasspoint = 21;
        static final int TRANSACTION_setMacRandomizationSettingPasspointEnabled = 22;
        static final int TRANSACTION_setPasspointMeteredOverride = 23;
        static final int TRANSACTION_startScan = 24;
        static final int TRANSACTION_getScanResults = 25;
        static final int TRANSACTION_disconnect = 26;
        static final int TRANSACTION_reconnect = 27;
        static final int TRANSACTION_reassociate = 28;
        static final int TRANSACTION_getConnectionInfo = 29;
        static final int TRANSACTION_setWifiEnabled = 30;
        static final int TRANSACTION_getWifiEnabledState = 31;
        static final int TRANSACTION_getCountryCode = 32;
        static final int TRANSACTION_is5GHzBandSupported = 33;
        static final int TRANSACTION_is6GHzBandSupported = 34;
        static final int TRANSACTION_isWifiStandardSupported = 35;
        static final int TRANSACTION_getDhcpInfo = 36;
        static final int TRANSACTION_setScanAlwaysAvailable = 37;
        static final int TRANSACTION_isScanAlwaysAvailable = 38;
        static final int TRANSACTION_acquireWifiLock = 39;
        static final int TRANSACTION_updateWifiLockWorkSource = 40;
        static final int TRANSACTION_releaseWifiLock = 41;
        static final int TRANSACTION_initializeMulticastFiltering = 42;
        static final int TRANSACTION_isMulticastEnabled = 43;
        static final int TRANSACTION_acquireMulticastLock = 44;
        static final int TRANSACTION_releaseMulticastLock = 45;
        static final int TRANSACTION_updateInterfaceIpState = 46;
        static final int TRANSACTION_startSoftAp = 47;
        static final int TRANSACTION_startTetheredHotspot = 48;
        static final int TRANSACTION_stopSoftAp = 49;
        static final int TRANSACTION_startLocalOnlyHotspot = 50;
        static final int TRANSACTION_stopLocalOnlyHotspot = 51;
        static final int TRANSACTION_startWatchLocalOnlyHotspot = 52;
        static final int TRANSACTION_stopWatchLocalOnlyHotspot = 53;
        static final int TRANSACTION_getWifiApEnabledState = 54;
        static final int TRANSACTION_getWifiApConfiguration = 55;
        static final int TRANSACTION_getSoftApConfiguration = 56;
        static final int TRANSACTION_setWifiApConfiguration = 57;
        static final int TRANSACTION_setSoftApConfiguration = 58;
        static final int TRANSACTION_notifyUserOfApBandConversion = 59;
        static final int TRANSACTION_enableTdls = 60;
        static final int TRANSACTION_enableTdlsWithMacAddress = 61;
        static final int TRANSACTION_getCurrentNetworkWpsNfcConfigurationToken = 62;
        static final int TRANSACTION_enableVerboseLogging = 63;
        static final int TRANSACTION_getVerboseLoggingLevel = 64;
        static final int TRANSACTION_disableEphemeralNetwork = 65;
        static final int TRANSACTION_factoryReset = 66;
        static final int TRANSACTION_getCurrentNetwork = 67;
        static final int TRANSACTION_retrieveBackupData = 68;
        static final int TRANSACTION_restoreBackupData = 69;
        static final int TRANSACTION_retrieveSoftApBackupData = 70;
        static final int TRANSACTION_restoreSoftApBackupData = 71;
        static final int TRANSACTION_restoreSupplicantBackupData = 72;
        static final int TRANSACTION_startSubscriptionProvisioning = 73;
        static final int TRANSACTION_registerSoftApCallback = 74;
        static final int TRANSACTION_unregisterSoftApCallback = 75;
        static final int TRANSACTION_addOnWifiUsabilityStatsListener = 76;
        static final int TRANSACTION_removeOnWifiUsabilityStatsListener = 77;
        static final int TRANSACTION_registerTrafficStateCallback = 78;
        static final int TRANSACTION_unregisterTrafficStateCallback = 79;
        static final int TRANSACTION_registerNetworkRequestMatchCallback = 80;
        static final int TRANSACTION_unregisterNetworkRequestMatchCallback = 81;
        static final int TRANSACTION_addNetworkSuggestions = 82;
        static final int TRANSACTION_removeNetworkSuggestions = 83;
        static final int TRANSACTION_getNetworkSuggestions = 84;
        static final int TRANSACTION_getFactoryMacAddresses = 85;
        static final int TRANSACTION_setDeviceMobilityState = 86;
        static final int TRANSACTION_startDppAsConfiguratorInitiator = 87;
        static final int TRANSACTION_startDppAsEnrolleeInitiator = 88;
        static final int TRANSACTION_stopDppSession = 89;
        static final int TRANSACTION_updateWifiUsabilityScore = 90;
        static final int TRANSACTION_connect = 91;
        static final int TRANSACTION_save = 92;
        static final int TRANSACTION_forget = 93;
        static final int TRANSACTION_registerScanResultsCallback = 94;
        static final int TRANSACTION_unregisterScanResultsCallback = 95;
        static final int TRANSACTION_registerSuggestionConnectionStatusListener = 96;
        static final int TRANSACTION_unregisterSuggestionConnectionStatusListener = 97;
        static final int TRANSACTION_calculateSignalLevel = 98;
        static final int TRANSACTION_getWifiConfigForMatchedNetworkSuggestionsSharedWithUser = 99;
        static final int TRANSACTION_setWifiConnectedNetworkScorer = 100;
        static final int TRANSACTION_clearWifiConnectedNetworkScorer = 101;
        static final int TRANSACTION_getMatchingScanResults = 102;
        static final int TRANSACTION_setScanThrottleEnabled = 103;
        static final int TRANSACTION_isScanThrottleEnabled = 104;
        static final int TRANSACTION_getAllMatchingPasspointProfilesForScanResults = 105;
        static final int TRANSACTION_setAutoWakeupEnabled = 106;
        static final int TRANSACTION_isAutoWakeupEnabled = 107;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWifiManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWifiManager) {
                return (IWifiManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getSupportedFeatures";
                }
                case 2: {
                    return "getWifiActivityEnergyInfoAsync";
                }
                case 3: {
                    return "getConfiguredNetworks";
                }
                case 4: {
                    return "getPrivilegedConfiguredNetworks";
                }
                case 5: {
                    return "getAllMatchingFqdnsForScanResults";
                }
                case 6: {
                    return "getMatchingOsuProviders";
                }
                case 7: {
                    return "getMatchingPasspointConfigsForOsuProviders";
                }
                case 8: {
                    return "addOrUpdateNetwork";
                }
                case 9: {
                    return "addOrUpdatePasspointConfiguration";
                }
                case 10: {
                    return "removePasspointConfiguration";
                }
                case 11: {
                    return "getPasspointConfigurations";
                }
                case 12: {
                    return "getWifiConfigsForPasspointProfiles";
                }
                case 13: {
                    return "queryPasspointIcon";
                }
                case 14: {
                    return "matchProviderWithCurrentNetwork";
                }
                case 15: {
                    return "deauthenticateNetwork";
                }
                case 16: {
                    return "removeNetwork";
                }
                case 17: {
                    return "enableNetwork";
                }
                case 18: {
                    return "disableNetwork";
                }
                case 19: {
                    return "allowAutojoinGlobal";
                }
                case 20: {
                    return "allowAutojoin";
                }
                case 21: {
                    return "allowAutojoinPasspoint";
                }
                case 22: {
                    return "setMacRandomizationSettingPasspointEnabled";
                }
                case 23: {
                    return "setPasspointMeteredOverride";
                }
                case 24: {
                    return "startScan";
                }
                case 25: {
                    return "getScanResults";
                }
                case 26: {
                    return "disconnect";
                }
                case 27: {
                    return "reconnect";
                }
                case 28: {
                    return "reassociate";
                }
                case 29: {
                    return "getConnectionInfo";
                }
                case 30: {
                    return "setWifiEnabled";
                }
                case 31: {
                    return "getWifiEnabledState";
                }
                case 32: {
                    return "getCountryCode";
                }
                case 33: {
                    return "is5GHzBandSupported";
                }
                case 34: {
                    return "is6GHzBandSupported";
                }
                case 35: {
                    return "isWifiStandardSupported";
                }
                case 36: {
                    return "getDhcpInfo";
                }
                case 37: {
                    return "setScanAlwaysAvailable";
                }
                case 38: {
                    return "isScanAlwaysAvailable";
                }
                case 39: {
                    return "acquireWifiLock";
                }
                case 40: {
                    return "updateWifiLockWorkSource";
                }
                case 41: {
                    return "releaseWifiLock";
                }
                case 42: {
                    return "initializeMulticastFiltering";
                }
                case 43: {
                    return "isMulticastEnabled";
                }
                case 44: {
                    return "acquireMulticastLock";
                }
                case 45: {
                    return "releaseMulticastLock";
                }
                case 46: {
                    return "updateInterfaceIpState";
                }
                case 47: {
                    return "startSoftAp";
                }
                case 48: {
                    return "startTetheredHotspot";
                }
                case 49: {
                    return "stopSoftAp";
                }
                case 50: {
                    return "startLocalOnlyHotspot";
                }
                case 51: {
                    return "stopLocalOnlyHotspot";
                }
                case 52: {
                    return "startWatchLocalOnlyHotspot";
                }
                case 53: {
                    return "stopWatchLocalOnlyHotspot";
                }
                case 54: {
                    return "getWifiApEnabledState";
                }
                case 55: {
                    return "getWifiApConfiguration";
                }
                case 56: {
                    return "getSoftApConfiguration";
                }
                case 57: {
                    return "setWifiApConfiguration";
                }
                case 58: {
                    return "setSoftApConfiguration";
                }
                case 59: {
                    return "notifyUserOfApBandConversion";
                }
                case 60: {
                    return "enableTdls";
                }
                case 61: {
                    return "enableTdlsWithMacAddress";
                }
                case 62: {
                    return "getCurrentNetworkWpsNfcConfigurationToken";
                }
                case 63: {
                    return "enableVerboseLogging";
                }
                case 64: {
                    return "getVerboseLoggingLevel";
                }
                case 65: {
                    return "disableEphemeralNetwork";
                }
                case 66: {
                    return "factoryReset";
                }
                case 67: {
                    return "getCurrentNetwork";
                }
                case 68: {
                    return "retrieveBackupData";
                }
                case 69: {
                    return "restoreBackupData";
                }
                case 70: {
                    return "retrieveSoftApBackupData";
                }
                case 71: {
                    return "restoreSoftApBackupData";
                }
                case 72: {
                    return "restoreSupplicantBackupData";
                }
                case 73: {
                    return "startSubscriptionProvisioning";
                }
                case 74: {
                    return "registerSoftApCallback";
                }
                case 75: {
                    return "unregisterSoftApCallback";
                }
                case 76: {
                    return "addOnWifiUsabilityStatsListener";
                }
                case 77: {
                    return "removeOnWifiUsabilityStatsListener";
                }
                case 78: {
                    return "registerTrafficStateCallback";
                }
                case 79: {
                    return "unregisterTrafficStateCallback";
                }
                case 80: {
                    return "registerNetworkRequestMatchCallback";
                }
                case 81: {
                    return "unregisterNetworkRequestMatchCallback";
                }
                case 82: {
                    return "addNetworkSuggestions";
                }
                case 83: {
                    return "removeNetworkSuggestions";
                }
                case 84: {
                    return "getNetworkSuggestions";
                }
                case 85: {
                    return "getFactoryMacAddresses";
                }
                case 86: {
                    return "setDeviceMobilityState";
                }
                case 87: {
                    return "startDppAsConfiguratorInitiator";
                }
                case 88: {
                    return "startDppAsEnrolleeInitiator";
                }
                case 89: {
                    return "stopDppSession";
                }
                case 90: {
                    return "updateWifiUsabilityScore";
                }
                case 91: {
                    return "connect";
                }
                case 92: {
                    return "save";
                }
                case 93: {
                    return "forget";
                }
                case 94: {
                    return "registerScanResultsCallback";
                }
                case 95: {
                    return "unregisterScanResultsCallback";
                }
                case 96: {
                    return "registerSuggestionConnectionStatusListener";
                }
                case 97: {
                    return "unregisterSuggestionConnectionStatusListener";
                }
                case 98: {
                    return "calculateSignalLevel";
                }
                case 99: {
                    return "getWifiConfigForMatchedNetworkSuggestionsSharedWithUser";
                }
                case 100: {
                    return "setWifiConnectedNetworkScorer";
                }
                case 101: {
                    return "clearWifiConnectedNetworkScorer";
                }
                case 102: {
                    return "getMatchingScanResults";
                }
                case 103: {
                    return "setScanThrottleEnabled";
                }
                case 104: {
                    return "isScanThrottleEnabled";
                }
                case 105: {
                    return "getAllMatchingPasspointProfilesForScanResults";
                }
                case 106: {
                    return "setAutoWakeupEnabled";
                }
                case 107: {
                    return "isAutoWakeupEnabled";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    long _result = this.getSupportedFeatures();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    IOnWifiActivityEnergyInfoListener _arg0 = IOnWifiActivityEnergyInfoListener.Stub.asInterface(data.readStrongBinder());
                    this.getWifiActivityEnergyInfoAsync(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    ParceledListSlice _result = this.getConfiguredNetworks(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    ParceledListSlice _result = this.getPrivilegedConfiguredNetworks(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    ArrayList<ScanResult> _arg0 = data.createTypedArrayList(ScanResult.CREATOR);
                    Map _result = this.getAllMatchingFqdnsForScanResults(_arg0);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    ArrayList<ScanResult> _arg0 = data.createTypedArrayList(ScanResult.CREATOR);
                    Map _result = this.getMatchingOsuProviders(_arg0);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    ArrayList<OsuProvider> _arg0 = data.createTypedArrayList(OsuProvider.CREATOR);
                    Map _result = this.getMatchingPasspointConfigsForOsuProviders(_arg0);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    WifiConfiguration _arg0 = 0 != data.readInt() ? WifiConfiguration.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    int _result = this.addOrUpdateNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    PasspointConfiguration _arg0 = 0 != data.readInt() ? PasspointConfiguration.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    boolean _result = this.addOrUpdatePasspointConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _result = this.removePasspointConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    List<PasspointConfiguration> _result = this.getPasspointConfigurations(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    List<WifiConfiguration> _result = this.getWifiConfigsForPasspointProfiles(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    this.queryPasspointIcon(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _result = this.matchProviderWithCurrentNetwork(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    boolean _arg1 = 0 != data.readInt();
                    this.deauthenticateNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _result = this.removeNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    String _arg2 = data.readString();
                    boolean _result = this.enableNetwork(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _result = this.disableNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.allowAutojoinGlobal(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.allowAutojoin(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.allowAutojoinPasspoint(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.setMacRandomizationSettingPasspointEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.setPasspointMeteredOverride(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _result = this.startScan(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    List<ScanResult> _result = this.getScanResults(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.disconnect(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.reconnect(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.reassociate(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    WifiInfo _result = this.getConnectionInfo(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    boolean _result = this.setWifiEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    int _result = this.getWifiEnabledState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    String _result = this.getCountryCode();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.is5GHzBandSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.is6GHzBandSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.isWifiStandardSupported(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    DhcpInfo _result = this.getDhcpInfo();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setScanAlwaysAvailable(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 38: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isScanAlwaysAvailable();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 39: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    WorkSource _arg3 = 0 != data.readInt() ? WorkSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.acquireWifiLock(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 40: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    WorkSource _arg1 = 0 != data.readInt() ? WorkSource.CREATOR.createFromParcel(data) : null;
                    this.updateWifiLockWorkSource(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 41: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _result = this.releaseWifiLock(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 42: {
                    data.enforceInterface(descriptor);
                    this.initializeMulticastFiltering();
                    reply.writeNoException();
                    return true;
                }
                case 43: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isMulticastEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 44: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    this.acquireMulticastLock(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 45: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.releaseMulticastLock(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 46: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.updateInterfaceIpState(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 47: {
                    data.enforceInterface(descriptor);
                    WifiConfiguration _arg0 = 0 != data.readInt() ? WifiConfiguration.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.startSoftAp(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 48: {
                    data.enforceInterface(descriptor);
                    SoftApConfiguration _arg0 = 0 != data.readInt() ? SoftApConfiguration.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.startTetheredHotspot(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 49: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.stopSoftAp();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 50: {
                    data.enforceInterface(descriptor);
                    ILocalOnlyHotspotCallback _arg0 = ILocalOnlyHotspotCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    SoftApConfiguration _arg3 = 0 != data.readInt() ? SoftApConfiguration.CREATOR.createFromParcel(data) : null;
                    int _result = this.startLocalOnlyHotspot(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 51: {
                    data.enforceInterface(descriptor);
                    this.stopLocalOnlyHotspot();
                    reply.writeNoException();
                    return true;
                }
                case 52: {
                    data.enforceInterface(descriptor);
                    ILocalOnlyHotspotCallback _arg0 = ILocalOnlyHotspotCallback.Stub.asInterface(data.readStrongBinder());
                    this.startWatchLocalOnlyHotspot(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 53: {
                    data.enforceInterface(descriptor);
                    this.stopWatchLocalOnlyHotspot();
                    reply.writeNoException();
                    return true;
                }
                case 54: {
                    data.enforceInterface(descriptor);
                    int _result = this.getWifiApEnabledState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 55: {
                    data.enforceInterface(descriptor);
                    WifiConfiguration _result = this.getWifiApConfiguration();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 56: {
                    data.enforceInterface(descriptor);
                    SoftApConfiguration _result = this.getSoftApConfiguration();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 57: {
                    data.enforceInterface(descriptor);
                    WifiConfiguration _arg0 = 0 != data.readInt() ? WifiConfiguration.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    boolean _result = this.setWifiApConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 58: {
                    data.enforceInterface(descriptor);
                    SoftApConfiguration _arg0 = 0 != data.readInt() ? SoftApConfiguration.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    boolean _result = this.setSoftApConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 59: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.notifyUserOfApBandConversion(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 60: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.enableTdls(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 61: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.enableTdlsWithMacAddress(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 62: {
                    data.enforceInterface(descriptor);
                    String _result = this.getCurrentNetworkWpsNfcConfigurationToken();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 63: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.enableVerboseLogging(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 64: {
                    data.enforceInterface(descriptor);
                    int _result = this.getVerboseLoggingLevel();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 65: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.disableEphemeralNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 66: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.factoryReset(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 67: {
                    data.enforceInterface(descriptor);
                    Network _result = this.getCurrentNetwork();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 68: {
                    data.enforceInterface(descriptor);
                    byte[] _result = this.retrieveBackupData();
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 69: {
                    data.enforceInterface(descriptor);
                    byte[] _arg0 = data.createByteArray();
                    this.restoreBackupData(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 70: {
                    data.enforceInterface(descriptor);
                    byte[] _result = this.retrieveSoftApBackupData();
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 71: {
                    data.enforceInterface(descriptor);
                    byte[] _arg0 = data.createByteArray();
                    SoftApConfiguration _result = this.restoreSoftApBackupData(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 72: {
                    data.enforceInterface(descriptor);
                    byte[] _arg0 = data.createByteArray();
                    byte[] _arg1 = data.createByteArray();
                    this.restoreSupplicantBackupData(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 73: {
                    data.enforceInterface(descriptor);
                    OsuProvider _arg0 = 0 != data.readInt() ? OsuProvider.CREATOR.createFromParcel(data) : null;
                    IProvisioningCallback _arg1 = IProvisioningCallback.Stub.asInterface(data.readStrongBinder());
                    this.startSubscriptionProvisioning(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 74: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    ISoftApCallback _arg1 = ISoftApCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    this.registerSoftApCallback(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 75: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.unregisterSoftApCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 76: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    IOnWifiUsabilityStatsListener _arg1 = IOnWifiUsabilityStatsListener.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    this.addOnWifiUsabilityStatsListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 77: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.removeOnWifiUsabilityStatsListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 78: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    ITrafficStateCallback _arg1 = ITrafficStateCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    this.registerTrafficStateCallback(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 79: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.unregisterTrafficStateCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 80: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    INetworkRequestMatchCallback _arg1 = INetworkRequestMatchCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    this.registerNetworkRequestMatchCallback(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 81: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.unregisterNetworkRequestMatchCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 82: {
                    data.enforceInterface(descriptor);
                    ArrayList<WifiNetworkSuggestion> _arg0 = data.createTypedArrayList(WifiNetworkSuggestion.CREATOR);
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _result = this.addNetworkSuggestions(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 83: {
                    data.enforceInterface(descriptor);
                    ArrayList<WifiNetworkSuggestion> _arg0 = data.createTypedArrayList(WifiNetworkSuggestion.CREATOR);
                    String _arg1 = data.readString();
                    int _result = this.removeNetworkSuggestions(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 84: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    List<WifiNetworkSuggestion> _result = this.getNetworkSuggestions(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 85: {
                    data.enforceInterface(descriptor);
                    String[] _result = this.getFactoryMacAddresses();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 86: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.setDeviceMobilityState(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 87: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    IDppCallback _arg4 = IDppCallback.Stub.asInterface(data.readStrongBinder());
                    this.startDppAsConfiguratorInitiator(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 88: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    IDppCallback _arg2 = IDppCallback.Stub.asInterface(data.readStrongBinder());
                    this.startDppAsEnrolleeInitiator(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 89: {
                    data.enforceInterface(descriptor);
                    this.stopDppSession();
                    reply.writeNoException();
                    return true;
                }
                case 90: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.updateWifiUsabilityScore(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 91: {
                    data.enforceInterface(descriptor);
                    WifiConfiguration _arg0 = 0 != data.readInt() ? WifiConfiguration.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    IBinder _arg2 = data.readStrongBinder();
                    IActionListener _arg3 = IActionListener.Stub.asInterface(data.readStrongBinder());
                    int _arg4 = data.readInt();
                    this.connect(_arg0, _arg1, _arg2, _arg3, _arg4);
                    return true;
                }
                case 92: {
                    data.enforceInterface(descriptor);
                    WifiConfiguration _arg0 = 0 != data.readInt() ? WifiConfiguration.CREATOR.createFromParcel(data) : null;
                    IBinder _arg1 = data.readStrongBinder();
                    IActionListener _arg2 = IActionListener.Stub.asInterface(data.readStrongBinder());
                    int _arg3 = data.readInt();
                    this.save(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 93: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    IActionListener _arg2 = IActionListener.Stub.asInterface(data.readStrongBinder());
                    int _arg3 = data.readInt();
                    this.forget(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 94: {
                    data.enforceInterface(descriptor);
                    IScanResultsCallback _arg0 = IScanResultsCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerScanResultsCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 95: {
                    data.enforceInterface(descriptor);
                    IScanResultsCallback _arg0 = IScanResultsCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterScanResultsCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 96: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    ISuggestionConnectionStatusListener _arg1 = ISuggestionConnectionStatusListener.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    this.registerSuggestionConnectionStatusListener(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 97: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.unregisterSuggestionConnectionStatusListener(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 98: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.calculateSignalLevel(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 99: {
                    data.enforceInterface(descriptor);
                    ArrayList<ScanResult> _arg0 = data.createTypedArrayList(ScanResult.CREATOR);
                    List<WifiConfiguration> _result = this.getWifiConfigForMatchedNetworkSuggestionsSharedWithUser(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 100: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    IWifiConnectedNetworkScorer _arg1 = IWifiConnectedNetworkScorer.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.setWifiConnectedNetworkScorer(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 101: {
                    data.enforceInterface(descriptor);
                    this.clearWifiConnectedNetworkScorer();
                    reply.writeNoException();
                    return true;
                }
                case 102: {
                    data.enforceInterface(descriptor);
                    ArrayList<WifiNetworkSuggestion> _arg0 = data.createTypedArrayList(WifiNetworkSuggestion.CREATOR);
                    ArrayList<ScanResult> _arg1 = data.createTypedArrayList(ScanResult.CREATOR);
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    Map _result = this.getMatchingScanResults(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    return true;
                }
                case 103: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setScanThrottleEnabled(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 104: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isScanThrottleEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 105: {
                    data.enforceInterface(descriptor);
                    ArrayList<ScanResult> _arg0 = data.createTypedArrayList(ScanResult.CREATOR);
                    Map _result = this.getAllMatchingPasspointProfilesForScanResults(_arg0);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    return true;
                }
                case 106: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setAutoWakeupEnabled(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 107: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isAutoWakeupEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IWifiManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IWifiManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IWifiManager {
            private IBinder mRemote;
            public static IWifiManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getSupportedFeatures() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        long l = Stub.getDefaultImpl().getSupportedFeatures();
                        return l;
                    }
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getWifiActivityEnergyInfoAsync(IOnWifiActivityEnergyInfoListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getWifiActivityEnergyInfoAsync(listener);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getConfiguredNetworks(String packageName, String featureId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().getConfiguredNetworks(packageName, featureId);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getPrivilegedConfiguredNetworks(String packageName, String featureId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().getPrivilegedConfiguredNetworks(packageName, featureId);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getAllMatchingFqdnsForScanResults(List<ScanResult> scanResult) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(scanResult);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Map map = Stub.getDefaultImpl().getAllMatchingFqdnsForScanResults(scanResult);
                        return map;
                    }
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getMatchingOsuProviders(List<ScanResult> scanResult) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(scanResult);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Map map = Stub.getDefaultImpl().getMatchingOsuProviders(scanResult);
                        return map;
                    }
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getMatchingPasspointConfigsForOsuProviders(List<OsuProvider> osuProviders) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(osuProviders);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Map map = Stub.getDefaultImpl().getMatchingPasspointConfigsForOsuProviders(osuProviders);
                        return map;
                    }
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addOrUpdateNetwork(WifiConfiguration config, String packageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().addOrUpdateNetwork(config, packageName);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean addOrUpdatePasspointConfiguration(PasspointConfiguration config, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().addOrUpdatePasspointConfiguration(config, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removePasspointConfiguration(String fqdn, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fqdn);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().removePasspointConfiguration(fqdn, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PasspointConfiguration> getPasspointConfigurations(String packageName) throws RemoteException {
                ArrayList<PasspointConfiguration> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<PasspointConfiguration> list = Stub.getDefaultImpl().getPasspointConfigurations(packageName);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(PasspointConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<WifiConfiguration> getWifiConfigsForPasspointProfiles(List<String> fqdnList) throws RemoteException {
                ArrayList<WifiConfiguration> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringList(fqdnList);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<WifiConfiguration> list = Stub.getDefaultImpl().getWifiConfigsForPasspointProfiles(fqdnList);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(WifiConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void queryPasspointIcon(long bssid, String fileName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(bssid);
                    _data.writeString(fileName);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().queryPasspointIcon(bssid, fileName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int matchProviderWithCurrentNetwork(String fqdn) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fqdn);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().matchProviderWithCurrentNetwork(fqdn);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deauthenticateNetwork(long holdoff, boolean ess) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(holdoff);
                    _data.writeInt(ess ? 1 : 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().deauthenticateNetwork(holdoff, ess);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeNetwork(int netId, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().removeNetwork(netId, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enableNetwork(int netId, boolean disableOthers, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    _data.writeInt(disableOthers ? 1 : 0);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().enableNetwork(netId, disableOthers, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean disableNetwork(int netId, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().disableNetwork(netId, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void allowAutojoinGlobal(boolean choice) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(choice ? 1 : 0);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().allowAutojoinGlobal(choice);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void allowAutojoin(int netId, boolean choice) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    _data.writeInt(choice ? 1 : 0);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().allowAutojoin(netId, choice);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void allowAutojoinPasspoint(String fqdn, boolean enableAutoJoin) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fqdn);
                    _data.writeInt(enableAutoJoin ? 1 : 0);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().allowAutojoinPasspoint(fqdn, enableAutoJoin);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMacRandomizationSettingPasspointEnabled(String fqdn, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fqdn);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setMacRandomizationSettingPasspointEnabled(fqdn, enable);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPasspointMeteredOverride(String fqdn, int meteredOverride) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fqdn);
                    _data.writeInt(meteredOverride);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setPasspointMeteredOverride(fqdn, meteredOverride);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startScan(String packageName, String featureId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().startScan(packageName, featureId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ScanResult> getScanResults(String callingPackage, String callingFeatureId) throws RemoteException {
                ArrayList<ScanResult> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<ScanResult> list = Stub.getDefaultImpl().getScanResults(callingPackage, callingFeatureId);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ScanResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean disconnect(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().disconnect(packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean reconnect(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().reconnect(packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean reassociate(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().reassociate(packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WifiInfo getConnectionInfo(String callingPackage, String callingFeatureId) throws RemoteException {
                WifiInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        WifiInfo wifiInfo = Stub.getDefaultImpl().getConnectionInfo(callingPackage, callingFeatureId);
                        return wifiInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? WifiInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setWifiEnabled(String packageName, boolean enable) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setWifiEnabled(packageName, enable);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getWifiEnabledState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getWifiEnabledState();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getCountryCode() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getCountryCode();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean is5GHzBandSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().is5GHzBandSupported();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean is6GHzBandSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().is6GHzBandSupported();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isWifiStandardSupported(int standard) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(standard);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isWifiStandardSupported(standard);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DhcpInfo getDhcpInfo() throws RemoteException {
                DhcpInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        DhcpInfo dhcpInfo = Stub.getDefaultImpl().getDhcpInfo();
                        return dhcpInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? DhcpInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setScanAlwaysAvailable(boolean isAvailable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(isAvailable ? 1 : 0);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setScanAlwaysAvailable(isAvailable);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isScanAlwaysAvailable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isScanAlwaysAvailable();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean acquireWifiLock(IBinder lock, int lockType, String tag, WorkSource ws) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeInt(lockType);
                    _data.writeString(tag);
                    if (ws != null) {
                        _data.writeInt(1);
                        ws.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().acquireWifiLock(lock, lockType, tag, ws);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateWifiLockWorkSource(IBinder lock, WorkSource ws) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    if (ws != null) {
                        _data.writeInt(1);
                        ws.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateWifiLockWorkSource(lock, ws);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean releaseWifiLock(IBinder lock) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().releaseWifiLock(lock);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initializeMulticastFiltering() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().initializeMulticastFiltering();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMulticastEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isMulticastEnabled();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acquireMulticastLock(IBinder binder, String tag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeString(tag);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().acquireMulticastLock(binder, tag);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseMulticastLock(String tag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(tag);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().releaseMulticastLock(tag);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateInterfaceIpState(String ifaceName, int mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(ifaceName);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateInterfaceIpState(ifaceName, mode);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startSoftAp(WifiConfiguration wifiConfig) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (wifiConfig != null) {
                        _data.writeInt(1);
                        wifiConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().startSoftAp(wifiConfig);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startTetheredHotspot(SoftApConfiguration softApConfig) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (softApConfig != null) {
                        _data.writeInt(1);
                        softApConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().startTetheredHotspot(softApConfig);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean stopSoftAp() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().stopSoftAp();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int startLocalOnlyHotspot(ILocalOnlyHotspotCallback callback, String packageName, String featureId, SoftApConfiguration customConfig) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    if (customConfig != null) {
                        _data.writeInt(1);
                        customConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().startLocalOnlyHotspot(callback, packageName, featureId, customConfig);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopLocalOnlyHotspot() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopLocalOnlyHotspot();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startWatchLocalOnlyHotspot(ILocalOnlyHotspotCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startWatchLocalOnlyHotspot(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopWatchLocalOnlyHotspot() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopWatchLocalOnlyHotspot();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getWifiApEnabledState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getWifiApEnabledState();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WifiConfiguration getWifiApConfiguration() throws RemoteException {
                WifiConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        WifiConfiguration wifiConfiguration = Stub.getDefaultImpl().getWifiApConfiguration();
                        return wifiConfiguration;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? WifiConfiguration.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SoftApConfiguration getSoftApConfiguration() throws RemoteException {
                SoftApConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        SoftApConfiguration softApConfiguration = Stub.getDefaultImpl().getSoftApConfiguration();
                        return softApConfiguration;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? SoftApConfiguration.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setWifiApConfiguration(WifiConfiguration wifiConfig, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (wifiConfig != null) {
                        _data.writeInt(1);
                        wifiConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setWifiApConfiguration(wifiConfig, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setSoftApConfiguration(SoftApConfiguration softApConfig, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (softApConfig != null) {
                        _data.writeInt(1);
                        softApConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setSoftApConfiguration(softApConfig, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyUserOfApBandConversion(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyUserOfApBandConversion(packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableTdls(String remoteIPAddress, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(remoteIPAddress);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().enableTdls(remoteIPAddress, enable);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableTdlsWithMacAddress(String remoteMacAddress, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(remoteMacAddress);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().enableTdlsWithMacAddress(remoteMacAddress, enable);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getCurrentNetworkWpsNfcConfigurationToken() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getCurrentNetworkWpsNfcConfigurationToken();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableVerboseLogging(int verbose) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(verbose);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().enableVerboseLogging(verbose);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getVerboseLoggingLevel() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getVerboseLoggingLevel();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableEphemeralNetwork(String SSID, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(SSID);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().disableEphemeralNetwork(SSID, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void factoryReset(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().factoryReset(packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Network getCurrentNetwork() throws RemoteException {
                Network _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Network network = Stub.getDefaultImpl().getCurrentNetwork();
                        return network;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Network.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] retrieveBackupData() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(68, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        byte[] byArray = Stub.getDefaultImpl().retrieveBackupData();
                        return byArray;
                    }
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restoreBackupData(byte[] data) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(data);
                    boolean _status = this.mRemote.transact(69, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().restoreBackupData(data);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] retrieveSoftApBackupData() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        byte[] byArray = Stub.getDefaultImpl().retrieveSoftApBackupData();
                        return byArray;
                    }
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SoftApConfiguration restoreSoftApBackupData(byte[] data) throws RemoteException {
                SoftApConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(data);
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        SoftApConfiguration softApConfiguration = Stub.getDefaultImpl().restoreSoftApBackupData(data);
                        return softApConfiguration;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? SoftApConfiguration.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restoreSupplicantBackupData(byte[] supplicantData, byte[] ipConfigData) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(supplicantData);
                    _data.writeByteArray(ipConfigData);
                    boolean _status = this.mRemote.transact(72, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().restoreSupplicantBackupData(supplicantData, ipConfigData);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startSubscriptionProvisioning(OsuProvider provider, IProvisioningCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (provider != null) {
                        _data.writeInt(1);
                        provider.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(73, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startSubscriptionProvisioning(provider, callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSoftApCallback(IBinder binder, ISoftApCallback callback, int callbackIdentifier) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeInt(callbackIdentifier);
                    boolean _status = this.mRemote.transact(74, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerSoftApCallback(binder, callback, callbackIdentifier);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSoftApCallback(int callbackIdentifier) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(callbackIdentifier);
                    boolean _status = this.mRemote.transact(75, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterSoftApCallback(callbackIdentifier);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnWifiUsabilityStatsListener(IBinder binder, IOnWifiUsabilityStatsListener listener, int listenerIdentifier) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeInt(listenerIdentifier);
                    boolean _status = this.mRemote.transact(76, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addOnWifiUsabilityStatsListener(binder, listener, listenerIdentifier);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnWifiUsabilityStatsListener(int listenerIdentifier) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(listenerIdentifier);
                    boolean _status = this.mRemote.transact(77, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeOnWifiUsabilityStatsListener(listenerIdentifier);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerTrafficStateCallback(IBinder binder, ITrafficStateCallback callback, int callbackIdentifier) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeInt(callbackIdentifier);
                    boolean _status = this.mRemote.transact(78, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerTrafficStateCallback(binder, callback, callbackIdentifier);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterTrafficStateCallback(int callbackIdentifier) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(callbackIdentifier);
                    boolean _status = this.mRemote.transact(79, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterTrafficStateCallback(callbackIdentifier);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerNetworkRequestMatchCallback(IBinder binder, INetworkRequestMatchCallback callback, int callbackIdentifier) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeInt(callbackIdentifier);
                    boolean _status = this.mRemote.transact(80, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerNetworkRequestMatchCallback(binder, callback, callbackIdentifier);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterNetworkRequestMatchCallback(int callbackIdentifier) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(callbackIdentifier);
                    boolean _status = this.mRemote.transact(81, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterNetworkRequestMatchCallback(callbackIdentifier);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addNetworkSuggestions(List<WifiNetworkSuggestion> networkSuggestions, String packageName, String featureId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(networkSuggestions);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(82, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().addNetworkSuggestions(networkSuggestions, packageName, featureId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeNetworkSuggestions(List<WifiNetworkSuggestion> networkSuggestions, String packageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(networkSuggestions);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(83, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().removeNetworkSuggestions(networkSuggestions, packageName);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<WifiNetworkSuggestion> getNetworkSuggestions(String packageName) throws RemoteException {
                ArrayList<WifiNetworkSuggestion> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(84, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<WifiNetworkSuggestion> list = Stub.getDefaultImpl().getNetworkSuggestions(packageName);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(WifiNetworkSuggestion.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getFactoryMacAddresses() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(85, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().getFactoryMacAddresses();
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDeviceMobilityState(int state) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(state);
                    boolean _status = this.mRemote.transact(86, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDeviceMobilityState(state);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startDppAsConfiguratorInitiator(IBinder binder, String enrolleeUri, int selectedNetworkId, int netRole, IDppCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeString(enrolleeUri);
                    _data.writeInt(selectedNetworkId);
                    _data.writeInt(netRole);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(87, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startDppAsConfiguratorInitiator(binder, enrolleeUri, selectedNetworkId, netRole, callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startDppAsEnrolleeInitiator(IBinder binder, String configuratorUri, IDppCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeString(configuratorUri);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(88, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startDppAsEnrolleeInitiator(binder, configuratorUri, callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopDppSession() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(89, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopDppSession();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateWifiUsabilityScore(int seqNum, int score, int predictionHorizonSec) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(seqNum);
                    _data.writeInt(score);
                    _data.writeInt(predictionHorizonSec);
                    boolean _status = this.mRemote.transact(90, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateWifiUsabilityScore(seqNum, score, predictionHorizonSec);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connect(WifiConfiguration config, int netId, IBinder binder, IActionListener listener, int callbackIdentifier) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(netId);
                    _data.writeStrongBinder(binder);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeInt(callbackIdentifier);
                    boolean _status = this.mRemote.transact(91, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().connect(config, netId, binder, listener, callbackIdentifier);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void save(WifiConfiguration config, IBinder binder, IActionListener listener, int callbackIdentifier) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(binder);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeInt(callbackIdentifier);
                    boolean _status = this.mRemote.transact(92, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().save(config, binder, listener, callbackIdentifier);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forget(int netId, IBinder binder, IActionListener listener, int callbackIdentifier) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    _data.writeStrongBinder(binder);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeInt(callbackIdentifier);
                    boolean _status = this.mRemote.transact(93, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().forget(netId, binder, listener, callbackIdentifier);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerScanResultsCallback(IScanResultsCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(94, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerScanResultsCallback(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterScanResultsCallback(IScanResultsCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(95, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterScanResultsCallback(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSuggestionConnectionStatusListener(IBinder binder, ISuggestionConnectionStatusListener listener, int listenerIdentifier, String packageName, String featureId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeInt(listenerIdentifier);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(96, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerSuggestionConnectionStatusListener(binder, listener, listenerIdentifier, packageName, featureId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSuggestionConnectionStatusListener(int listenerIdentifier, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(listenerIdentifier);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(97, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterSuggestionConnectionStatusListener(listenerIdentifier, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int calculateSignalLevel(int rssi) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(rssi);
                    boolean _status = this.mRemote.transact(98, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().calculateSignalLevel(rssi);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<WifiConfiguration> getWifiConfigForMatchedNetworkSuggestionsSharedWithUser(List<ScanResult> scanResults) throws RemoteException {
                ArrayList<WifiConfiguration> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(scanResults);
                    boolean _status = this.mRemote.transact(99, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<WifiConfiguration> list = Stub.getDefaultImpl().getWifiConfigForMatchedNetworkSuggestionsSharedWithUser(scanResults);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(WifiConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setWifiConnectedNetworkScorer(IBinder binder, IWifiConnectedNetworkScorer scorer) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeStrongBinder(scorer != null ? scorer.asBinder() : null);
                    boolean _status = this.mRemote.transact(100, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setWifiConnectedNetworkScorer(binder, scorer);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearWifiConnectedNetworkScorer() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(101, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clearWifiConnectedNetworkScorer();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getMatchingScanResults(List<WifiNetworkSuggestion> networkSuggestions, List<ScanResult> scanResults, String callingPackage, String callingFeatureId) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(networkSuggestions);
                    _data.writeTypedList(scanResults);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(102, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Map map = Stub.getDefaultImpl().getMatchingScanResults(networkSuggestions, scanResults, callingPackage, callingFeatureId);
                        return map;
                    }
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setScanThrottleEnabled(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(103, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setScanThrottleEnabled(enable);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isScanThrottleEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(104, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isScanThrottleEnabled();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getAllMatchingPasspointProfilesForScanResults(List<ScanResult> scanResult) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(scanResult);
                    boolean _status = this.mRemote.transact(105, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Map map = Stub.getDefaultImpl().getAllMatchingPasspointProfilesForScanResults(scanResult);
                        return map;
                    }
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAutoWakeupEnabled(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(106, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setAutoWakeupEnabled(enable);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAutoWakeupEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(107, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isAutoWakeupEnabled();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IWifiManager {
        @Override
        public long getSupportedFeatures() throws RemoteException {
            return 0L;
        }

        @Override
        public void getWifiActivityEnergyInfoAsync(IOnWifiActivityEnergyInfoListener listener) throws RemoteException {
        }

        @Override
        public ParceledListSlice getConfiguredNetworks(String packageName, String featureId) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getPrivilegedConfiguredNetworks(String packageName, String featureId) throws RemoteException {
            return null;
        }

        @Override
        public Map getAllMatchingFqdnsForScanResults(List<ScanResult> scanResult) throws RemoteException {
            return null;
        }

        @Override
        public Map getMatchingOsuProviders(List<ScanResult> scanResult) throws RemoteException {
            return null;
        }

        @Override
        public Map getMatchingPasspointConfigsForOsuProviders(List<OsuProvider> osuProviders) throws RemoteException {
            return null;
        }

        @Override
        public int addOrUpdateNetwork(WifiConfiguration config, String packageName) throws RemoteException {
            return 0;
        }

        @Override
        public boolean addOrUpdatePasspointConfiguration(PasspointConfiguration config, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean removePasspointConfiguration(String fqdn, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public List<PasspointConfiguration> getPasspointConfigurations(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public List<WifiConfiguration> getWifiConfigsForPasspointProfiles(List<String> fqdnList) throws RemoteException {
            return null;
        }

        @Override
        public void queryPasspointIcon(long bssid, String fileName) throws RemoteException {
        }

        @Override
        public int matchProviderWithCurrentNetwork(String fqdn) throws RemoteException {
            return 0;
        }

        @Override
        public void deauthenticateNetwork(long holdoff, boolean ess) throws RemoteException {
        }

        @Override
        public boolean removeNetwork(int netId, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean enableNetwork(int netId, boolean disableOthers, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean disableNetwork(int netId, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public void allowAutojoinGlobal(boolean choice) throws RemoteException {
        }

        @Override
        public void allowAutojoin(int netId, boolean choice) throws RemoteException {
        }

        @Override
        public void allowAutojoinPasspoint(String fqdn, boolean enableAutoJoin) throws RemoteException {
        }

        @Override
        public void setMacRandomizationSettingPasspointEnabled(String fqdn, boolean enable) throws RemoteException {
        }

        @Override
        public void setPasspointMeteredOverride(String fqdn, int meteredOverride) throws RemoteException {
        }

        @Override
        public boolean startScan(String packageName, String featureId) throws RemoteException {
            return false;
        }

        @Override
        public List<ScanResult> getScanResults(String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public boolean disconnect(String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean reconnect(String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean reassociate(String packageName) throws RemoteException {
            return false;
        }

        @Override
        public WifiInfo getConnectionInfo(String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public boolean setWifiEnabled(String packageName, boolean enable) throws RemoteException {
            return false;
        }

        @Override
        public int getWifiEnabledState() throws RemoteException {
            return 0;
        }

        @Override
        public String getCountryCode() throws RemoteException {
            return null;
        }

        @Override
        public boolean is5GHzBandSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean is6GHzBandSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isWifiStandardSupported(int standard) throws RemoteException {
            return false;
        }

        @Override
        public DhcpInfo getDhcpInfo() throws RemoteException {
            return null;
        }

        @Override
        public void setScanAlwaysAvailable(boolean isAvailable) throws RemoteException {
        }

        @Override
        public boolean isScanAlwaysAvailable() throws RemoteException {
            return false;
        }

        @Override
        public boolean acquireWifiLock(IBinder lock, int lockType, String tag, WorkSource ws) throws RemoteException {
            return false;
        }

        @Override
        public void updateWifiLockWorkSource(IBinder lock, WorkSource ws) throws RemoteException {
        }

        @Override
        public boolean releaseWifiLock(IBinder lock) throws RemoteException {
            return false;
        }

        @Override
        public void initializeMulticastFiltering() throws RemoteException {
        }

        @Override
        public boolean isMulticastEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void acquireMulticastLock(IBinder binder, String tag) throws RemoteException {
        }

        @Override
        public void releaseMulticastLock(String tag) throws RemoteException {
        }

        @Override
        public void updateInterfaceIpState(String ifaceName, int mode) throws RemoteException {
        }

        @Override
        public boolean startSoftAp(WifiConfiguration wifiConfig) throws RemoteException {
            return false;
        }

        @Override
        public boolean startTetheredHotspot(SoftApConfiguration softApConfig) throws RemoteException {
            return false;
        }

        @Override
        public boolean stopSoftAp() throws RemoteException {
            return false;
        }

        @Override
        public int startLocalOnlyHotspot(ILocalOnlyHotspotCallback callback, String packageName, String featureId, SoftApConfiguration customConfig) throws RemoteException {
            return 0;
        }

        @Override
        public void stopLocalOnlyHotspot() throws RemoteException {
        }

        @Override
        public void startWatchLocalOnlyHotspot(ILocalOnlyHotspotCallback callback) throws RemoteException {
        }

        @Override
        public void stopWatchLocalOnlyHotspot() throws RemoteException {
        }

        @Override
        public int getWifiApEnabledState() throws RemoteException {
            return 0;
        }

        @Override
        public WifiConfiguration getWifiApConfiguration() throws RemoteException {
            return null;
        }

        @Override
        public SoftApConfiguration getSoftApConfiguration() throws RemoteException {
            return null;
        }

        @Override
        public boolean setWifiApConfiguration(WifiConfiguration wifiConfig, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean setSoftApConfiguration(SoftApConfiguration softApConfig, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public void notifyUserOfApBandConversion(String packageName) throws RemoteException {
        }

        @Override
        public void enableTdls(String remoteIPAddress, boolean enable) throws RemoteException {
        }

        @Override
        public void enableTdlsWithMacAddress(String remoteMacAddress, boolean enable) throws RemoteException {
        }

        @Override
        public String getCurrentNetworkWpsNfcConfigurationToken() throws RemoteException {
            return null;
        }

        @Override
        public void enableVerboseLogging(int verbose) throws RemoteException {
        }

        @Override
        public int getVerboseLoggingLevel() throws RemoteException {
            return 0;
        }

        @Override
        public void disableEphemeralNetwork(String SSID, String packageName) throws RemoteException {
        }

        @Override
        public void factoryReset(String packageName) throws RemoteException {
        }

        @Override
        public Network getCurrentNetwork() throws RemoteException {
            return null;
        }

        @Override
        public byte[] retrieveBackupData() throws RemoteException {
            return null;
        }

        @Override
        public void restoreBackupData(byte[] data) throws RemoteException {
        }

        @Override
        public byte[] retrieveSoftApBackupData() throws RemoteException {
            return null;
        }

        @Override
        public SoftApConfiguration restoreSoftApBackupData(byte[] data) throws RemoteException {
            return null;
        }

        @Override
        public void restoreSupplicantBackupData(byte[] supplicantData, byte[] ipConfigData) throws RemoteException {
        }

        @Override
        public void startSubscriptionProvisioning(OsuProvider provider, IProvisioningCallback callback) throws RemoteException {
        }

        @Override
        public void registerSoftApCallback(IBinder binder, ISoftApCallback callback, int callbackIdentifier) throws RemoteException {
        }

        @Override
        public void unregisterSoftApCallback(int callbackIdentifier) throws RemoteException {
        }

        @Override
        public void addOnWifiUsabilityStatsListener(IBinder binder, IOnWifiUsabilityStatsListener listener, int listenerIdentifier) throws RemoteException {
        }

        @Override
        public void removeOnWifiUsabilityStatsListener(int listenerIdentifier) throws RemoteException {
        }

        @Override
        public void registerTrafficStateCallback(IBinder binder, ITrafficStateCallback callback, int callbackIdentifier) throws RemoteException {
        }

        @Override
        public void unregisterTrafficStateCallback(int callbackIdentifier) throws RemoteException {
        }

        @Override
        public void registerNetworkRequestMatchCallback(IBinder binder, INetworkRequestMatchCallback callback, int callbackIdentifier) throws RemoteException {
        }

        @Override
        public void unregisterNetworkRequestMatchCallback(int callbackIdentifier) throws RemoteException {
        }

        @Override
        public int addNetworkSuggestions(List<WifiNetworkSuggestion> networkSuggestions, String packageName, String featureId) throws RemoteException {
            return 0;
        }

        @Override
        public int removeNetworkSuggestions(List<WifiNetworkSuggestion> networkSuggestions, String packageName) throws RemoteException {
            return 0;
        }

        @Override
        public List<WifiNetworkSuggestion> getNetworkSuggestions(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public String[] getFactoryMacAddresses() throws RemoteException {
            return null;
        }

        @Override
        public void setDeviceMobilityState(int state) throws RemoteException {
        }

        @Override
        public void startDppAsConfiguratorInitiator(IBinder binder, String enrolleeUri, int selectedNetworkId, int netRole, IDppCallback callback) throws RemoteException {
        }

        @Override
        public void startDppAsEnrolleeInitiator(IBinder binder, String configuratorUri, IDppCallback callback) throws RemoteException {
        }

        @Override
        public void stopDppSession() throws RemoteException {
        }

        @Override
        public void updateWifiUsabilityScore(int seqNum, int score, int predictionHorizonSec) throws RemoteException {
        }

        @Override
        public void connect(WifiConfiguration config, int netId, IBinder binder, IActionListener listener, int callbackIdentifier) throws RemoteException {
        }

        @Override
        public void save(WifiConfiguration config, IBinder binder, IActionListener listener, int callbackIdentifier) throws RemoteException {
        }

        @Override
        public void forget(int netId, IBinder binder, IActionListener listener, int callbackIdentifier) throws RemoteException {
        }

        @Override
        public void registerScanResultsCallback(IScanResultsCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterScanResultsCallback(IScanResultsCallback callback) throws RemoteException {
        }

        @Override
        public void registerSuggestionConnectionStatusListener(IBinder binder, ISuggestionConnectionStatusListener listener, int listenerIdentifier, String packageName, String featureId) throws RemoteException {
        }

        @Override
        public void unregisterSuggestionConnectionStatusListener(int listenerIdentifier, String packageName) throws RemoteException {
        }

        @Override
        public int calculateSignalLevel(int rssi) throws RemoteException {
            return 0;
        }

        @Override
        public List<WifiConfiguration> getWifiConfigForMatchedNetworkSuggestionsSharedWithUser(List<ScanResult> scanResults) throws RemoteException {
            return null;
        }

        @Override
        public boolean setWifiConnectedNetworkScorer(IBinder binder, IWifiConnectedNetworkScorer scorer) throws RemoteException {
            return false;
        }

        @Override
        public void clearWifiConnectedNetworkScorer() throws RemoteException {
        }

        @Override
        public Map getMatchingScanResults(List<WifiNetworkSuggestion> networkSuggestions, List<ScanResult> scanResults, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public void setScanThrottleEnabled(boolean enable) throws RemoteException {
        }

        @Override
        public boolean isScanThrottleEnabled() throws RemoteException {
            return false;
        }

        @Override
        public Map getAllMatchingPasspointProfilesForScanResults(List<ScanResult> scanResult) throws RemoteException {
            return null;
        }

        @Override
        public void setAutoWakeupEnabled(boolean enable) throws RemoteException {
        }

        @Override
        public boolean isAutoWakeupEnabled() throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

