/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.Network;
import android.net.TetherStatesParcel;
import android.net.TetheredClient;
import android.net.TetheringCallbackStartedParcel;
import android.net.TetheringConfigurationParcel;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ITetheringEventCallback
extends IInterface {
    public void onCallbackStarted(TetheringCallbackStartedParcel var1) throws RemoteException;

    public void onCallbackStopped(int var1) throws RemoteException;

    public void onUpstreamChanged(Network var1) throws RemoteException;

    public void onConfigurationChanged(TetheringConfigurationParcel var1) throws RemoteException;

    public void onTetherStatesChanged(TetherStatesParcel var1) throws RemoteException;

    public void onTetherClientsChanged(List<TetheredClient> var1) throws RemoteException;

    public void onOffloadStatusChanged(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITetheringEventCallback {
        private static final String DESCRIPTOR = "android.net.ITetheringEventCallback";
        static final int TRANSACTION_onCallbackStarted = 1;
        static final int TRANSACTION_onCallbackStopped = 2;
        static final int TRANSACTION_onUpstreamChanged = 3;
        static final int TRANSACTION_onConfigurationChanged = 4;
        static final int TRANSACTION_onTetherStatesChanged = 5;
        static final int TRANSACTION_onTetherClientsChanged = 6;
        static final int TRANSACTION_onOffloadStatusChanged = 7;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITetheringEventCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITetheringEventCallback) {
                return (ITetheringEventCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onCallbackStarted";
                }
                case 2: {
                    return "onCallbackStopped";
                }
                case 3: {
                    return "onUpstreamChanged";
                }
                case 4: {
                    return "onConfigurationChanged";
                }
                case 5: {
                    return "onTetherStatesChanged";
                }
                case 6: {
                    return "onTetherClientsChanged";
                }
                case 7: {
                    return "onOffloadStatusChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    TetheringCallbackStartedParcel _arg0 = 0 != data.readInt() ? TetheringCallbackStartedParcel.CREATOR.createFromParcel(data) : null;
                    this.onCallbackStarted(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onCallbackStopped(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    Network _arg0 = 0 != data.readInt() ? Network.CREATOR.createFromParcel(data) : null;
                    this.onUpstreamChanged(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    TetheringConfigurationParcel _arg0 = 0 != data.readInt() ? TetheringConfigurationParcel.CREATOR.createFromParcel(data) : null;
                    this.onConfigurationChanged(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    TetherStatesParcel _arg0 = 0 != data.readInt() ? TetherStatesParcel.CREATOR.createFromParcel(data) : null;
                    this.onTetherStatesChanged(_arg0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    ArrayList<TetheredClient> _arg0 = data.createTypedArrayList(TetheredClient.CREATOR);
                    this.onTetherClientsChanged(_arg0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onOffloadStatusChanged(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ITetheringEventCallback impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ITetheringEventCallback getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ITetheringEventCallback {
            private IBinder mRemote;
            public static ITetheringEventCallback sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCallbackStarted(TetheringCallbackStartedParcel parcel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (parcel != null) {
                        _data.writeInt(1);
                        parcel.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCallbackStarted(parcel);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCallbackStopped(int errorCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(errorCode);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCallbackStopped(errorCode);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUpstreamChanged(Network network) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (network != null) {
                        _data.writeInt(1);
                        network.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onUpstreamChanged(network);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConfigurationChanged(TetheringConfigurationParcel config) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onConfigurationChanged(config);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTetherStatesChanged(TetherStatesParcel states) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (states != null) {
                        _data.writeInt(1);
                        states.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onTetherStatesChanged(states);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTetherClientsChanged(List<TetheredClient> clients) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(clients);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onTetherClientsChanged(clients);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onOffloadStatusChanged(int status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onOffloadStatusChanged(status);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITetheringEventCallback {
        @Override
        public void onCallbackStarted(TetheringCallbackStartedParcel parcel) throws RemoteException {
        }

        @Override
        public void onCallbackStopped(int errorCode) throws RemoteException {
        }

        @Override
        public void onUpstreamChanged(Network network) throws RemoteException {
        }

        @Override
        public void onConfigurationChanged(TetheringConfigurationParcel config) throws RemoteException {
        }

        @Override
        public void onTetherStatesChanged(TetherStatesParcel states) throws RemoteException {
        }

        @Override
        public void onTetherClientsChanged(List<TetheredClient> clients) throws RemoteException {
        }

        @Override
        public void onOffloadStatusChanged(int status) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

