/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.net.ConnectivityThread;
import android.net.IEthernetManager;
import android.net.IEthernetServiceListener;
import android.net.ITetheredInterfaceCallback;
import android.net.IpConfiguration;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
public class EthernetManager {
    private static final String TAG = "EthernetManager";
    private static final int MSG_AVAILABILITY_CHANGED = 1000;
    private final Context mContext;
    private final IEthernetManager mService;
    private final Handler mHandler = new Handler(ConnectivityThread.getInstanceLooper()){

        @Override
        public void handleMessage(Message msg) {
            if (msg.what == 1000) {
                boolean isAvailable = msg.arg1 == 1;
                for (Listener listener : EthernetManager.this.mListeners) {
                    listener.onAvailabilityChanged((String)msg.obj, isAvailable);
                }
            }
        }
    };
    private final ArrayList<Listener> mListeners = new ArrayList();
    private final IEthernetServiceListener.Stub mServiceListener = new IEthernetServiceListener.Stub(){

        @Override
        public void onAvailabilityChanged(String iface, boolean isAvailable) {
            EthernetManager.this.mHandler.obtainMessage(1000, isAvailable ? 1 : 0, 0, iface).sendToTarget();
        }
    };

    public EthernetManager(Context context, IEthernetManager service) {
        this.mContext = context;
        this.mService = service;
    }

    @UnsupportedAppUsage
    public IpConfiguration getConfiguration(String iface) {
        try {
            return this.mService.getConfiguration(iface);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void setConfiguration(String iface, IpConfiguration config) {
        try {
            this.mService.setConfiguration(iface, config);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public boolean isAvailable() {
        return this.getAvailableInterfaces().length > 0;
    }

    @UnsupportedAppUsage
    public boolean isAvailable(String iface) {
        try {
            return this.mService.isAvailable(iface);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void addListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.mListeners.add(listener);
        if (this.mListeners.size() == 1) {
            try {
                this.mService.addListener(this.mServiceListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @UnsupportedAppUsage
    public String[] getAvailableInterfaces() {
        try {
            return this.mService.getAvailableInterfaces();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @UnsupportedAppUsage
    public void removeListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.mListeners.remove(listener);
        if (this.mListeners.isEmpty()) {
            try {
                this.mService.removeListener(this.mServiceListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void setIncludeTestInterfaces(boolean include) {
        try {
            this.mService.setIncludeTestInterfaces(include);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public TetheredInterfaceRequest requestTetheredInterface(final Executor executor, final TetheredInterfaceCallback callback) {
        Objects.requireNonNull(callback, "Callback must be non-null");
        Objects.requireNonNull(executor, "Executor must be non-null");
        ITetheredInterfaceCallback.Stub cbInternal = new ITetheredInterfaceCallback.Stub(){

            @Override
            public void onAvailable(String iface) {
                executor.execute(() -> callback.onAvailable(iface));
            }

            @Override
            public void onUnavailable() {
                executor.execute(() -> callback.onUnavailable());
            }
        };
        try {
            this.mService.requestTetheredInterface(cbInternal);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return new TetheredInterfaceRequest(this.mService, cbInternal);
    }

    public static interface TetheredInterfaceCallback {
        public void onAvailable(String var1);

        public void onUnavailable();
    }

    public static class TetheredInterfaceRequest {
        private final IEthernetManager mService;
        private final ITetheredInterfaceCallback mCb;

        private TetheredInterfaceRequest(IEthernetManager service, ITetheredInterfaceCallback cb) {
            this.mService = service;
            this.mCb = cb;
        }

        public void release() {
            try {
                this.mService.releaseTetheredInterface(this.mCb);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
    }

    public static interface Listener {
        @UnsupportedAppUsage
        public void onAvailabilityChanged(String var1, boolean var2);
    }
}

