/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.SystemApi;
import android.media.AudioAttributes;
import android.media.IPlayer;
import android.media.PlayerBase;
import android.media.PlayerProxy;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class AudioPlaybackConfiguration
implements Parcelable {
    private static final String TAG = new String("AudioPlaybackConfiguration");
    private static final boolean DEBUG = false;
    public static final int PLAYER_PIID_INVALID = -1;
    public static final int PLAYER_UPID_INVALID = -1;
    @SystemApi
    public static final int PLAYER_TYPE_UNKNOWN = -1;
    @SystemApi
    public static final int PLAYER_TYPE_JAM_AUDIOTRACK = 1;
    @SystemApi
    public static final int PLAYER_TYPE_JAM_MEDIAPLAYER = 2;
    @SystemApi
    public static final int PLAYER_TYPE_JAM_SOUNDPOOL = 3;
    @SystemApi
    public static final int PLAYER_TYPE_SLES_AUDIOPLAYER_BUFFERQUEUE = 11;
    @SystemApi
    public static final int PLAYER_TYPE_SLES_AUDIOPLAYER_URI_FD = 12;
    public static final int PLAYER_TYPE_AAUDIO = 13;
    public static final int PLAYER_TYPE_HW_SOURCE = 14;
    public static final int PLAYER_TYPE_EXTERNAL_PROXY = 15;
    @SystemApi
    public static final int PLAYER_STATE_UNKNOWN = -1;
    @SystemApi
    public static final int PLAYER_STATE_RELEASED = 0;
    @SystemApi
    public static final int PLAYER_STATE_IDLE = 1;
    @SystemApi
    public static final int PLAYER_STATE_STARTED = 2;
    @SystemApi
    public static final int PLAYER_STATE_PAUSED = 3;
    @SystemApi
    public static final int PLAYER_STATE_STOPPED = 4;
    private final int mPlayerIId;
    private int mPlayerType;
    private int mClientUid;
    private int mClientPid;
    private IPlayerShell mIPlayerShell;
    private int mPlayerState;
    private AudioAttributes mPlayerAttr;
    public static PlayerDeathMonitor sPlayerDeathMonitor;
    public static final Parcelable.Creator<AudioPlaybackConfiguration> CREATOR;

    private AudioPlaybackConfiguration(int piid) {
        this.mPlayerIId = piid;
        this.mIPlayerShell = null;
    }

    public AudioPlaybackConfiguration(PlayerBase.PlayerIdCard pic, int piid, int uid, int pid) {
        this.mPlayerIId = piid;
        this.mPlayerType = pic.mPlayerType;
        this.mClientUid = uid;
        this.mClientPid = pid;
        this.mPlayerState = 1;
        this.mPlayerAttr = pic.mAttributes;
        this.mIPlayerShell = sPlayerDeathMonitor != null && pic.mIPlayer != null ? new IPlayerShell(this, pic.mIPlayer) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        AudioPlaybackConfiguration audioPlaybackConfiguration = this;
        synchronized (audioPlaybackConfiguration) {
            if (this.mIPlayerShell != null) {
                this.mIPlayerShell.monitorDeath();
            }
        }
    }

    public static AudioPlaybackConfiguration anonymizedCopy(AudioPlaybackConfiguration in) {
        AudioPlaybackConfiguration anonymCopy = new AudioPlaybackConfiguration(in.mPlayerIId);
        anonymCopy.mPlayerState = in.mPlayerState;
        anonymCopy.mPlayerAttr = new AudioAttributes.Builder().setUsage(in.mPlayerAttr.getUsage()).setContentType(in.mPlayerAttr.getContentType()).setFlags(in.mPlayerAttr.getFlags()).setAllowedCapturePolicy(in.mPlayerAttr.getAllowedCapturePolicy() == 1 ? 1 : 3).build();
        anonymCopy.mPlayerType = -1;
        anonymCopy.mClientUid = -1;
        anonymCopy.mClientPid = -1;
        anonymCopy.mIPlayerShell = null;
        return anonymCopy;
    }

    public AudioAttributes getAudioAttributes() {
        return this.mPlayerAttr;
    }

    @SystemApi
    public int getClientUid() {
        return this.mClientUid;
    }

    @SystemApi
    public int getClientPid() {
        return this.mClientPid;
    }

    @SystemApi
    public int getPlayerType() {
        switch (this.mPlayerType) {
            case 13: 
            case 14: 
            case 15: {
                return -1;
            }
        }
        return this.mPlayerType;
    }

    @SystemApi
    public int getPlayerState() {
        return this.mPlayerState;
    }

    @SystemApi
    public int getPlayerInterfaceId() {
        return this.mPlayerIId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public PlayerProxy getPlayerProxy() {
        IPlayerShell ips;
        AudioPlaybackConfiguration audioPlaybackConfiguration = this;
        synchronized (audioPlaybackConfiguration) {
            ips = this.mIPlayerShell;
        }
        return ips == null ? null : new PlayerProxy(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IPlayer getIPlayer() {
        IPlayerShell ips;
        AudioPlaybackConfiguration audioPlaybackConfiguration = this;
        synchronized (audioPlaybackConfiguration) {
            ips = this.mIPlayerShell;
        }
        return ips == null ? null : ips.getIPlayer();
    }

    public boolean handleAudioAttributesEvent(AudioAttributes attr2) {
        boolean changed = !attr2.equals(this.mPlayerAttr);
        this.mPlayerAttr = attr2;
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleStateEvent(int event) {
        boolean changed;
        AudioPlaybackConfiguration audioPlaybackConfiguration = this;
        synchronized (audioPlaybackConfiguration) {
            changed = this.mPlayerState != event;
            this.mPlayerState = event;
            if (changed && event == 0 && this.mIPlayerShell != null) {
                this.mIPlayerShell.release();
                this.mIPlayerShell = null;
            }
        }
        return changed;
    }

    private void playerDied() {
        if (sPlayerDeathMonitor != null) {
            sPlayerDeathMonitor.playerDeath(this.mPlayerIId);
        }
    }

    @SystemApi
    public boolean isActive() {
        switch (this.mPlayerState) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public void dump(PrintWriter pw) {
        pw.println("  " + this);
    }

    public int hashCode() {
        return Objects.hash(this.mPlayerIId, this.mPlayerType, this.mClientUid, this.mClientPid);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel dest, int flags) {
        IPlayerShell ips;
        dest.writeInt(this.mPlayerIId);
        dest.writeInt(this.mPlayerType);
        dest.writeInt(this.mClientUid);
        dest.writeInt(this.mClientPid);
        dest.writeInt(this.mPlayerState);
        this.mPlayerAttr.writeToParcel(dest, 0);
        AudioPlaybackConfiguration audioPlaybackConfiguration = this;
        synchronized (audioPlaybackConfiguration) {
            ips = this.mIPlayerShell;
        }
        dest.writeStrongInterface(ips == null ? null : ips.getIPlayer());
    }

    private AudioPlaybackConfiguration(Parcel in) {
        this.mPlayerIId = in.readInt();
        this.mPlayerType = in.readInt();
        this.mClientUid = in.readInt();
        this.mClientPid = in.readInt();
        this.mPlayerState = in.readInt();
        this.mPlayerAttr = AudioAttributes.CREATOR.createFromParcel(in);
        IPlayer p = IPlayer.Stub.asInterface(in.readStrongBinder());
        this.mIPlayerShell = p == null ? null : new IPlayerShell(null, p);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof AudioPlaybackConfiguration)) {
            return false;
        }
        AudioPlaybackConfiguration that = (AudioPlaybackConfiguration)o;
        return this.mPlayerIId == that.mPlayerIId && this.mPlayerType == that.mPlayerType && this.mClientUid == that.mClientUid && this.mClientPid == that.mClientPid;
    }

    public String toString() {
        return "AudioPlaybackConfiguration piid:" + this.mPlayerIId + " type:" + AudioPlaybackConfiguration.toLogFriendlyPlayerType(this.mPlayerType) + " u/pid:" + this.mClientUid + "/" + this.mClientPid + " state:" + AudioPlaybackConfiguration.toLogFriendlyPlayerState(this.mPlayerState) + " attr:" + this.mPlayerAttr;
    }

    public static String toLogFriendlyPlayerType(int type) {
        switch (type) {
            case -1: {
                return "unknown";
            }
            case 1: {
                return "android.media.AudioTrack";
            }
            case 2: {
                return "android.media.MediaPlayer";
            }
            case 3: {
                return "android.media.SoundPool";
            }
            case 11: {
                return "OpenSL ES AudioPlayer (Buffer Queue)";
            }
            case 12: {
                return "OpenSL ES AudioPlayer (URI/FD)";
            }
            case 13: {
                return "AAudio";
            }
            case 14: {
                return "hardware source";
            }
            case 15: {
                return "external proxy";
            }
        }
        return "unknown player type " + type + " - FIXME";
    }

    public static String toLogFriendlyPlayerState(int state) {
        switch (state) {
            case -1: {
                return "unknown";
            }
            case 0: {
                return "released";
            }
            case 1: {
                return "idle";
            }
            case 2: {
                return "started";
            }
            case 3: {
                return "paused";
            }
            case 4: {
                return "stopped";
            }
        }
        return "unknown player state - FIXME";
    }

    static {
        CREATOR = new Parcelable.Creator<AudioPlaybackConfiguration>(){

            @Override
            public AudioPlaybackConfiguration createFromParcel(Parcel p) {
                return new AudioPlaybackConfiguration(p);
            }

            public AudioPlaybackConfiguration[] newArray(int size) {
                return new AudioPlaybackConfiguration[size];
            }
        };
    }

    static class IPlayerShell
    implements IBinder.DeathRecipient {
        final AudioPlaybackConfiguration mMonitor;
        private volatile IPlayer mIPlayer;

        IPlayerShell(AudioPlaybackConfiguration monitor, IPlayer iplayer) {
            this.mMonitor = monitor;
            this.mIPlayer = iplayer;
        }

        synchronized void monitorDeath() {
            if (this.mIPlayer == null) {
                return;
            }
            try {
                this.mIPlayer.asBinder().linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                if (this.mMonitor != null) {
                    Log.w(TAG, "Could not link to client death for piid=" + this.mMonitor.mPlayerIId, e);
                }
                Log.w(TAG, "Could not link to client death", e);
            }
        }

        IPlayer getIPlayer() {
            return this.mIPlayer;
        }

        @Override
        public void binderDied() {
            if (this.mMonitor != null) {
                this.mMonitor.playerDied();
            }
        }

        synchronized void release() {
            if (this.mIPlayer == null) {
                return;
            }
            this.mIPlayer.asBinder().unlinkToDeath(this, 0);
            this.mIPlayer = null;
            Binder.flushPendingCommands();
        }
    }

    public static interface PlayerDeathMonitor {
        public void playerDeath(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlayerState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlayerType {
    }
}

