/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.lights;

import android.annotation.SystemApi;
import android.content.Context;
import android.hardware.lights.ILightsManager;
import android.hardware.lights.Light;
import android.hardware.lights.LightState;
import android.hardware.lights.LightsRequest;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.CloseGuard;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.Reference;
import java.util.List;

@SystemApi
public class LightsManager {
    private static final String TAG = "LightsManager";
    public static final int LIGHT_TYPE_MICROPHONE = 8;
    private final Context mContext;
    private final ILightsManager mService;

    public LightsManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this(context, ILightsManager.Stub.asInterface(ServiceManager.getServiceOrThrow("lights")));
    }

    @VisibleForTesting
    public LightsManager(Context context, ILightsManager service) {
        this.mContext = Preconditions.checkNotNull(context);
        this.mService = Preconditions.checkNotNull(service);
    }

    public List<Light> getLights() {
        try {
            return this.mService.getLights();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public LightState getLightState(Light light) {
        Preconditions.checkNotNull(light);
        try {
            return this.mService.getLightState(light.getId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public LightsSession openSession() {
        try {
            LightsSession session = new LightsSession();
            this.mService.openSession(session.mToken);
            return session;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public class LightsSession
    implements AutoCloseable {
        private final IBinder mToken = new Binder();
        private final CloseGuard mCloseGuard = new CloseGuard();
        private boolean mClosed = false;

        private LightsSession() {
            this.mCloseGuard.open("close");
        }

        public void requestLights(LightsRequest request) {
            Preconditions.checkNotNull(request);
            if (!this.mClosed) {
                try {
                    LightsManager.this.mService.setLightStates(this.mToken, request.mLightIds, request.mLightStates);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }

        @Override
        public void close() {
            if (!this.mClosed) {
                try {
                    LightsManager.this.mService.closeSession(this.mToken);
                    this.mClosed = true;
                    this.mCloseGuard.close();
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            Reference.reachabilityFence(this);
        }

        protected void finalize() throws Throwable {
            try {
                this.mCloseGuard.warnIfOpen();
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LightType {
    }
}

