/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.impl.CaptureCallback;
import android.view.Surface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;

public class CaptureCallbackHolder {
    private final boolean mRepeating;
    private final CaptureCallback mCallback;
    private final List<CaptureRequest> mRequestList;
    private final Executor mExecutor;
    private final int mSessionId;
    private final boolean mHasBatchedOutputs;

    CaptureCallbackHolder(CaptureCallback callback, List<CaptureRequest> requestList, Executor executor, boolean repeating, int sessionId) {
        if (callback == null || executor == null) {
            throw new UnsupportedOperationException("Must have a valid handler and a valid callback");
        }
        this.mRepeating = repeating;
        this.mExecutor = executor;
        this.mRequestList = new ArrayList<CaptureRequest>(requestList);
        this.mCallback = callback;
        this.mSessionId = sessionId;
        boolean hasBatchedOutputs = true;
        for (int i = 0; i < requestList.size(); ++i) {
            Collection<Surface> targets;
            CaptureRequest request = requestList.get(i);
            if (!request.isPartOfCRequestList()) {
                hasBatchedOutputs = false;
                break;
            }
            if (i != 0 || (targets = request.getTargets()).size() == 2) continue;
            hasBatchedOutputs = false;
            break;
        }
        this.mHasBatchedOutputs = hasBatchedOutputs;
    }

    public boolean isRepeating() {
        return this.mRepeating;
    }

    public CaptureCallback getCallback() {
        return this.mCallback;
    }

    public CaptureRequest getRequest(int subsequenceId) {
        if (subsequenceId >= this.mRequestList.size()) {
            throw new IllegalArgumentException(String.format("Requested subsequenceId %d is larger than request list size %d.", subsequenceId, this.mRequestList.size()));
        }
        if (subsequenceId < 0) {
            throw new IllegalArgumentException(String.format("Requested subsequenceId %d is negative", subsequenceId));
        }
        return this.mRequestList.get(subsequenceId);
    }

    public CaptureRequest getRequest() {
        return this.getRequest(0);
    }

    public Executor getExecutor() {
        return this.mExecutor;
    }

    public int getSessionId() {
        return this.mSessionId;
    }

    public int getRequestCount() {
        return this.mRequestList.size();
    }

    public boolean hasBatchedOutputs() {
        return this.mHasBatchedOutputs;
    }
}

