/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.graphics.fonts.Font;
import android.graphics.fonts.FontCustomizationParser;
import android.graphics.fonts.FontFamily;
import android.graphics.fonts.SystemFonts;
import android.text.FontConfig;
import android.util.ArrayMap;
import android.util.Log;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Locale;

public class SystemFonts_Delegate {
    private static final String TAG = "SystemFonts_Delegate";
    private static String sFontLocation;
    public static boolean sIsTypefaceInitialized;

    public static void setFontLocation(String fontLocation) {
        sFontLocation = fontLocation;
    }

    @LayoutlibDelegate
    static FontConfig.Alias[] buildSystemFallback(String xmlPath, String fontDir, FontCustomizationParser.Result oemCustomization, ArrayMap<String, FontFamily[]> fallbackMap, ArrayList<Font> availableFonts) {
        sIsTypefaceInitialized = true;
        return SystemFonts.buildSystemFallback_Original(sFontLocation + "native/fonts.xml", sFontLocation, oemCustomization, fallbackMap, availableFonts);
    }

    @LayoutlibDelegate
    static ByteBuffer mmap(String fullPath) {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        if (osName.startsWith("windows")) {
            ByteBuffer byteBuffer;
            FileInputStream file = new FileInputStream(fullPath);
            try {
                FileChannel fileChannel = file.getChannel();
                int size = (int)fileChannel.size();
                ByteBuffer buffer = ByteBuffer.allocateDirect(size);
                fileChannel.read(buffer);
                byteBuffer = buffer;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        file.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Log.e(TAG, "Error mapping font file " + fullPath);
                    return null;
                }
            }
            file.close();
            return byteBuffer;
        }
        return SystemFonts.mmap_Original(fullPath);
    }

    static {
        sIsTypefaceInitialized = false;
    }
}

