/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.IBluetooth;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBluetoothManagerCallback
extends IInterface {
    public void onBluetoothServiceUp(IBluetooth var1) throws RemoteException;

    public void onBluetoothServiceDown() throws RemoteException;

    public void onBrEdrDown() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothManagerCallback {
        private static final String DESCRIPTOR = "android.bluetooth.IBluetoothManagerCallback";
        static final int TRANSACTION_onBluetoothServiceUp = 1;
        static final int TRANSACTION_onBluetoothServiceDown = 2;
        static final int TRANSACTION_onBrEdrDown = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetoothManagerCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothManagerCallback) {
                return (IBluetoothManagerCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onBluetoothServiceUp";
                }
                case 2: {
                    return "onBluetoothServiceDown";
                }
                case 3: {
                    return "onBrEdrDown";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    IBluetooth _arg0 = IBluetooth.Stub.asInterface(data.readStrongBinder());
                    this.onBluetoothServiceUp(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.onBluetoothServiceDown();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    this.onBrEdrDown();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IBluetoothManagerCallback impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IBluetoothManagerCallback getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IBluetoothManagerCallback {
            private IBinder mRemote;
            public static IBluetoothManagerCallback sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBluetoothServiceUp(IBluetooth bluetoothService) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(bluetoothService != null ? bluetoothService.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onBluetoothServiceUp(bluetoothService);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onBluetoothServiceDown() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onBluetoothServiceDown();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onBrEdrDown() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onBrEdrDown();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothManagerCallback {
        @Override
        public void onBluetoothServiceUp(IBluetooth bluetoothService) throws RemoteException {
        }

        @Override
        public void onBluetoothServiceDown() throws RemoteException {
        }

        @Override
        public void onBrEdrDown() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

