/*
 * Decompiled with CFR 0.152.
 */
package android.app.role;

import android.app.role.IOnRoleHoldersChangedListener;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteCallback;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IRoleManager
extends IInterface {
    public boolean isRoleAvailable(String var1) throws RemoteException;

    public boolean isRoleHeld(String var1, String var2) throws RemoteException;

    public List<String> getRoleHoldersAsUser(String var1, int var2) throws RemoteException;

    public void addRoleHolderAsUser(String var1, String var2, int var3, int var4, RemoteCallback var5) throws RemoteException;

    public void removeRoleHolderAsUser(String var1, String var2, int var3, int var4, RemoteCallback var5) throws RemoteException;

    public void clearRoleHoldersAsUser(String var1, int var2, int var3, RemoteCallback var4) throws RemoteException;

    public void addOnRoleHoldersChangedListenerAsUser(IOnRoleHoldersChangedListener var1, int var2) throws RemoteException;

    public void removeOnRoleHoldersChangedListenerAsUser(IOnRoleHoldersChangedListener var1, int var2) throws RemoteException;

    public void setRoleNamesFromController(List<String> var1) throws RemoteException;

    public boolean addRoleHolderFromController(String var1, String var2) throws RemoteException;

    public boolean removeRoleHolderFromController(String var1, String var2) throws RemoteException;

    public List<String> getHeldRolesFromController(String var1) throws RemoteException;

    public String getDefaultSmsPackage(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRoleManager {
        private static final String DESCRIPTOR = "android.app.role.IRoleManager";
        static final int TRANSACTION_isRoleAvailable = 1;
        static final int TRANSACTION_isRoleHeld = 2;
        static final int TRANSACTION_getRoleHoldersAsUser = 3;
        static final int TRANSACTION_addRoleHolderAsUser = 4;
        static final int TRANSACTION_removeRoleHolderAsUser = 5;
        static final int TRANSACTION_clearRoleHoldersAsUser = 6;
        static final int TRANSACTION_addOnRoleHoldersChangedListenerAsUser = 7;
        static final int TRANSACTION_removeOnRoleHoldersChangedListenerAsUser = 8;
        static final int TRANSACTION_setRoleNamesFromController = 9;
        static final int TRANSACTION_addRoleHolderFromController = 10;
        static final int TRANSACTION_removeRoleHolderFromController = 11;
        static final int TRANSACTION_getHeldRolesFromController = 12;
        static final int TRANSACTION_getDefaultSmsPackage = 13;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IRoleManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IRoleManager) {
                return (IRoleManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "isRoleAvailable";
                }
                case 2: {
                    return "isRoleHeld";
                }
                case 3: {
                    return "getRoleHoldersAsUser";
                }
                case 4: {
                    return "addRoleHolderAsUser";
                }
                case 5: {
                    return "removeRoleHolderAsUser";
                }
                case 6: {
                    return "clearRoleHoldersAsUser";
                }
                case 7: {
                    return "addOnRoleHoldersChangedListenerAsUser";
                }
                case 8: {
                    return "removeOnRoleHoldersChangedListenerAsUser";
                }
                case 9: {
                    return "setRoleNamesFromController";
                }
                case 10: {
                    return "addRoleHolderFromController";
                }
                case 11: {
                    return "removeRoleHolderFromController";
                }
                case 12: {
                    return "getHeldRolesFromController";
                }
                case 13: {
                    return "getDefaultSmsPackage";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.isRoleAvailable(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _result = this.isRoleHeld(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    List<String> _result = this.getRoleHoldersAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    RemoteCallback _arg4 = 0 != data.readInt() ? RemoteCallback.CREATOR.createFromParcel(data) : null;
                    this.addRoleHolderAsUser(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    RemoteCallback _arg4 = 0 != data.readInt() ? RemoteCallback.CREATOR.createFromParcel(data) : null;
                    this.removeRoleHolderAsUser(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    RemoteCallback _arg3 = 0 != data.readInt() ? RemoteCallback.CREATOR.createFromParcel(data) : null;
                    this.clearRoleHoldersAsUser(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    IOnRoleHoldersChangedListener _arg0 = IOnRoleHoldersChangedListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.addOnRoleHoldersChangedListenerAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    IOnRoleHoldersChangedListener _arg0 = IOnRoleHoldersChangedListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.removeOnRoleHoldersChangedListenerAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    this.setRoleNamesFromController(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _result = this.addRoleHolderFromController(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _result = this.removeRoleHolderFromController(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    List<String> _result = this.getHeldRolesFromController(_arg0);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _result = this.getDefaultSmsPackage(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IRoleManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IRoleManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IRoleManager {
            private IBinder mRemote;
            public static IRoleManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRoleAvailable(String roleName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(roleName);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isRoleAvailable(roleName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRoleHeld(String roleName, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isRoleHeld(roleName, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getRoleHoldersAsUser(String roleName, int userId) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<String> list = Stub.getDefaultImpl().getRoleHoldersAsUser(roleName, userId);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addRoleHolderAsUser(String roleName, String packageName, int flags, int userId, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    if (callback != null) {
                        _data.writeInt(1);
                        callback.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addRoleHolderAsUser(roleName, packageName, flags, userId, callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeRoleHolderAsUser(String roleName, String packageName, int flags, int userId, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    if (callback != null) {
                        _data.writeInt(1);
                        callback.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeRoleHolderAsUser(roleName, packageName, flags, userId, callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearRoleHoldersAsUser(String roleName, int flags, int userId, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    if (callback != null) {
                        _data.writeInt(1);
                        callback.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clearRoleHoldersAsUser(roleName, flags, userId, callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnRoleHoldersChangedListenerAsUser(IOnRoleHoldersChangedListener listener, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addOnRoleHoldersChangedListenerAsUser(listener, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnRoleHoldersChangedListenerAsUser(IOnRoleHoldersChangedListener listener, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeOnRoleHoldersChangedListenerAsUser(listener, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRoleNamesFromController(List<String> roleNames) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringList(roleNames);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setRoleNamesFromController(roleNames);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean addRoleHolderFromController(String roleName, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().addRoleHolderFromController(roleName, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeRoleHolderFromController(String roleName, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().removeRoleHolderFromController(roleName, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getHeldRolesFromController(String packageName) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<String> list = Stub.getDefaultImpl().getHeldRolesFromController(packageName);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getDefaultSmsPackage(int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getDefaultSmsPackage(userId);
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IRoleManager {
        @Override
        public boolean isRoleAvailable(String roleName) throws RemoteException {
            return false;
        }

        @Override
        public boolean isRoleHeld(String roleName, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public List<String> getRoleHoldersAsUser(String roleName, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void addRoleHolderAsUser(String roleName, String packageName, int flags, int userId, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void removeRoleHolderAsUser(String roleName, String packageName, int flags, int userId, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void clearRoleHoldersAsUser(String roleName, int flags, int userId, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void addOnRoleHoldersChangedListenerAsUser(IOnRoleHoldersChangedListener listener, int userId) throws RemoteException {
        }

        @Override
        public void removeOnRoleHoldersChangedListenerAsUser(IOnRoleHoldersChangedListener listener, int userId) throws RemoteException {
        }

        @Override
        public void setRoleNamesFromController(List<String> roleNames) throws RemoteException {
        }

        @Override
        public boolean addRoleHolderFromController(String roleName, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean removeRoleHolderFromController(String roleName, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public List<String> getHeldRolesFromController(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public String getDefaultSmsPackage(int userId) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

