/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser.androidPlugin;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MergingExceptionParser
implements PatternAwareOutputParser {
    public boolean parse(@NotNull String line, @NotNull OutputLineReader reader, @NotNull List<Message> messages, @NotNull ILogger logger) throws ParsingFailedException {
        String path;
        int messageIndex;
        boolean hasError = false;
        Message.Kind kind = null;
        if (line.contains("rror: ")) {
            messageIndex = line.indexOf(": Error: ");
            if (messageIndex == -1 && (messageIndex = line.indexOf(": error: ")) == -1 && (messageIndex = line.indexOf(": fatal error: ")) == -1) {
                return false;
            }
            kind = Message.Kind.ERROR;
        } else if (line.contains("arning: ")) {
            messageIndex = line.indexOf(": Warning: ");
            if (messageIndex == -1 && (messageIndex = line.indexOf(": warning: ")) == -1) {
                return false;
            }
            kind = Message.Kind.WARNING;
        } else {
            return false;
        }
        int lineNumber = -1;
        int column = -1;
        int colon = line.lastIndexOf(58, messageIndex - 1);
        if (colon != -1) {
            int colon2 = line.lastIndexOf(58, colon - 1);
            if (colon2 != -1) {
                String columnString = line.substring(colon + 1, messageIndex);
                String lineString = line.substring(colon2 + 1, colon);
                try {
                    column = Integer.parseInt(columnString);
                    lineNumber = Integer.parseInt(lineString);
                }
                catch (NumberFormatException e) {
                    if (colon2 == 1) {
                        String p = line.substring(0, colon);
                        if (new File(p).exists()) {
                            colon2 = colon;
                        }
                        return false;
                    }
                    return false;
                }
                path = line.substring(0, colon2);
            } else {
                try {
                    lineNumber = Integer.parseInt(line.substring(colon + 1, messageIndex));
                }
                catch (NumberFormatException e) {
                    if (colon == 1) {
                        String p = line.substring(0, messageIndex);
                        if (new File(p).exists()) {
                            colon = messageIndex;
                        }
                        return false;
                    }
                    return false;
                }
                path = line.substring(0, colon);
            }
        } else {
            path = line.substring(0, messageIndex);
        }
        String message = line.substring(messageIndex + 2);
        messages.add(new Message(kind, message, new SourceFilePosition(new File(path), new SourcePosition(lineNumber - 1, column - 1, -1)), new SourceFilePosition[0]));
        return true;
    }
}

