/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.ui.ChangesBrowserWithRollback;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class LocalChangesWouldBeOverwrittenHelper {
    @NotNull
    private static String getErrorNotificationDescription() {
        return LocalChangesWouldBeOverwrittenHelper.getErrorDescription(true);
    }

    @NotNull
    private static String getErrorDialogDescription() {
        return LocalChangesWouldBeOverwrittenHelper.getErrorDescription(false);
    }

    @NotNull
    private static String getErrorDescription(boolean forNotification) {
        String line1 = "Your local changes would be overwritten by merge.";
        String line2 = "Commit, stash or revert them to proceed.";
        if (forNotification) {
            return line1 + "<br/>" + line2 + " <a href='view'>View them</a>";
        }
        return line1 + "\n" + line2;
    }

    public static void showErrorNotification(final @NotNull Project project, @NotNull VirtualFile root, final @NotNull String operationName, @NotNull Collection<String> relativeFilePaths) {
        final Collection<String> absolutePaths = GitUtil.toAbsolute(root, relativeFilePaths);
        final List<Change> changes = GitUtil.findLocalChangesForPaths(project, root, absolutePaths, false);
        String notificationTitle = "Git " + StringUtil.capitalize((String)operationName) + " Failed";
        VcsNotifier.getInstance((Project)project).notifyError(notificationTitle, LocalChangesWouldBeOverwrittenHelper.getErrorNotificationDescription(), (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                LocalChangesWouldBeOverwrittenHelper.showErrorDialog(project, operationName, changes, (Collection<String>)absolutePaths);
            }
        });
    }

    @Deprecated
    public static void showErrorDialog(@NotNull Project project, @NotNull VirtualFile root, @NotNull String operationName, @NotNull Collection<String> relativeFilePaths) {
        Collection<String> absolutePaths = GitUtil.toAbsolute(root, relativeFilePaths);
        List<Change> changes = GitUtil.findLocalChangesForPaths(project, root, absolutePaths, false);
        LocalChangesWouldBeOverwrittenHelper.showErrorDialog(project, operationName, changes, absolutePaths);
    }

    private static void showErrorDialog(@NotNull Project project, @NotNull String operationName, @NotNull List<? extends Change> changes, @NotNull Collection<String> absolutePaths) {
        String title = "Local Changes Prevent from " + StringUtil.capitalize((String)operationName);
        String description = LocalChangesWouldBeOverwrittenHelper.getErrorDialogDescription();
        if (changes.isEmpty()) {
            GitUtil.showPathsInDialog(project, absolutePaths, title, description);
        } else {
            ChangesBrowserWithRollback changesViewer = new ChangesBrowserWithRollback(project, changes);
            DialogBuilder builder = new DialogBuilder(project);
            builder.setNorthPanel((JComponent)new MultiLineLabel(description));
            builder.setCenterPanel((JComponent)((Object)changesViewer));
            builder.addDisposable((Disposable)changesViewer);
            builder.addOkAction();
            builder.setTitle(title);
            builder.show();
        }
    }
}

